/******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 412:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

const {
  version
} = __webpack_require__(157);
const fontsCDN = `https://www.aexp-static.com/cdaas/one/statics/@americanexpress/dls-fonts/${version}/package/dist/fonts`;
module.exports = {
  fontsCDN
};

/***/ }),

/***/ 580:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";

;// CONCATENATED MODULE: ./source/scripts/polyfills.js
// forEach()
const forEachPoly = function () {
  if (window.NodeList && !NodeList.prototype.forEach) {
    NodeList.prototype.forEach = Array.prototype.forEach;
  }
};

// isNaN()
const isNaNPoly = function () {
  Number.isNaN = Number.isNaN || function isNaN(input) {
    return typeof input === 'number' && input !== input;
  };
};

// EndsWith()
const endsWithPoly = function () {
  if (!String.prototype.endsWith) {
    String.prototype.endsWith = function (search, this_len) {
      if (this_len === undefined || this_len > this.length) {
        this_len = this.length;
      }
      return this.substring(this_len - search.length, this_len) === search;
    };
  }
};

// Before()
const beforePoly = function (arr) {
  arr.forEach(item => {
    if (item.hasOwnProperty('before')) {
      return;
    }
    Object.defineProperty(item, 'before', {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function before() {
        const argArr = Array.prototype.slice.call(arguments);
        const docFrag = document.createDocumentFragment();
        argArr.forEach(argItem => {
          const isNode = argItem instanceof Node;
          docFrag.appendChild(isNode ? argItem : document.createTextNode(String(argItem)));
        });
        this.parentNode.insertBefore(docFrag, this);
      }
    });
  });
};

// Remove()
const afterPoly = function (arr) {
  arr.forEach(item => {
    if (item.hasOwnProperty('remove')) {
      return;
    }
    Object.defineProperty(item, 'remove', {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function remove() {
        if (this.parentNode !== null) {
          this.parentNode.removeChild(this);
        }
      }
    });
  });
};
forEachPoly();
isNaNPoly();
endsWithPoly();
beforePoly([Element.prototype, CharacterData.prototype, DocumentType.prototype]);
afterPoly([Element.prototype, CharacterData.prototype, DocumentType.prototype]);
;// CONCATENATED MODULE: ./source/scripts/components/accordion.js
class Accordion {
  constructor(params) {
    if (!params.target) {
      throw new Error('Accordion: Please provide a valid target! - {target: elemSelector, config: (optional)}');
    }
    this.selectors = {
      target: params.target,
      content: document.querySelector(`[aria-labelledby="${params.target.id}"]`),
      toggleLink: params.target.classList.contains('toggle-link') || params.target.classList.contains('toggle-button'),
      toggleLinkClose: document.querySelector(`[aria-labelledby="${params.target.id}"]`) && document.querySelector(`[aria-labelledby="${params.target.id}"]`).querySelector('.toggle-close-link'),
      expandable: document.querySelector(`[aria-labelledby="${params.target.id}"]`).querySelector('[data-expandable]')
    };
    this.model = {
      expanded: this.selectors.target.getAttribute('aria-expanded'),
      icon: this.selectors.target.querySelector('.icon'),
      iconClass: ''
    };
    if (this.model.icon) {
      var _this$model$icon$clas;
      // when consuming dls-icons the regex will not match anything since
      // it won't use the dls-icon-<name> format from icon fonts
      // the optional chaining operator returns undefined instead of an error
      this.model.iconClass = (_this$model$icon$clas = this.model.icon.className.match(/(?=dls-icon)([a-z-]+)/)) === null || _this$model$icon$clas === void 0 ? void 0 : _this$model$icon$clas[0];
    }
    if (this.model.expanded === 'true') {
      this.open();
    } else {
      this.close();
      this.selectors.content.classList.add('display-none');
    }
    this.selectors.target.onclick = () => {
      this.toggle();
    };

    // TODO: deprecate toggleLinkClose since the .toggle-close-link class does not exist
    // and funcitonality should not be tied to non-existant classnames
    if (this.selectors.toggleLinkClose) {
      this.selectors.toggleLinkClose.onclick = () => {
        this.toggle();
      };
    }
    if (this.selectors.expandable) {
      this.selectors.expandable.onclick = () => {
        this.toggle();
      };
    }
    window.addEventListener('resize', () => {
      if (this.model.expanded === 'true') {
        this.updateContentHeight();
      }
    });
  }
  toggle() {
    if (this.model.expanded === 'true') {
      this.close();
      const displayNone = () => {
        this.selectors.content.classList.add('display-none');
        this.selectors.content.removeEventListener('transitionend', displayNone);
      };
      this.selectors.content.addEventListener('transitionend', displayNone);
    } else {
      this.open();
    }
  }
  open() {
    this.selectors.content.classList.remove('display-none');
    this.selectors.target.setAttribute('aria-expanded', 'true');
    this.model.expanded = 'true';
    this.updateContentHeight();
    if (this.selectors.toggleLink && this.selectors.target.querySelector('span')) {
      this.selectors.target.querySelector('span').innerHTML = 'Hide Details';
    }
    if (this.selectors.toggleLink && !this.selectors.target.querySelector('span')) {
      this.selectors.target.innerText = 'Hide Details';
    }
    if (this.selectors.toggleLink) {
      // conditional check for backwards compatibility with original aria-labels that said Show/hide
      if (!this.selectors.target.getAttribute('aria-label').includes('/')) {
        var _this$selectors$targe;
        this.selectors.target.ariaLabel = (_this$selectors$targe = this.selectors.target.ariaLabel) === null || _this$selectors$targe === void 0 ? void 0 : _this$selectors$targe.replace('Show', 'Hide');
      }
    }
    if (this.selectors.toggleLinkClose) {
      this.selectors.target.classList.add('display-none');
    }
    if (this.model.icon && this.model.iconClass) {
      this.model.icon.classList.remove(this.model.iconClass);
      this.model.icon.classList.add(`${this.model.iconClass}-filled`);
    }
  }
  updateContentHeight() {
    this.selectors.content.style.maxHeight = `${this.selectors.content.scrollHeight}px`;
  }
  close() {
    this.selectors.target.setAttribute('aria-expanded', 'false');
    this.model.expanded = 'false';
    this.selectors.content.style.maxHeight = '0px';
    if (this.selectors.toggleLink && this.selectors.target.querySelector('span')) {
      this.selectors.target.querySelector('span').innerHTML = 'Show Details';
    }
    if (this.selectors.toggleLink && !this.selectors.target.querySelector('span')) {
      this.selectors.target.innerText = 'Show Details';
    }
    if (this.selectors.toggleLink) {
      var _this$selectors$targe2;
      this.selectors.target.ariaLabel = (_this$selectors$targe2 = this.selectors.target.ariaLabel) === null || _this$selectors$targe2 === void 0 ? void 0 : _this$selectors$targe2.replace('Hide', 'Show');
    }
    if (this.selectors.toggleLinkClose) {
      this.selectors.target.classList.remove('display-none');
    }
    if (this.model.icon && this.model.iconClass) {
      this.model.icon.classList.add(this.model.iconClass);
      this.model.icon.classList.remove(`${this.model.iconClass}-filled`);
    }
  }
}
/* harmony default export */ var accordion = (Accordion);
;// CONCATENATED MODULE: ./source/shared/breakpoints.json
var breakpoints_namespaceObject = /*#__PURE__*/JSON.parse('{"f":{"xs":"0","sm":"375px","md":"768px","lg":"1024px","xl":"1280px"}}');
;// CONCATENATED MODULE: ./source/scripts/utilities/current-breakpoint.js

const currentBreakpoint = windowWidth => {
  const keyArr = Object.keys(breakpoints_namespaceObject.f);
  for (let i = keyArr.length - 1; i >= 0; i -= 1) {
    const bp = keyArr[i];
    const bpWidth = Number(breakpoints_namespaceObject.f[bp].replace(/[a-z]/ig, ''));
    if (windowWidth >= bpWidth) {
      return bp;
    }
  }
};
/* harmony default export */ var current_breakpoint = (currentBreakpoint);
;// CONCATENATED MODULE: ./source/scripts/utilities/debounce.js
const debounce = (func, wait) => {
  let timeout;
  return function executedFunction() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    const later = () => {
      clearTimeout(timeout);
      func(...args);
    };
    clearTimeout(timeout);
    timeout = setTimeout(later, wait);
  };
};
/* harmony default export */ var utilities_debounce = (debounce);
;// CONCATENATED MODULE: ./source/scripts/components/carousel.js


class Carousel {
  constructor(params) {
    if (!params.target) {
      throw new Error('Carousel: Please provide a valid target! - {target: elemSelector, config: (optional)}');
    }
    this.selectors = {
      target: params.target,
      inner: params.target.getElementsByClassName('carousel-inner')[0],
      next: params.target.querySelector('[data-control="next"]'),
      prev: params.target.querySelector('[data-control="prev"]'),
      indicators: params.target.getElementsByClassName('carousel-indicators')[0],
      controls: params.target.getElementsByClassName('carousel-controls')[0],
      play: params.target.querySelector('[data-control="play"]'),
      pause: params.target.querySelector('[data-control="pause"]')
    };
    this.model = {
      autoplay: this.selectors.target.hasAttribute('data-autoplay') ? this.selectors.target.getAttribute('data-autoplay') === 'true' : false,
      paused: this.selectors.target.hasAttribute('data-paused') ? this.selectors.target.getAttribute('data-paused') === 'true' : false,
      animate: this.selectors.target.hasAttribute('data-animate') ? this.selectors.target.getAttribute('data-animate') === 'true' : true,
      interval: Number(this.selectors.target.getAttribute('data-interval')) || 5000,
      current: Number(this.selectors.target.getAttribute('data-current')) || 0,
      total: this.selectors.target.getElementsByClassName('carousel-item').length
    };
    if (this.selectors.next && this.selectors.next.children.length) {
      this.selectors.next.classList.add('no-icon');
    }
    if (this.selectors.prev && this.selectors.prev.children.length) {
      this.selectors.prev.classList.add('no-icon');
    }
    if (this.selectors.play && this.selectors.play.children.length) {
      this.selectors.play.classList.add('no-icon');
    }
    if (this.selectors.pause && this.selectors.pause.children.length) {
      this.selectors.pause.classList.add('no-icon');
    }
    let startX;
    let startY;
    let distX;
    let distY;
    const threshold = 150;
    const restraint = 100;
    this.selectors.target.addEventListener('touchstart', e => {
      const touchobj = e.changedTouches[0];
      startX = touchobj.clientX;
      startY = touchobj.clientY;
    }, false);
    this.selectors.target.addEventListener('touchend', e => {
      const touchobj = e.changedTouches[0];
      distX = touchobj.clientX - startX;
      distY = touchobj.clientY - startY;
      if (Math.abs(distX) >= threshold && Math.abs(distY) <= restraint) {
        if (distX < 0) {
          this.next();
        } else {
          this.prev();
        }
      }
    }, false);
    this.selectors.next.addEventListener('click', () => {
      this.next();
      this.pause();
    });
    this.selectors.prev.addEventListener('click', () => {
      this.prev();
      this.pause();
    });
    if (this.selectors.play && this.selectors.pause) {
      this.selectors.play.addEventListener('click', () => {
        this.play();
      });
      this.selectors.pause.addEventListener('click', () => {
        this.pause();
      });
    }
    this.updatePlayState();
    this.selectors.target.addEventListener('keydown', e => {
      if (/input|textarea/i.test(e.target.tagName)) {
        return;
      }
      if (e.key.match(/ArrowLeft|Left/i)) {
        e.preventDefault();
        this.prev();
        this.pause();
      }
      if (e.key.match(/ArrowRight|Right/i)) {
        e.preventDefault();
        this.next();
        this.pause();
      }
    });
    if (this.selectors.target.classList.contains('carousel-multi-card')) {
      this.multiCard();
    }
    this.changeActiveSlide(this.model.current);
    this.renderIndicators();
    this.darkenIndicators();
    this.cycle();
  }
  cycle() {
    if (!this.model.autoplay || this.model.paused) return;
    clearInterval(this.timeout);
    this.timeout = setInterval(() => {
      this.next();
    }, this.model.interval);
  }
  next() {
    const nextInx = this.model.current + 1 < this.model.total ? this.model.current + 1 : 0;
    this.changeActiveSlide(nextInx, 'right');
  }
  prev() {
    const nextInx = this.model.current - 1 < 0 ? this.model.total - 1 : this.model.current - 1;
    this.changeActiveSlide(nextInx, 'left');
  }
  pause() {
    clearInterval(this.timeout);
    this.model.paused = true;
    this.updatePlayState();
    if (this.selectors.play) {
      this.selectors.play.focus();
    }
  }
  play() {
    this.model.paused = false;
    this.updatePlayState();
    this.cycle();
    if (this.selectors.pause) {
      this.selectors.pause.focus();
    }
  }
  updatePlayState() {
    if (this.selectors.play && this.selectors.pause) {
      const prevVisibleControl = this.model.paused ? this.selectors.pause : this.selectors.play;
      const nextVisibleControl = this.model.paused ? this.selectors.play : this.selectors.pause;
      prevVisibleControl.setAttribute('hidden', true);
      nextVisibleControl.removeAttribute('hidden');
      if (document.activeElement === prevVisibleControl) {
        nextVisibleControl.focus();
      }
    }
    this.selectors.target.setAttribute('data-paused', this.model.paused);
  }
  getSlide(i) {
    return this.selectors.target.getElementsByClassName('carousel-item')[i];
  }
  lazyLoad(slide) {
    const backgroundImgEl = slide.querySelector('[data-img]');
    if (backgroundImgEl) {
      backgroundImgEl.style.backgroundImage = `url('${backgroundImgEl.dataset.img}')`;
      backgroundImgEl.removeAttribute('data-img');
    }
  }
  multiCard() {
    const initSlide = this.getSlide(0).cloneNode(true);
    const multiCardShuffle = () => {
      const slideWidth = this.getSlide(0).getBoundingClientRect().width;
      const childWidth = this.getSlide(0).children[0].children[0].getBoundingClientRect().width;
      const childrenPerSlide = Math.floor(slideWidth / childWidth);
      this.selectors.inner.innerHTML = '';
      this.model.current = 0;
      let newSlideRow = null;
      for (let i = 0; i < initSlide.children[0].children.length; i += 1) {
        if (i % childrenPerSlide === 0) {
          newSlideRow = document.createElement('ul');
          newSlideRow.classList.add('row', 'flex-no-wrap');
          newSlideRow.style['list-style-type'] = 'none';
          const newSlide = this.addSlide(initSlide.classList);
          newSlide.appendChild(newSlideRow);
        }
        const slideItem = initSlide.children[0].children[i].cloneNode(true);

        // in order to ensure slideItem is <li>,
        // create newSlideItem and copy over children/attributes
        const newSlideItem = document.createElement('li');

        // move children from slideItem to newSlideItem
        while (slideItem.firstChild) {
          newSlideItem.appendChild(slideItem.firstChild);
        }

        // copy attributes from slideItem to newSlideItem
        Array.from(slideItem.attributes).forEach(_ref => {
          let {
            name,
            value
          } = _ref;
          return newSlideItem.setAttribute(name, value);
        });
        newSlideRow.appendChild(newSlideItem);
      }
      this.changeActiveSlide(0);
      this.darkenIndicators();
    };
    multiCardShuffle();
    let currentBp = current_breakpoint(window.innerWidth);
    window.addEventListener('resize', utilities_debounce(() => {
      if (currentBp !== current_breakpoint(window.innerWidth)) {
        multiCardShuffle();
        currentBp = current_breakpoint(window.innerWidth);
      }
    }, 50));
  }
  addSlide(slideClassList) {
    const newSlide = document.createElement('li');
    [].slice.call(slideClassList).forEach(val => {
      newSlide.classList.add(val);
    });
    newSlide.setAttribute('aria-hidden', 'false');
    this.selectors.inner.appendChild(newSlide);
    this.model.total = this.selectors.target.getElementsByClassName('carousel-item').length;
    this.renderIndicators();
    return newSlide;
  }
  changeActiveSlide(i, direction) {
    if (i === this.model.current) return;
    const prev = this.model.current;
    const next = i;
    const prevActive = this.getSlide(prev);
    const nextActive = this.getSlide(next);
    this.lazyLoad(nextActive);
    const prevIndicator = this.selectors.indicators.querySelector('li[aria-current]');
    const nextIndicator = this.selectors.indicators.querySelector(`li[aria-label="slide ${next + 1}"]`);
    prevIndicator.removeAttribute('aria-current');
    nextIndicator.setAttribute('aria-current', 'true');
    this.slideInAnimation(prev, next, direction);
    prevActive.setAttribute('aria-hidden', true);
    nextActive.setAttribute('aria-hidden', false);
    this.model.current = next;
    this.darkenIndicators();
  }
  renderIndicators() {
    this.selectors.indicators.innerHTML = '';
    [].slice.call(this.selectors.target.getElementsByClassName('carousel-item')).forEach((item, i) => {
      const li = document.createElement('li');
      if (i === this.model.current) {
        li.setAttribute('aria-current', 'true');
      }
      li.setAttribute('aria-label', `slide ${i + 1}`);
      this.selectors.indicators.appendChild(li);
    });
  }
  darkenIndicators() {
    const currSlide = this.getSlide(this.model.current);
    if (currSlide.querySelector('.overlay-white') && !this.selectors.controls.classList.contains('dark-controls')) {
      this.selectors.controls.classList.add('dark-controls');
    } else if (currSlide.querySelector('.overlay-blue') || currSlide.querySelector('.overlay-black')) {
      this.selectors.controls.classList.remove('dark-controls');
    }
  }
  slideInAnimation(prev, next) {
    let dir = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    if (this.model.animate) {
      let direction = dir;
      if (direction === null) {
        if (prev === 0 && next === this.model.total - 1) {
          direction = 'left';
        } else if (prev === this.model.total - 1 && next === 0) {
          direction = 'right';
        } else if (next > prev) {
          direction = 'right';
        } else {
          direction = 'left';
        }
      }
      const clone = this.getSlide(prev).cloneNode(true);
      clone.classList.add('carousel-item-prev');
      clone.classList.remove('carousel-item');
      clone.classList.remove('anim-slide-from-right');
      clone.classList.remove('anim-slide-from-left');
      clone.removeAttribute('aria-hidden');
      this.selectors.inner.appendChild(clone);
      this.getSlide(next).classList.add(`anim-slide-from-${direction}`);
      this.getSlide(prev).classList.remove('anim-slide-from-right');
      this.getSlide(prev).classList.remove('anim-slide-from-left');
      this.getSlide(next).addEventListener('animationend', () => {
        [].slice.call(this.selectors.target.querySelectorAll('.carousel-item-prev')).forEach(oldClone => {
          oldClone.remove();
        });
      });
    }
  }
}
/* harmony default export */ var carousel = (Carousel);
;// CONCATENATED MODULE: ./source/scripts/components/cardfield.js
class Cardfield {
  constructor(params) {
    if (!params.target) {
      throw new Error('Cardfield: No target element passed');
    }
    this.selectors = {
      target: params.target,
      card: params.target.getElementsByClassName('dls-card-field')[0],
      number: params.target.getElementsByClassName('dls-card-field-number')[0],
      cid: params.target.getElementsByClassName('dls-card-field-cid')[0],
      csc: params.target.getElementsByClassName('dls-card-field-csc')[0],
      alert: '',
      message: ''
    };
    this.model = {
      success: params.target.hasAttribute('data-success') || false,
      number: params.target.querySelector('[data-card-number]'),
      cid: params.target.querySelector('[data-card-cid]'),
      csc: params.target.querySelector('[data-card-csc]')
    };
    this.setup();
    this.model.number.onfocus = () => {
      this.reset();
      this.selectors.card.classList.add('dls-card-field-focus');
      this.selectors.card.classList.add('dls-card-field-focus-number');
    };
    this.model.cid.onfocus = () => {
      this.reset();
      this.selectors.card.classList.add('dls-card-field-focus');
      this.selectors.card.classList.add('dls-card-field-focus-cid');
    };
    this.model.csc.onfocus = () => {
      this.reset();
      this.selectors.card.classList.add('dls-card-field-focus');
      this.selectors.card.classList.add('dls-card-field-focus-csc');
      this.selectors.card.classList.add('dls-card-field-focus-reverse');
    };
    this.model.number.onblur = () => {
      this.reset();
      this.validateRequired(this.model.number, 'number');
    };
    this.model.cid.onblur = () => {
      this.reset();
      this.validateRequired(this.model.cid, 'cid');
    };
    this.model.csc.onblur = () => {
      this.reset();
      this.validateRequired(this.model.csc, 'csc');
    };
    this.model.number.onkeydown = e => {
      this.keyRules(e);
    };
    this.model.number.onkeyup = () => {
      this.selectors.number.innerHTML = this.model.number.value ? this.model.number.value.replace(/(\d{4})(\d{6})?(\d{5})?/, '$1 $2 $3') : this.model.number.placeholder;
    };
    this.model.cid.onkeydown = e => {
      this.keyRules(e);
    };
    this.model.cid.onkeyup = () => {
      this.selectors.cid.innerHTML = this.model.cid.value ? this.model.cid.value : this.model.cid.placeholder;
    };
    this.model.csc.onkeydown = e => {
      this.keyRules(e);
    };
    this.model.csc.onkeyup = () => {
      this.selectors.csc.innerHTML = this.model.csc.value ? this.model.csc.value : this.model.csc.placeholder;
    };
  }
  setup() {
    if (!this.model.number.placeholder) {
      this.model.number.placeholder = '1234 567890 12345';
    }
    if (!this.model.cid.placeholder) {
      this.model.cid.placeholder = '1234';
    }
    if (!this.model.csc.placeholder) {
      this.model.csc.placeholder = '123';
    }
    this.selectors.number.innerHTML = this.model.number.value ? this.model.number.value : this.model.number.placeholder;
    this.selectors.cid.innerHTML = this.model.cid.value ? this.model.cid.value : this.model.cid.placeholder;
    this.selectors.csc.innerHTML = this.model.csc.value ? this.model.csc.value : this.model.csc.placeholder;
  }
  reset() {
    this.selectors.card.classList.remove('dls-card-field-focus');
    this.selectors.card.classList.remove('dls-card-field-focus-reverse');
    this.selectors.card.classList.remove('dls-card-field-focus-number');
    this.selectors.card.classList.remove('dls-card-field-focus-cid');
    this.selectors.card.classList.remove('dls-card-field-focus-csc');
  }
  keyRules(e) {
    if (e.key.match(/delete|backspace|arrow/i)) {
      return;
    }
    if (e.key.match(/enter|tab/i)) {
      this.reset();
      return;
    }
    if (e.key.match(/[^\d]/) && !e.metaKey && !e.ctrlKey) {
      e.preventDefault();
      e.stopPropagation();
    }
  }
  validateRequired(input, dataType) {
    this.selectors.alert = input.getAttribute('aria-describedby') ? input.getAttribute('aria-describedby').split(' ')[0] : '';
    this.selectors.message = this.selectors.alert ? this.selectors.target.querySelector(`#${this.selectors.alert}`) : '';
    if (!input.value.length) {
      this.selectors.card.classList.remove(`dls-card-field-has-${dataType}`);
    } else {
      this.selectors.card.classList.add(`dls-card-field-has-${dataType}`);
    }
    if (input.value.length < input.maxLength) {
      input.classList.remove('form-control-success');
      if (input.required && !input.classList.contains('form-control-warning')) {
        input.classList.add('form-control-warning');
      }
      if (input.required && this.selectors.alert && this.selectors.message) {
        this.selectors.message.classList.remove('hidden');
      }
    } else {
      input.classList.remove('form-control-warning');
      if (this.selectors.alert && this.selectors.message && !this.selectors.message.classList.contains('hidden')) {
        this.selectors.message.classList.add('hidden');
      }
      if (this.model.success && !input.classList.contains('form-control-success')) {
        input.classList.add('form-control-success');
      }
    }
  }
}
/* harmony default export */ var cardfield = (Cardfield);
;// CONCATENATED MODULE: ./source/scripts/components/checkboxgroup.js
class Checkboxgroup {
  constructor(params) {
    if (!params.target) {
      throw new Error('Checkbox Group: No target element passed');
    }
    this.selectors = {
      target: params.target,
      indeterminate: params.target.querySelector('[data-indeterminate]'),
      subCheckboxes: [].slice.call(params.target.querySelectorAll('input[type="checkbox"]'))
    };
    this.selectors.subCheckboxes.splice(0, 1);
    this.checkMixed(this.selectors.indeterminate, this.selectors.subCheckboxes);
    if (this.selectors.indeterminate.disabled) {
      this.disabled();
    }
    this.selectors.target.addEventListener('change', e => {
      let check = e.target;
      // Check if group is a nested list
      if (this.selectors.target.querySelectorAll('[data-indeterminate]').length === 1) {
        if (check === this.selectors.indeterminate) {
          this.selectors.subCheckboxes.forEach(child => {
            child.checked = check.checked;
          });
        }
        this.checkMixed(this.selectors.indeterminate, this.selectors.subCheckboxes);
      } else {
        const children = this.getCheckboxes(check.closest('li'));
        children.forEach(child => {
          child.checked = check.checked;
        });
        while (check) {
          const parent = check.closest(['ul']).parentNode.querySelector('input[type="checkbox"]');
          const siblings = this.getCheckboxes(parent.closest('li').querySelector(['ul']));
          this.checkMixed(parent, siblings);
          check = check !== parent ? parent : 0;
        }
      }
    });
  }
  getCheckboxes(parent) {
    return [].slice.call(parent.querySelectorAll('input[type="checkbox"]'));
  }
  checkMixed(parent, siblings) {
    const hasChecked = siblings.some(cbx => cbx.checked);
    const hasUnchecked = siblings.some(cbx => !cbx.checked);
    const mixed = hasChecked && hasUnchecked;
    if (mixed) {
      parent.checked = true;
      parent.setAttribute('aria-checked', 'mixed');
    } else {
      parent.checked = hasChecked;
      parent.removeAttribute('aria-checked');
      siblings.forEach(checkbox => {
        checkbox.removeAttribute('aria-checked');
      });
    }
  }
  setDisabled() {
    let disabled = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    this.selectors.indeterminate.disabled = disabled;
    this.selectors.subCheckboxes.forEach(child => {
      child.disabled = disabled;
    });
  }
  disabled() {
    this.setDisabled(true);
  }
  enabled() {
    this.setDisabled(false);
  }
}
/* harmony default export */ var checkboxgroup = (Checkboxgroup);
;// CONCATENATED MODULE: ./source/scripts/components/copy.js
class Copyfield {
  constructor(params) {
    if (!params.target) {
      throw new Error('Copyfield: No target element passed');
    }
    this.selectors = {
      target: params.target,
      field: params.target.getElementsByClassName('copy-field')[0],
      input: params.target.querySelector('input'),
      button: params.target.querySelector('button.side-btn')
    };
    this.model = {
      copied: false,
      successMsg: params.target.querySelector('[data-success]'),
      errorMsg: params.target.querySelector('[data-error]')
    };
    this.selectors.button.onclick = e => {
      // prevents from redirecting to link onclick
      e.preventDefault();
      this.copyText();
      this.model.copied ? this.copySuccess() : this.copyError();
      setTimeout(() => {
        this.reset();
      }, 6000);
    };
  }
  copyText() {
    try {
      this.selectors.input.select();
      document.execCommand('copy');
      this.model.copied = true;
    } catch (err) {
      this.model.copied = false;
    }
  }
  copySuccess() {
    this.selectors.field.classList.add('success');
    this.selectors.field.classList.remove('warning');
    if (this.model.successMsg) {
      this.model.successMsg.classList.remove('hidden');
      this.selectors.input.setAttribute('aria-describedby', this.model.successMsg.id);
    }
    if (this.model.errorMsg) {
      this.model.errorMsg.classList.add('hidden');
    }
  }
  copyError() {
    this.selectors.field.classList.remove('success');
    this.selectors.field.classList.add('warning');
    if (this.model.successMsg) {
      this.model.successMsg.classList.add('hidden');
    }
    if (this.model.errorMsg) {
      this.selectors.input.setAttribute('aria-describedby', this.model.errorMsg.id);
      this.model.errorMsg.classList.remove('hidden');
    }
  }
  reset() {
    this.selectors.field.classList.remove('success');
    this.selectors.field.classList.remove('warning');
  }
}
/* harmony default export */ var copy = (Copyfield);
;// CONCATENATED MODULE: ./source/scripts/models/currency.js
const currencies = {
  'en-EU': 'EUR',
  'en-EI': 'EUR',
  'en-US': 'USD',
  'de-DE': 'EUR',
  'en-DE': 'EUR',
  'en-IN': 'INR',
  'ja-JP': 'JPY',
  'sv-SE': 'SEK',
  'zh-HK': 'HKD',
  'en-HK': 'HKD',
  'en-CA': 'CAD',
  'fr-CA': 'CAD',
  'es-AR': 'ARS',
  'sv-FI': 'EUR',
  'fi-FI': 'EUR',
  'da-DK': 'DKK',
  'ms-MY': 'MYR',
  'nl-NL': 'EUR',
  'en-PH': 'PHP',
  'es-ES': 'EUR',
  'pt-BR': 'BRL',
  'en-GB': 'GBP',
  'en-SG': 'SGD',
  'en-AU': 'AUD'
};
/* harmony default export */ var currency = (currencies);
;// CONCATENATED MODULE: ./source/scripts/components/currencyfield.js

class Currencyfield {
  constructor(params) {
    if (!params.target) {
      throw new Error('Currencyfield: No target element passed');
    }
    this.currencies = currency;
    this.currencySymbol = '';
    this.currencyFormat = '';
    this.selectors = {
      target: params.target,
      field: params.target.getElementsByClassName('currency-field')[0],
      input: params.target.getElementsByTagName('input')[0],
      symbol: params.target.getElementsByClassName('form-unit')[0],
      message: params.target.getElementsByTagName('input')[0].getAttribute('aria-describedby')
    };
    this.model = {
      cents: params.target.dataset.cents || true,
      float: params.target.dataset.float || false,
      currency: params.target.dataset.currency || 'en-US',
      validation: params.target.dataset.validation,
      validationId: params.target.dataset.validationId,
      success: params.target.dataset.success
    };

    // validate currency locale
    if (!this.currencies[this.model.currency]) {
      this.model.currency = 'en-US';
      console.warn('invalid currency');
    }

    // initiate placeholder and currency symbol
    this.setPlaceholder();
    this.setSymbol();
    this.setAlignment();
    this.getAlerts();
    this.setAccessibleNameForCurrenyInputField();

    // format value
    if (this.selectors.input.value) {
      this.selectors.input.value = this.formatCurrency(this.selectors.input.value);
    }
    this.selectors.input.onfocus = () => {
      this.selectors.field.classList.add('focus');
      this.selectors.target.classList.remove('has-warning');
    };
    this.selectors.input.onblur = () => {
      this.selectors.field.classList.remove('focus');
      this.selectors.input.value = this.formatCurrency(this.selectors.input.value);
      this.validateRequired();
      if (!this.selectors.target.classList.contains('has-warning')) {
        this.validateData();
      }
    };
    this.selectors.input.onkeydown = e => {
      if (e.key.match(/enter|escape|esc|tab/i)) {
        return this.selectors.input.blur();
      }
      const regex = this.model.cents && !(this.model.cents === 'false') ? /[0-9]|backspace|delete|arrowRight|arrowLeft|\.|,/i : /[0-9]|backspace|delete|arrowRight|arrowLeft/i;
      if (!e.key.match(regex) && !e.metaKey && !e.ctrlKey) {
        e.preventDefault();
      }
    };
  }
  getAlerts() {
    this.selectors.message = this.selectors.input.getAttribute('aria-describedby') ? this.selectors.input.getAttribute('aria-describedby').split(' ')[0] : '';
    if (this.selectors.message) {
      const messageElement = document.getElementById(this.selectors.message);
      const alerts = messageElement ? messageElement.querySelectorAll('[role="alert"]') : '';
      if (alerts.length > 1 && this.model.validationId) {
        alerts.forEach(alert => {
          if (alert.id !== this.model.validationId) {
            this.selectors.alert = alert;
          }
        });
      } else {
        this.selectors.alert = messageElement;
      }
    }
  }
  validateRequired() {
    if (this.selectors.input.required && parseFloat(this.selectors.input.value) <= 0) {
      this.selectors.input.classList.remove('form-control-success');
      this.selectors.target.classList.add('has-warning');
      if (this.selectors.alert) {
        this.selectors.alert.classList.remove('hidden');
      }
    } else {
      this.selectors.target.classList.remove('has-warning');
      if (this.selectors.alert) {
        this.selectors.alert.classList.add('hidden');
      }
    }
  }
  validateData() {
    const regex = RegExp(this.model.validation);
    const val = this.selectors.input.value;
    this.selectors.validationAlert = document.querySelector(`#${this.model.validationId}`);
    // if data-validation test doesn't pass, trigger warning and show data-validation-message
    if (!regex.test(val)) {
      this.selectors.target.classList.add('has-warning');
      this.selectors.target.classList.remove('form-control-success');
      if (this.selectors.validationAlert) {
        this.selectors.validationAlert.classList.remove('hidden');
      }
    } else {
      // otherwise remove data-validation-message
      this.selectors.target.classList.remove('has-warning');
      if (this.selectors.validationAlert) {
        this.selectors.validationAlert.classList.add('hidden');
      }
      if (this.model.success) {
        this.selectors.input.classList.add('form-control-success');
      }
    }
  }
  setPlaceholder() {
    // Add placeholder if not present
    const placeholder = this.selectors.input.getAttribute('placeholder');
    if (!placeholder) {
      this.selectors.input.setAttribute('placeholder', this.formatCurrency('0'));
    } else {
      this.selectors.input.setAttribute('placeholder', this.formatCurrency(placeholder));
    }
  }
  setSymbol() {
    if (!this.selectors.symbol) {
      this.selectors.input.insertAdjacentHTML('beforebegin', `<span class="form-unit">${this.currencySymbol}</span>`);
    } else {
      this.selectors.symbol.innerHTML = this.currencySymbol;
    }
  }
  setAccessibleNameForCurrenyInputField() {
    const currencyFieldContainer = this.selectors.field.closest('[data-toggle="currencyfield"]');
    if (currencyFieldContainer && currencyFieldContainer.querySelector('label')) {
      const inputLabel = currencyFieldContainer.querySelector('label').innerText;
      this.selectors.input.setAttribute('aria-label', `${inputLabel} ${this.currencies[this.model.currency]} ${this.currencySymbol}`);
    }
  }
  setAlignment() {
    // symbol alignment right/left
    this.selectors.field.classList.add('currency-field');
    if (this.currencyFormat.indexOf(this.currencySymbol) === 0) {
      this.selectors.field.classList.add('currency-field-left');
      this.selectors.field.classList.remove('currency-field-right');
    } else {
      this.selectors.field.classList.add('currency-field-right');
      this.selectors.field.classList.remove('currency-field-left');
    }
  }
  formatCurrency(v) {
    let val = 0;
    if (v) {
      // Detect the current local separator
      const n = 1.1;
      const separator = n.toLocaleString(this.model.currency).substring(1, 2);
      val = separator === '.' ? v.replace(/[^\d.]/g, '') : v.replace(/[^\d,]/g, '').replace(/,/g, '.');
    }
    let places = 0;
    if (this.model.cents && !(this.model.cents === 'false')) {
      val = parseFloat(val).toFixed(2);
      places = 2;
    } else {
      val = parseInt(val, 10);
    }
    if (this.model.float && !(this.model.float === 'false')) {
      val = parseInt(val, 10).toFixed(2);
      places = 2;
    }
    if (!val) {
      val = 0;
    }
    const number = Number(val).toLocaleString(this.model.currency, {
      minimumFractionDigits: places
    });
    this.currencyFormat = Number(val).toLocaleString(this.model.currency, {
      style: 'currency',
      currency: this.currencies[this.model.currency],
      minimumFractionDigits: places
    });
    this.currencySymbol = this.currencyFormat.replace(number, '').trim();
    return number;
  }
}
/* harmony default export */ var currencyfield = (Currencyfield);
;// CONCATENATED MODULE: ./source/scripts/components/datatable.js
class Datatable {
  constructor(params) {
    if (!params.target) {
      throw new Error('Data sets: Please provide a valid target! - {target: elemSelector, config: (optional)}');
    }
    this.selectors = {
      target: params.target,
      status: document.getElementById(params.target.getAttribute('aria-describedby')),
      rows: [].slice.call(params.target.tBodies.item(0).rows),
      headRow: params.target.getElementsByTagName('tr')[0]
    };
    this.selectors.sortableHeaders = [].slice.call(this.selectors.headRow.cells).filter(th => th.getAttribute('aria-sort') !== null);
    if (params.config) {
      this.config = params.config;
    }

    // Sortable
    this.selectors.sortableHeaders.forEach(th => {
      if (th.classList.contains('active')) {
        this.sortColumn(th, th.getAttribute('aria-sort'));
      }
      const sortButton = th.firstElementChild;
      if (sortButton) {
        sortButton.addEventListener('click', () => {
          let order = th.getAttribute('aria-sort');
          if (sortButton.classList.contains('active')) {
            order = order === 'ascending' ? 'descending' : 'ascending';
          }
          this.sortColumn(th, order);
        });
      } else {
        th.addEventListener('click', e => {
          let order = e.target.getAttribute('aria-sort');
          if (e.target.classList.contains('active')) {
            order = order === 'ascending' ? 'descending' : 'ascending';
          }
          this.sortColumn(e.target, order);
        });
      }
    });
  }
  sortColumn(target, order) {
    const sortButton = target.firstElementChild;
    if (sortButton) {
      this.selectors.sortableHeaders.forEach(th => {
        th.classList.remove('active');
        const buttons = th.firstElementChild;
        buttons === null || buttons === void 0 ? void 0 : buttons.classList.remove('active');
      });
      target.classList.add('active');
      sortButton.classList.add('active');
    } else {
      this.selectors.sortableHeaders.forEach(th => {
        th.classList.remove('active');
      });
      target.classList.add('active');
    }
    let customSort = false;
    if (target.dataset.customSort) {
      if (this.config && this.config[target.dataset.customSort]) {
        customSort = this.config[target.dataset.customSort];
      } else {
        console.warn('No config provided with custom function');
      }
    }
    const col = target.cellIndex;
    const tbody = document.createElement('tbody');
    const rows = [].slice.call(this.selectors.rows).filter(el => el.cells.length !== 1).sort((a, b) => {
      const cellA = a.cells[col].innerHTML;
      const cellB = b.cells[col].innerHTML;
      if (customSort) {
        return customSort(cellA, cellB, order);
      }
      return this.defaultSort(cellA, cellB, order);
    });
    rows.forEach(row => {
      tbody.appendChild(row);
      if (row.id) {
        const expandRow = this.selectors.rows.filter(el => el.dataset.expandId === `${row.id}`);
        if (expandRow.length) {
          tbody.appendChild(expandRow[0]);
        }
      }
    });
    this.selectors.target.replaceChild(tbody, this.selectors.target.tBodies.item(0));
    target.setAttribute('aria-sort', order);
    this.selectors.status.innerText = `Sorted by ${target.innerText}: ${order}`;
  }
  defaultSort(a, b, order) {
    let sortAfter = 1;
    let sortBefore = -1;
    if (order === 'descending') {
      sortAfter = -1;
      sortBefore = 1;
    }
    const toNum = n => Number(n.replace(/(,)|^([^a-zA-z0-9.])/g, ''));
    const itemA = !Number.isNaN(toNum(a)) ? toNum(a) : a;
    const itemB = !Number.isNaN(toNum(b)) ? toNum(b) : b;
    if (itemA > itemB) {
      return sortAfter;
    } else if (itemA < itemB) {
      return sortBefore;
    }
    return 0;
  }
}
/* harmony default export */ var datatable = (Datatable);
;// CONCATENATED MODULE: ./source/scripts/components/dismissible.js
class Dismissible {
  constructor(params) {
    if (!params.target) {
      throw new Error('Dismissible: No target element passed');
    }
    this.selectors = {
      target: params.target,
      close: params.target.hasAttribute('data-dismiss') ? params.target : params.target.querySelector('[data-dismiss]')
    };
    if (this.selectors.close) {
      this.selectors.close.addEventListener('click', () => {
        this.close();
      });
    }
  }
  close() {
    if (this.selectors.target.classList.contains('in')) {
      this.selectors.target.classList.remove('in');
      this.selectors.target.addEventListener('transitionend', () => {
        this.selectors.target.remove();
      });
    } else {
      this.selectors.target.classList.add('display-none');
    }
  }
}
/* harmony default export */ var dismissible = (Dismissible);
;// CONCATENATED MODULE: ./source/scripts/components/filter.js

class Filter {
  constructor(params) {
    if (!params.target) {
      throw new Error('Filter: Please provide a valid target! - {target: elemSelector, config: (optional)}');
    }
    this.selectors = {
      target: params.target,
      toggleBtn: params.target.querySelector('[data-show]'),
      badge: params.target.querySelector('[data-badge]'),
      filter: params.target.querySelector('.filter'),
      closeBtn: params.target.querySelector('[data-close]'),
      resetBtn: params.target.querySelector('[data-reset]'),
      applyBtn: params.target.querySelector('[data-apply]'),
      backBtn: params.target.querySelector('[data-back]'),
      filterMenu: params.target.querySelector('.filter-menu'),
      filterItems: [].slice.call(params.target.getElementsByClassName('filter-item')),
      filterBy: params.target.querySelector('[data-filterby]')
    };
    this.model = {
      persistent: params.target.dataset.persistent || false,
      expanded: this.selectors.toggleBtn ? this.selectors.toggleBtn.getAttribute('aria-expanded') : 'false',
      filter: params.target.dataset.filter || 'single',
      select: params.target.dataset.select || 'single',
      all: params.target.querySelector('[data-all]'),
      allText: params.target.dataset['all-text'] || 'All',
      checklist: this.selectors.filterMenu.querySelector('.filter-checklist'),
      checkIndeterminate: params.target.querySelector('[data-indeterminate]')
    };
    this.breakpoint = parseInt(breakpoints_namespaceObject.f[this.model.persistent], 10);

    // by default, badge is 0
    this.resetBadge();
    if (this.selectors.badge) {
      this.selectors.badge.setAttribute('id', 'filter-count');
      this.selectors.badge.setAttribute('role', 'alert');
    }

    // close filter when click outside
    document.addEventListener('click', e => {
      if (!this.model.persistent || window.innerWidth < this.breakpoint) {
        /* istanbul ignore else  */
        if (!this.selectors.target.contains(e.target)) {
          this.close();
        }
      }
    });

    // close filter when press esc
    this.selectors.target.onkeydown = e => {
      if ((e.key === 'Escape' || e.key === 'Esc') && (!this.model.persistent || window.innerWidth < this.breakpoint)) {
        this.close();
      }
    };
    this.selectors.toggleBtn && !this.selectors.toggleBtn.getAttribute('aria-expanded') ? this.close() : this.setup();
    if (this.model.persistent) {
      this.persistentReset();
      window.addEventListener('resize', () => {
        this.persistentReset();
      });
    }
    if (this.selectors.toggleBtn) {
      this.selectors.toggleBtn.onclick = () => this.toggle();
    }
    if (this.selectors.closeBtn) {
      this.selectors.closeBtn.onclick = () => this.close();
    }
    if (this.model.filter === 'single' && this.selectors.filterItems) {
      this.resize(this.selectors.filterItems.length);
      // single-multi select
      if (this.model.checklist) {
        // By default all is checked
        this.resetChecks(this.model.checklist, this.model.checkIndeterminate);
        this.selectors.applyBtn.onclick = () => {
          this.checkboxUpdate(this.model.checklist);
          if (!this.model.persistent || window.innerWidth < this.breakpoint) {
            this.close();
          }
        };
        this.selectors.resetBtn.onclick = () => {
          this.resetBadge();
          this.resetChecks(this.model.checklist, this.model.checkIndeterminate);
        };
      } else {
        // single-single select
        this.singleSelect(this.selectors.filterItems);
        this.selectors.resetBtn.onclick = () => {
          this.resetBadge();
          this.reset(this.selectors.filterItems);
          this.model.all.setAttribute('aria-selected', 'true');
        };
      }
    } else {
      // multi filter
      this.model.mainFilter = params.target.querySelector('[data-filters]');
      this.model.filters = [].slice.call(params.target.querySelectorAll('[data-filters] button'));
      this.model.filtersId = [];
      this.model.totalCount = 0;
      this.resize(this.model.filters.length);
      this.model.filters.forEach(filter => {
        const filterId = filter.getAttribute('id');
        this.model.filtersId.push(filterId);
        this.model[filterId] = {};
        this.model[filterId].checklist = params.target.querySelector(`[aria-labelledby="${filterId}"] .filter-checklist`);
        this.model[filterId].indeterminate = params.target.querySelector(`[aria-labelledby="${filterId}"] [data-indeterminate]`);
        this.model[filterId].count = filter.querySelector('[data-count]');
        this.model[filterId].all = params.target.querySelector(`[aria-labelledby="${filterId}"] [data-all]`);
        this.model[filterId].totalCount = 0;

        // default all checks selected
        this.resetAll();
        // default hide all subfilters
        params.target.querySelector(`[aria-labelledby="${filterId}"]`) && params.target.querySelector(`[aria-labelledby="${filterId}"]`).classList.add('invisible');
        filter.onclick = () => {
          this.model.filterId = filterId;
          this.model.subFilter = params.target.querySelector(`[aria-labelledby="${filterId}"]`);
          this.model[filterId].subFilterItems = [].slice.call(this.model.subFilter.getElementsByClassName('filter-item'));
          this.showSubFilter(filter, filterId);
          if (!this.model.checklist) {
            this.singleSelect(this.model[filterId].subFilterItems, this.model[filterId].count, filterId);
          }
        };
      });
      this.selectors.backBtn.onclick = () => {
        this.hideSubFilter();
      };
      if (this.selectors.applyBtn) {
        this.selectors.applyBtn.onclick = () => {
          this.model.totalCount = 0;
          this.model.checklists = [].slice.call(params.target.querySelectorAll('[data-filters] button'));
          this.model.filtersId.forEach(filterId => {
            const checklist = this.model[filterId].checklist;
            this.checkboxUpdate(checklist, filterId);
          });
          if (!this.model.persistent || window.innerWidth < this.breakpoint) {
            this.close();
          }
          if (this.model.persistent && window.innerWidth > this.breakpoint) {
            this.hideSubFilter();
          }
        };
      }
      this.selectors.resetBtn.onclick = () => {
        if (this.model.subFilter) {
          this.resetSubfilter();
          this.updateBadge();
        } else {
          // clear all
          this.resetBadge();
          this.resetAll();
        }
      };
    }
  }
  setup() {
    this.model.expanded === 'true' ? this.open() : this.close();
  }
  toggle() {
    this.model.expanded === 'true' ? this.close() : this.open();
  }
  open() {
    this.model.subFilter && this.hideSubFilter();
    this.selectors.filter.classList.remove('hidden');
    this.selectors.toggleBtn && this.selectors.toggleBtn.setAttribute('aria-expanded', 'true');
    this.model.expanded = 'true';
    if (this.selectors.closeBtn) {
      this.selectors.closeBtn.focus();
    }
  }
  close() {
    this.model.subFilter && this.hideSubFilter();
    if (this.selectors.closeBtn && this.selectors.toggleBtn) {
      this.selectors.filter.classList.add('hidden');
      this.selectors.toggleBtn.setAttribute('aria-expanded', 'false');
      this.model.expanded = 'false';
    }
    if (this.selectors.toggleBtn) {
      this.selectors.toggleBtn.focus();
    }
  }
  singleSelect(items, count, filterId) {
    let focusIndex = 0;
    items.forEach((item, index) => {
      item.onclick = () => {
        // to prevent counting when click on something already selected
        /* istanbul ignore else  */
        if (item.getAttribute('aria-selected') !== 'true') {
          this.reset(items);
          item.setAttribute('aria-selected', true);
          item.dataset.all !== undefined ? this.resetBadge() : this.updateBadge(1);
          count && this.updateCount(item, count, filterId);
        }
        if (!this.model.persistent || window.innerWidth < this.breakpoint) {
          this.close();
        }
      };
      if (item.nodeName !== 'BUTTON') {
        item.addEventListener('keydown', e => {
          if (e.key === 'ArrowDown') {
            e.preventDefault();
            focusIndex = index === items.length - 1 ? 0 : index + 1;
            items[focusIndex].focus();
          }
          if (e.key === 'ArrowUp') {
            e.preventDefault();
            focusIndex = index === 0 ? items.length - 1 : index - 1;
            items[focusIndex].focus();
          }
          if (e.key === 'Enter' || e.code === 'Space') {
            e.preventDefault();
            if (item.getAttribute('aria-selected') !== 'true') {
              this.reset(items);
              item.setAttribute('aria-selected', true);
              if (item.dataset.all !== undefined) {
                this.resetBadge();
              } else {
                this.updateBadge(1);
              }
              if (count) {
                this.updateCount(item, count, filterId);
              }
            }
            if (!this.model.persistent || window.innerWidth < this.breakpoint) {
              this.close();
            }
          }
        });
      }
    });
  }
  updateCount(item, count, filterId) {
    if (item.dataset.all !== undefined) {
      count.innerHTML = this.model.allText;
      this.model.totalCount -= 1;
      this.model[filterId].totalCount = 0;
    } else {
      count.innerHTML = item.innerHTML;
      /* istanbul ignore else  */
      if (this.model[filterId].totalCount < 1) {
        this.model[filterId].totalCount = 1;
        this.model.totalCount += 1;
      }
    }
    this.updateBadge(this.model.totalCount);
  }
  resetCount(count) {
    count.innerHTML = this.model.allText;
    this.model.totalCount > 0 ? this.model.totalCount -= 1 : this.model.totalCount = 0;
  }
  reset(items) {
    items ? items.forEach(item => {
      item.setAttribute('aria-selected', 'false');
    }) : '';
  }
  resetSubfilter() {
    const filterId = this.model.filterId;
    if (this.model[filterId].checklist) {
      this.resetChecks(this.model[filterId].checklist, this.model[filterId].indeterminate);
    } else {
      this.reset(this.model[filterId].subFilterItems);
      this.model[filterId].all && this.model[filterId].all.setAttribute('aria-selected', 'true');
      this.model[filterId].totalCount = 0;
    }
    this.resetCount(this.model[filterId].count);
  }
  resetAll() {
    this.model.filtersId.forEach(filterId => {
      this.model.filterId = filterId;
      this.resetSubfilter();
    });
    this.model.totalCount = 0;
  }
  resetBadge() {
    if (this.selectors.badge) {
      this.selectors.badge.innerHTML = 0;
      this.selectors.badge.classList.add('hidden');
      this.selectors.badge.setAttribute('aria-label', 'No Filters Applied');
      if (this.selectors.toggleBtn && this.selectors.toggleBtn.hasAttribute('aria-describedby')) {
        this.selectors.toggleBtn.removeAttribute('aria-describedby');
      }
    }
  }
  updateBadge(num) {
    if (this.selectors.badge) {
      if (num > 0) {
        if (this.selectors.toggleBtn) {
          this.selectors.toggleBtn.setAttribute('aria-describedby', 'filter-count');
        }
        this.selectors.badge.innerHTML = num;
        this.selectors.badge.setAttribute('aria-label', String(num).concat(' Filters Applied'));
        this.selectors.badge.classList.remove('hidden');
      } else {
        this.resetBadge();
      }
    }
  }
  checkboxUpdate(checklist, filterId) {
    const total = [].slice.call(checklist.querySelectorAll('input'));
    const checks = [].slice.call(checklist.querySelectorAll('input:checked'));
    if (filterId) {
      if (checks.length < total.length) {
        this.model.totalCount += checks.length;
      }
      this.model[filterId].count.innerHTML = checks.length > 0 && checks.length < total.length ? `${checks.length}/${total.length}` : this.model.allText;
      this.updateBadge(this.model.totalCount);
    } else {
      checks.length < total.length ? this.updateBadge(checks.length) : this.resetBadge();
    }
  }
  resetChecks(checklist, indeterminate) {
    const checkInputs = [].slice.call(checklist.querySelectorAll('input'));
    indeterminate.checked = true;
    indeterminate.setAttribute('aria-checked', true);
    checkInputs.forEach(checkbox => {
      checkbox.checked = true;
    });
  }
  showSubFilter(filter, filterId) {
    this.model.subFilter.classList.remove('invisible');
    this.model.subFilter.classList.remove('filter-hide');
    this.model.subFilter.classList.add('filter-show');
    this.model.mainFilter.classList.add('hidden');
    // set menu height
    const filterHeight = this.model.subFilter.scrollHeight;
    this.selectors.filterMenu.style.height = `${filterHeight}px`;
    this.resize(this.model[filterId].subFilterItems.length);

    // hide close button and show back button
    if (this.selectors.closeBtn) {
      this.selectors.closeBtn.classList.add('hidden');
    }
    this.selectors.backBtn.classList.remove('hidden');
    // update Text
    this.selectors.filterBy.innerHTML = filter.dataset.category;
  }
  hideSubFilter() {
    this.model.subFilter.classList.add('filter-hide');
    this.model.subFilter.classList.remove('filter-show');
    this.model.mainFilter.classList.remove('hidden');
    setTimeout(() => {
      this.model.subFilter && this.model.subFilter.classList.add('invisible');
    }, 700);
    setTimeout(() => {
      this.model.subFilter = false;
    }, 800);
    this.selectors.filterMenu.style.height = '100%';
    this.selectors.filterMenu.scrollTop = 0;
    this.resize(this.model.filters.length);
    this.selectors.backBtn.classList.add('hidden');
    this.selectors.filterBy.innerHTML = '';
    if (this.selectors.closeBtn) {
      this.selectors.closeBtn.classList.remove('hidden');
      this.selectors.closeBtn.focus();
    }
  }
  persistentReset() {
    if (window.innerWidth < this.breakpoint) {
      this.close();
    } else {
      this.open();
    }
  }
  resize(items) {
    if (items < 11) {
      this.selectors.filterMenu.classList.add('no-scroll');
    } else {
      this.selectors.filterMenu.classList.remove('no-scroll');
    }
  }
}
/* harmony default export */ var filter = (Filter);
;// CONCATENATED MODULE: ./source/scripts/components/input.js
class Inputfield {
  constructor(params) {
    if (!params.target) {
      throw new Error('Input: No target element passed');
    }
    this.selectors = {
      target: params.target,
      input: params.target.getElementsByTagName('input')[0],
      alert: '',
      message: '',
      password: params.target.querySelector('[data-mask-button]') || false,
      passwordIcon: params.target.getElementsByClassName('icon')[0] || false
    };
    this.model = {
      success: params.target.dataset.success,
      validation: params.target.dataset.validation,
      validationId: params.target.dataset.validationId,
      password: params.target.dataset.passwordToggle
    };

    // Todo remove support for icon mask button in v7
    if (this.selectors.password) {
      this.model.showText = this.selectors.password.dataset.show ? this.selectors.password.dataset.show : 'Show';
      this.model.hideText = this.selectors.password.dataset.hide ? this.selectors.password.dataset.hide : 'Hide';
    }
    this.getAlerts();
    this.selectors.input.onblur = () => {
      this.validateRequired();
      if (!this.selectors.target.classList.contains('has-warning')) {
        this.validateData();
      }
    };
    if (this.selectors.password && this.model.password) {
      this.selectors.password.onclick = () => {
        this.passwordToggle();
        this.ariaLabelToggle();
      };
    }
    if (this.selectors.passwordIcon && this.model.password) {
      this.selectors.passwordIcon.onclick = () => {
        this.passwordToggle();
      };
    }
  }
  getAlerts() {
    this.selectors.message = this.selectors.input.getAttribute('aria-describedby') ? this.selectors.input.getAttribute('aria-describedby').split(' ')[0] : '';
    if (this.selectors.message) {
      const messageElement = document.getElementById(this.selectors.message);
      const alerts = messageElement ? [].slice.call(messageElement.querySelectorAll('[role="alert"]')) : '';
      if (alerts.length > 1 && this.model.validationId) {
        alerts.forEach(alert => {
          if (alert.id !== this.model.validationId) {
            this.selectors.alert = alert;
          }
        });
      } else {
        this.selectors.alert = messageElement;
      }
    }
  }
  validateRequired() {
    if (this.selectors.input.required && !this.selectors.input.value.length) {
      this.selectors.input.classList.remove('form-control-success');
      if (!this.selectors.target.classList.contains('has-warning')) {
        this.selectors.target.classList.add('has-warning');
      }
      if (this.selectors.alert) {
        this.selectors.alert.classList.remove('hidden');
        this.selectors.input.setAttribute('aria-describedby', 'inputAlert');
      }
    } else if (this.model.success && !this.selectors.input.required && !this.selectors.input.value.length) {
      this.selectors.input.classList.remove('form-control-success');
    } else {
      this.selectors.target.classList.remove('has-warning');
      if (this.selectors.message && this.selectors.alert) {
        this.selectors.alert.classList.add('hidden');
        this.selectors.input.removeAttribute('aria-describedby');
      }
      if (this.model.success && !this.selectors.input.classList.contains('form-control-success')) {
        this.selectors.input.classList.add('form-control-success');
      }
    }
  }
  validateData() {
    const regex = RegExp(this.model.validation);
    const val = this.selectors.input.value;
    this.selectors.validationAlert = document.querySelector(`#${this.model.validationId}`);

    // if data-validation test doesn't pass, trigger warning and show data-validation-message
    if (!regex.test(val)) {
      this.selectors.target.classList.add('has-warning');
      this.selectors.target.classList.remove('form-control-success');
      if (this.selectors.validationAlert) {
        this.selectors.validationAlert.classList.remove('hidden');
      }
    } else {
      // otherwise remove data-validation-message
      this.selectors.target.classList.remove('has-warning');
      if (this.selectors.validationAlert) {
        this.selectors.validationAlert.classList.add('hidden');
      }
      if (this.model.success) {
        this.selectors.input.classList.add('form-control-success');
      }
    }
  }
  ariaLabelToggle() {
    if (this.selectors.input.type === 'password') {
      this.selectors.password.ariaLabel = 'Show Password';
    }
    if (this.selectors.input.type === 'text') {
      this.selectors.password.ariaLabel = 'Hide Password';
    }
  }
  passwordToggle() {
    this.selectors.input.focus();
    if (this.selectors.input.type !== 'password') {
      this.selectors.input.type = 'password';
      if (this.selectors.passwordIcon && this.selectors.passwordIcon.classList.contains('dls-icon-hide')) {
        this.selectors.passwordIcon.classList.remove('dls-icon-hide');
        this.selectors.passwordIcon.classList.add('dls-icon-show');
      } else {
        this.selectors.password.innerHTML = this.model.showText;
      }
    } else {
      this.selectors.input.type = 'text';
      if (this.selectors.passwordIcon && this.selectors.passwordIcon.classList.contains('dls-icon-show')) {
        this.selectors.passwordIcon.classList.remove('dls-icon-show');
        this.selectors.passwordIcon.classList.add('dls-icon-hide');
      } else {
        this.selectors.password.innerHTML = this.model.hideText;
      }
    }
  }
}
/* harmony default export */ var input = (Inputfield);
;// CONCATENATED MODULE: ./source/scripts/components/inputgroup.js
class Inputgroup {
  constructor(params) {
    if (!params.target) {
      throw new Error('Input: No target element passed');
    }
    this.selectors = {
      target: params.target,
      inputfields: [].slice.call(params.target.querySelectorAll('[data-toggle]')),
      alertAll: params.target.querySelector('[data-alert-all]'),
      alertInputs: params.target.querySelector('[data-alert-inputs]'),
      alertLabels: params.target.querySelector('[data-alert-labels]'),
      alertLabel: [].slice.call(params.target.querySelectorAll('[data-alert-label]'))
    };
    this.model = {
      warnings: [],
      total: this.selectors.inputfields.length
    };
    this.selectors.inputfields.forEach(input => {
      const select = input.getElementsByTagName('select')[0];
      if (select) {
        select.oninput = () => {
          setTimeout(() => {
            this.countAlerts();
            this.handleErrors();
          }, 5);
        };
      }
      input.onclick = () => {
        this.countAlerts();
        this.handleErrors();
      };
    });
  }
  countAlerts() {
    this.model.warnings = [];
    this.selectors.inputfields.forEach(input => {
      if (input.className.indexOf('has-warning') > -1) {
        this.model.warnings.push(input);
      }
    });
  }
  updateAlerts() {
    for (let i = 0; i < this.model.warnings.length; i += 1) {
      const label = this.model.warnings[i].querySelector('label');
      this.selectors.alertLabel[i].innerHTML = `&nbsp${label.innerHTML.toLowerCase()}`;
    }
  }
  handleErrors() {
    if (this.model.warnings.length > 1) {
      this.selectors.alertInputs && this.selectors.alertInputs.classList.add('hidden');
      if (this.model.warnings.length < this.model.total) {
        this.selectors.alertLabels && this.selectors.alertLabels.classList.remove('hidden');
        this.selectors.alertAll && this.selectors.alertAll.classList.add('hidden');
        this.selectors.alertLabel && this.updateAlerts();
      } else {
        this.selectors.alertAll && this.selectors.alertAll.classList.remove('hidden');
        this.selectors.alertLabels && this.selectors.alertLabels.classList.add('hidden');
      }
    } else {
      this.selectors.alertInputs && this.selectors.alertInputs.classList.remove('hidden');
      this.selectors.alertAll && this.selectors.alertAll.classList.add('hidden');
      this.selectors.alertLabels && this.selectors.alertLabels.classList.add('hidden');
    }
  }
}
/* harmony default export */ var inputgroup = (Inputgroup);
;// CONCATENATED MODULE: ./source/scripts/components/multiselect.js
const escapeKey = 'Escape';
const escKey = 'Esc';
const arrowDownKey = 'ArrowDown';
const arrowUpKey = 'ArrowUp';
const hiddenClass = 'hidden';
const hasWarningClass = 'has-warning';
const expandedAttribute = 'aria-expanded';
class MultiSelect {
  constructor(params) {
    if (!params.target) {
      throw new Error('MultiSelect Dropdown: No target element passed');
    }
    this.selectors = {
      target: params.target,
      select: params.target.getElementsByTagName('select')[0],
      multiselect: params.target.getElementsByClassName('multiselect')[0],
      selected: params.target.getElementsByClassName('selected')[0],
      options: params.target.getElementsByClassName('multiselect-options')[0],
      checkboxes: params.target.querySelectorAll('input[type="checkbox"]'),
      label: params.target.getElementsByTagName('label')[0],
      alert: params.target.getElementsByTagName('select')[0].getAttribute('aria-describedby') || false
    };
    this.selectors.message = this.selectors.alert ? params.target.querySelectorAll(`#${this.selectors.alert}`)[0] : '';
    this.updateSelectedCount();
    for (let i = 0; i < this.selectors.checkboxes.length; i += 1) {
      this.selectors.checkboxes[i].addEventListener('click', () => {
        this.updateSelectedCount();
      });
    }
    this.selectors.multiselect.addEventListener('click', e => {
      if (!this.selectors.multiselect.hasAttribute('disabled')) {
        this.toggle();
      }
      e.preventDefault();
    }, true);
    this.selectors.target.addEventListener('keydown', e => {
      if (e.target === this.selectors.select && (e.key === ' ' || e.key === arrowDownKey && this.selectors.options.classList.contains(hiddenClass))) {
        this.toggle();
      } else if (e.key === arrowDownKey || e.key === arrowUpKey) {
        this.focusOnAnotherItem(e);
      } else if (e.key === escapeKey || e.key === escKey) {
        e.preventDefault();
        this.selectors.select.focus();
        this.hideOptions();
      }
    }, true);
    this.selectors.select.addEventListener('blur', () => {
      setTimeout(() => {
        const forceValid = !(this.selectors.options.classList.contains(hiddenClass) && document.activeElement !== this.selectors.multiselect && document.activeElement !== this.selectors.select);
        this.validateRequired(forceValid);
      }, 100);
    });
    document.addEventListener('click', e => {
      if (!this.selectors.options.classList.contains(hiddenClass) && !this.selectors.target.contains(e.target)) {
        this.hideOptions();
        this.validateRequired();
      }
    });
  }
  focusOnAnotherItem(e) {
    e.preventDefault();
    const checkboxesLength = this.selectors.checkboxes.length;
    let index = e.key === arrowDownKey ? 0 : checkboxesLength - 1;
    const direction = e.key === arrowDownKey ? 1 : -1;
    for (let checkboxIndex = 0; checkboxIndex < checkboxesLength; checkboxIndex += 1) {
      if (this.selectors.checkboxes[checkboxIndex] === e.target) {
        index = checkboxIndex + direction;
        break;
      }
    }
    if (index < 0 || index >= checkboxesLength) {
      this.selectors.select.focus();
    } else {
      this.selectors.checkboxes[index].focus();
    }
  }
  toggle() {
    this.selectors.select.focus();
    if (this.selectors.options.classList.contains(hiddenClass)) {
      this.selectors.options.classList.remove(hiddenClass);
      this.selectors.multiselect.setAttribute(expandedAttribute, 'true');
      this.validateRequired(true);
    } else {
      this.hideOptions();
    }
  }
  getSelectedCount() {
    let selectedCount = 0;
    for (let i = 0; i < this.selectors.checkboxes.length; i += 1) {
      if (this.selectors.checkboxes[i].checked) {
        selectedCount += 1;
      }
    }
    return selectedCount;
  }
  hideOptions() {
    this.selectors.options.classList.add(hiddenClass);
    this.selectors.multiselect.setAttribute(expandedAttribute, 'false');
    this.updateSelectedCount();
  }
  updateSelectedCount() {
    const selectedCount = this.getSelectedCount();
    const multiselect = this.selectors.multiselect;
    if (multiselect.childNodes.length > 3) {
      multiselect.removeChild(multiselect.childNodes[1]);
    }
    if (selectedCount > 0) {
      const selectedDiv = document.createElement('div');
      selectedDiv.innerHTML = `${selectedCount} selected`;
      multiselect.insertBefore(selectedDiv, multiselect.childNodes[1]);
    }
  }
  validateRequired(forceValid) {
    // warninng if required and nothing selected
    if (this.selectors.select.required && this.getSelectedCount() < 1 && !forceValid) {
      this.selectors.target.classList.add(hasWarningClass);
      if (this.selectors.message) {
        this.selectors.message.classList.remove(hiddenClass);
        this.selectors.select.setAttribute('aria-describedby', this.selectors.message.getAttribute('id'));
      }
    } else {
      this.selectors.target.classList.remove(hasWarningClass);
      if (this.selectors.message) {
        this.selectors.message.classList.add(hiddenClass);
        this.selectors.select.removeAttribute('aria-describedby');
      }
    }
  }
}
/* harmony default export */ var multiselect = (MultiSelect);
;// CONCATENATED MODULE: ./source/scripts/components/nav.js

class Nav {
  constructor(params) {
    if (!params.target) {
      throw new Error('Nav: No target element passed');
    }
    this.selectors = {
      target: params.target,
      menu: params.target.getElementsByClassName('nav-menu')[0],
      item: [].slice.call(params.target.getElementsByClassName('nav-item')),
      links: [].slice.call(params.target.getElementsByClassName('nav-link')),
      expanded: [].slice.call(params.target.querySelectorAll('[aria-expanded]')),
      dropdown: params.target.getElementsByClassName('nav-dropdown')[0],
      overlay: params.target.getElementsByClassName('nav-overlay')[0],
      burger: params.target.getElementsByClassName('nav-burger')[0]
    };
    this.model = {
      responsive: params.target.dataset.responsive || 'false',
      overlay: params.target.dataset.overlay || 'false'
    };
    this.responsiveLayout();
    window.addEventListener('resize', () => {
      this.responsiveLayout();
      this.updateFooterView();
    });
    if (this.selectors.overlay) {
      if (this.selectors.target.querySelector('[aria-expanded="true"]')) {
        this.selectors.overlay.classList.add('visible');
      }
      this.selectors.overlay.onclick = () => {
        this.selectors.overlay.classList.remove('visible');
        this.selectors.expanded.forEach(item => {
          item.setAttribute('aria-expanded', 'false');
        });
      };
    }

    // setup for icon states
    if (this.selectors.target.querySelectorAll('[aria-current="page"]').length && this.selectors.target.querySelectorAll('[aria-current="page"]')[0].querySelector('.icon')) {
      [].slice.call(this.selectors.target.querySelectorAll('[aria-current="page"]')).forEach(el => {
        const icon = el.querySelector('.icon');
        this.fillIcon(icon);
      });
    }
    this.selectors.links.forEach(link => {
      if (this.selectors.target.classList.contains('nav-vertical') && link.nextElementSibling && link.getAttribute('aria-expanded') === 'false') {
        link.nextElementSibling.classList.add('hidden');
      }
      link.onclick = el => {
        this.toggleCurrent(el);
      };
    });
    if (this.selectors.dropdown) {
      this.selectors.dropdown.onclick = () => {
        this.toggleDropdown();
      };
    }
    if (this.selectors.burger) {
      this.selectors.burger.onclick = () => {
        this.toggleBurger();
      };
      document.addEventListener('click', e => {
        if (this.selectors.burger.getAttribute('aria-expanded') === 'true' && !this.selectors.burger.contains(e.target) && !this.selectors.menu.contains(e.target)) {
          this.selectors.burger.setAttribute('aria-expanded', 'false');
        }
      });
    }
  }
  updateLayout(breakpoint) {
    if (window.innerWidth < breakpoint) {
      this.selectors.links.forEach(link => {
        var _link$nextElementSibl;
        if (!((_link$nextElementSibl = link.nextElementSibling) !== null && _link$nextElementSibl !== void 0 && _link$nextElementSibl.classList.contains('visible')) && link.classList.contains('heading-1')) {
          var _link$nextElementSibl2;
          (_link$nextElementSibl2 = link.nextElementSibling) === null || _link$nextElementSibl2 === void 0 ? void 0 : _link$nextElementSibl2.classList.add('hidden');
          link.setAttribute('aria-expanded', 'false');
        }
      });
      this.selectors.target.classList.add('nav-vertical');
      this.selectors.target.classList.remove('nav-horizontal');
      if (this.selectors.overlay) {
        this.selectors.overlay.classList.remove('display-none');
      }
    } else {
      this.selectors.links.forEach(link => {
        var _link$nextElementSibl3;
        if ((_link$nextElementSibl3 = link.nextElementSibling) !== null && _link$nextElementSibl3 !== void 0 && _link$nextElementSibl3.classList.contains('hidden')) {
          var _link$nextElementSibl4;
          (_link$nextElementSibl4 = link.nextElementSibling) === null || _link$nextElementSibl4 === void 0 ? void 0 : _link$nextElementSibl4.classList.remove('hidden');
        }
      });
      this.selectors.target.classList.remove('nav-vertical');
      this.selectors.target.classList.add('nav-horizontal');
      if (this.model.overlay === 'false' && this.selectors.overlay) {
        this.selectors.overlay.classList.add('display-none');
      }
    }
  }
  responsiveLayout() {
    if (this.model.responsive !== 'false') {
      // breakpoint is either true or specified sm/md/lg
      // if true, default is md
      let breakpoint = this.model.responsive && this.model.responsive !== 'true' ? this.model.responsive : 'md';
      breakpoint = parseInt(breakpoints_namespaceObject.f[breakpoint], 10);
      this.updateLayout(breakpoint);
    }
  }
  toggleCurrent(el) {
    const expanded = this.selectors.target.querySelector('[aria-expanded="true"]');
    let parent = null;
    this.selectors.links.forEach(link => {
      // reset all links aria-current to false
      link.setAttribute('aria-current', 'false');

      // reset icons
      const icon = link.querySelector('.icon');
      if (icon) {
        this.unfillIcon(icon);
      }
      // reset all other links aria-expanded to false
      // unless it is a submenu
      if (link.getAttribute('aria-expanded') && link !== el.target && !(link.nextElementSibling && link.nextElementSibling.contains(el.target))) {
        link.setAttribute('aria-expanded', 'false');
        if (this.selectors.target.classList.contains('nav-vertical') && link.nextElementSibling) {
          link.nextElementSibling.classList.add('hidden');
          link.nextElementSibling.classList.remove('visible');
        }
      }
      // if has submenu, pass in parent menu
      if (link !== el.target && link.nextElementSibling && link.nextElementSibling.contains(el.target)) {
        parent = link.nextElementSibling;
      }
    });
    el.target.setAttribute('aria-current', 'page');
    this.toggleExpand(el, expanded, parent);
    if (el.target.querySelector('.icon')) {
      const icon = el.target.querySelector('.icon');
      this.fillIcon(icon);
    }
    if (this.selectors.dropdown) {
      this.selectors.dropdown.innerHTML = el.target.innerHTML;
    }
  }
  toggleExpand(el, prevExpanded, parent) {
    const expanded = el.target.getAttribute('aria-expanded');
    const menu = el.target.nextElementSibling;
    if (expanded === 'true') {
      el.target.setAttribute('aria-expanded', 'false');
      if (menu) {
        if (this.selectors.target.classList.contains('nav-vertical')) {
          menu.classList.add('hidden');
          menu.classList.remove('visible');
        } else {
          menu.removeAttribute('style');
        }
      }
      if (this.selectors.overlay) {
        this.selectors.overlay.classList.remove('visible');
      }
    } else {
      this.handleAnim(el.target, prevExpanded);
      el.target.setAttribute('aria-expanded', 'true');
      el.target.setAttribute('aria-current', 'page');
      if (menu) {
        if (this.selectors.target.classList.contains('nav-vertical')) {
          menu.classList.remove('hidden');
          menu.classList.add('visible');
          if (parent) {
            parent.classList.remove('hidden');
          }
        } else {
          menu.removeAttribute('style');
        }
      }
      if (this.selectors.overlay) {
        this.selectors.overlay.classList.add('visible');
      }
    }
  }
  toggleDropdown() {
    const menu = this.selectors.target.querySelector('.nav-menu');
    if (this.selectors.dropdown.getAttribute('aria-expanded') === 'true') {
      this.selectors.dropdown.setAttribute('aria-expanded', 'false');
      menu.classList.add('hidden');
    } else {
      this.selectors.dropdown.setAttribute('aria-expanded', 'true');
      menu.classList.remove('hidden');
    }
  }
  toggleBurger() {
    if (this.selectors.burger.getAttribute('aria-expanded') === 'true') {
      this.selectors.burger.setAttribute('aria-expanded', 'false');
    } else {
      this.selectors.burger.setAttribute('aria-expanded', 'true');
    }
  }
  disableAnim(el, expanded) {
    el.nextElementSibling.classList.add('anim-none');
    expanded.nextElementSibling.classList.add('anim-none');
  }
  resetAnim(el, expanded) {
    el.nextElementSibling.classList.remove('anim-none');
    expanded.nextElementSibling.classList.remove('anim-none');
  }
  handleAnim(el, expanded) {
    if (this.selectors.target.classList.contains('nav-horizontal') && el.hasAttribute('aria-expanded') && expanded && expanded.nextElementSibling) {
      this.disableAnim(el, expanded);
      setTimeout(() => {
        this.resetAnim(el, expanded);
      }, 1000);
    }
  }
  fillIcon(icon) {
    const iconClass = icon.className.match(/(?=dls-icon)([a-z-]+)/)[0];
    if (!iconClass.endsWith('-filled')) {
      icon.classList.remove(iconClass);
      icon.classList.add(`${iconClass}-filled`);
    }
  }
  unfillIcon(icon) {
    const iconClassRaw = icon.className.match(/(?=dls-icon)([a-z-]+)/)[0];
    if (iconClassRaw.slice(iconClassRaw.length - 7, iconClassRaw.length) === '-filled') {
      icon.classList.remove(iconClassRaw);
      icon.classList.add(iconClassRaw.slice(0, -7));
    }
  }
  updateFooterView() {
    const footer = document.querySelector('footer');
    if (footer) {
      if (footer.classList.contains('nav-horizontal')) {
        const buttons = document.querySelectorAll('footer .nav-menu .nav-item button');
        buttons === null || buttons === void 0 ? void 0 : buttons.forEach(button => {
          const newHeading = document.createElement('h2');
          button.before(newHeading);
          newHeading.innerHTML = button.innerHTML;
          newHeading.classList.add('nav-link', 'caret', 'heading-1');
          button.remove();
        });
      }
      if (footer.classList.contains('nav-vertical')) {
        const headings = document.querySelectorAll('footer .nav-menu .nav-item h2');
        headings === null || headings === void 0 ? void 0 : headings.forEach(heading => {
          const newButton = document.createElement('button');
          const parent = heading.parentElement;
          const subMenu = parent.querySelector('.nav-menu');
          heading.before(newButton);
          newButton.innerHTML = heading.innerHTML;
          newButton.classList.add('nav-link', 'caret', 'heading-1');
          if (!subMenu.classList.contains('visible')) {
            newButton.setAttribute('aria-expanded', 'false');
            subMenu.classList.add('hidden');
          } else {
            newButton.setAttribute('aria-expanded', 'true');
            subMenu.classList.add('visible');
          }
          this.selectors.links.push(newButton);
          newButton.onclick = el => {
            this.toggleCurrent(el);
          };
          heading.remove();
        });
      }
    }
  }
}
/* harmony default export */ var nav = (Nav);
;// CONCATENATED MODULE: ./source/scripts/components/overflowmenu.js
class OverflowMenu {
  constructor(params) {
    if (!params.target) {
      throw new Error('OverflowMenu: No target element passed');
    }
    this.selectors = {
      target: params.target,
      button: params.target.getElementsByTagName('button')[0]
    };
    this.model = {
      expanded: this.selectors.button.getAttribute('aria-expanded'),
      menu: params.target.querySelector(`[aria-labelledby="${this.selectors.button.id}"]`)
    };
    this.setup();
  }
  setup() {
    if (this.selectors.button && this.model.menu) {
      this.align();
      this.selectors.target.onkeydown = e => {
        if (e.key === 'Escape' || e.key === 'Esc') {
          this.close();
        }
      };
      document.addEventListener('click', e => {
        if (!this.selectors.target.contains(e.target)) {
          this.close();
        }
      });
      this.selectors.button.onclick = () => {
        this.toggle();
      };

      // when a menu option is clicked, auto close the menu
      // and return focus to the overflow menu button, which
      // is necessary for accessibility purposes
      this.model.menu.onclick = () => {
        this.close();
        this.selectors.button.focus();
      };
      window.addEventListener('resize', () => {
        this.align();
      });
      if (this.model.expanded === null) {
        this.selectors.button.setAttribute('aria-expanded', 'false');
      }
      if (this.model.expanded === 'true') {
        this.open();
      } else {
        this.close();
      }
    }
  }
  open() {
    this.selectors.button.setAttribute('aria-expanded', 'true');
    this.model.menu.classList.remove('hidden');
    this.align();
  }
  close() {
    this.selectors.button.setAttribute('aria-expanded', 'false');
    this.model.menu.classList.add('hidden');
  }
  toggle() {
    this.selectors.button.getAttribute('aria-expanded') === 'true' ? this.close() : this.open();
  }
  align() {
    const menuWidth = this.model.menu.getBoundingClientRect().width;
    const btnPosition = this.selectors.button.getBoundingClientRect();
    const btnWidth = btnPosition.width;
    const btnHeight = btnPosition.height;
    const windowWidth = window.innerWidth;
    this.model.menu.style.top = `${btnHeight + 5}px`;

    /* istanbul ignore next line */
    if (windowWidth < btnPosition.right + (menuWidth - btnWidth)) {
      this.alignRight();
    } else {
      this.alignLeft();
    }
  }
  alignLeft() {
    this.model.menu.style.left = 0;
    this.model.menu.style.right = null;
  }
  alignRight() {
    this.model.menu.style.left = null;
    this.model.menu.style.right = 0;
  }
}
/* harmony default export */ var overflowmenu = (OverflowMenu);
;// CONCATENATED MODULE: ./node_modules/@babel/runtime/helpers/esm/defineProperty.js
function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
;// CONCATENATED MODULE: ./source/scripts/components/pagination.js

class Pagination {
  // TODO: refactor to calculate with rems instead of pixels

  constructor(params) {
    _defineProperty(this, "itemPad", 6);
    _defineProperty(this, "itemWidth", 44);
    _defineProperty(this, "navPad", 16);
    _defineProperty(this, "ellipsesWidth", 32);
    _defineProperty(this, "ellipsesMargin", 8);
    if (!params.target) {
      throw new Error('Pagination: No target element passed');
    }
    this.selectors = {
      target: params.target,
      container: params.target.querySelector('div.page-list'),
      ul: params.target.querySelector('ul.pages'),
      highlight: params.target.getElementsByClassName('selector')[0],
      prev: params.target.querySelector('button.prev'),
      next: params.target.querySelector('button.next'),
      sr: params.target.querySelector('span.sr-only')
    };
    this.model = {
      total: Number(this.selectors.target.dataset.total) || 10,
      current: Number(this.selectors.target.dataset.current) ? Number(this.selectors.target.dataset.current) - 1 : 0,
      url: this.selectors.target.dataset.url || '',
      buttons: this.selectors.target.dataset.buttons,
      skipFirstTxt: this.selectors.target.dataset.skipFirstTxt || 'Skip to first page',
      skipLastTxt: this.selectors.target.dataset.skipLastTxt || 'Skip to last page'
    };
    this.populateList();
    this.populateEllipses();
    this.centerCurrent();
    this.toggleEllipses();
    this.toggleDisplayable();
    this.disableNavBtns();
    this.moveHightlight();
    this.wrapListContainer();
    window.addEventListener('resize', () => {
      this.centerCurrent();
      this.toggleEllipses();
      this.toggleDisplayable();
      this.moveHightlight();
    });
    this.selectors.prev.onclick = () => {
      this.setCurrent(this.model.current - 1);
    };
    this.selectors.next.onclick = () => {
      this.setCurrent(this.model.current + 1);
    };
  }
  populateList() {
    this.model.buttons ? this.selectors.target.setAttribute('role', 'group') : this.selectors.target.setAttribute('role', 'navigation');
    this.selectors.target.setAttribute('aria-label', 'pagination');
    this.selectors.ul.setAttribute('role', 'none');
    for (let i = 0; i < this.model.total; i += 1) {
      // Create <li> elements
      const itemContainer = document.createElement('li');
      itemContainer.className = 'itemContainer';
      itemContainer.setAttribute('data-index', i);
      itemContainer.setAttribute('role', 'listitem');
      if (i === this.model.current) {
        itemContainer.classList.add('current');
      }

      // Create inner <a> or <button> of <li> element
      const item = this.model.buttons ? document.createElement('button') : document.createElement('a');
      !this.model.buttons && item.setAttribute('href', `${this.model.url}/${i + 1}`);
      item.innerHTML = i + 1;
      item.className = 'item';
      item.onclick = () => {
        this.setCurrent(i);
      };
      itemContainer.appendChild(item);
      this.selectors.ul.appendChild(itemContainer);
      if (itemContainer.classList.contains('current')) {
        item.setAttribute('aria-current', 'page');
      }
    }
  }
  getCurrent() {
    return this.model.current;
  }
  getCurrentEl() {
    return this.selectors.target.querySelectorAll(`[data-index='${this.model.current}']:not(.first)`)[0];
  }
  moveHightlight() {
    this.selectors.highlight.style.left = `${this.getCurrentEl().offsetLeft}px`;
  }

  // Remove current class from old item, update model to new value, and recenter
  setCurrent(i) {
    if (i >= this.model.total) {
      throw new Error('Update page index out of bounds');
    }
    this.getCurrentEl().classList.remove('current');
    this.getCurrentEl().querySelector('.item').removeAttribute('aria-current');
    this.model.current = i;
    this.getCurrentEl().classList.add('current');
    this.getCurrentEl().querySelector('.item').setAttribute('aria-current', 'page');
    this.centerCurrent();
    this.toggleEllipses();
    this.toggleDisplayable();
    this.disableNavBtns();
    this.selectors.sr.innerHTML = `On page ${i + 1} of ${this.model.total}`;
    this.moveHightlight();
  }

  // Puts the current item in the center of the container by offsetting the
  // container's left position, but restricts its bounds so that it no longer
  // centers when the current item is near the beginning or end of the list
  centerCurrent() {
    const listWidth = this.selectors.target.getBoundingClientRect().width - this.navPad * 2 - this.selectors.prev.getBoundingClientRect().width - this.selectors.next.getBoundingClientRect().width;
    const displayableItemsTotal = Math.floor(listWidth / (this.itemWidth + this.itemPad));
    this.displayableItems = displayableItemsTotal % 2 === 0 ? displayableItemsTotal - 1 : displayableItemsTotal;
    if (this.displayableItems <= this.model.total) {
      this.selectors.container.style.width = `${this.displayableItems * (this.itemWidth + this.itemPad)}px`;
    } else {
      this.selectors.container.style.width = `${this.model.total * (this.itemWidth + this.itemPad)}px`;
    }
    const halfDisplayableItems = (this.displayableItems - 1) / 2;
    this.firstDisplayableItem = this.model.current - halfDisplayableItems;

    // Left bounds
    if (this.firstDisplayableItem < 0) {
      this.firstDisplayableItem = 0;
    }
    // Right bounds
    if (this.firstDisplayableItem > this.model.total - this.displayableItems) {
      this.firstDisplayableItem = this.model.total - this.displayableItems;
    }
    this.lastDisplayableItem = this.firstDisplayableItem + this.displayableItems;
    let listOffset;
    if (this.displayableItems <= this.model.total && this.firstDisplayableItem !== 0) {
      listOffset = this.selectors.container.offsetWidth - (this.displayableItems - 2) * (this.itemWidth + this.navPad / 2);
    } else {
      listOffset = 0;
    }
    this.selectors.ul.style.left = `${listOffset}px`;
  }

  // Generate ellipses and edge links for jumping to the very beginning and very ends
  populateEllipses() {
    this.firstItem = this.model.buttons ? document.createElement('button') : document.createElement('a');
    this.firstItem.className = 'item first hidden';
    this.firstItem.innerHTML = '1';
    this.firstItem.setAttribute('data-index', 0);
    !this.model.buttons && this.firstItem.setAttribute('href', `${this.model.url}/1`);
    this.firstItem.setAttribute('title', `${this.model.skipFirstTxt}`);
    this.firstItem.onclick = () => {
      this.setCurrent(0);
    };
    this.firstEllipses = document.createElement('div');
    this.firstEllipses.className = 'item after-first hidden';
    this.firstEllipses.innerHTML = '...';
    this.firstEllipses.setAttribute('role', 'listitem');
    this.lastItem = this.model.buttons ? document.createElement('button') : document.createElement('a');
    this.lastItem.className = 'item last hidden';
    this.lastItem.innerHTML = this.model.total;
    this.lastItem.setAttribute('data-index', this.model.total - 1);
    !this.model.buttons && this.lastItem.setAttribute('href', `${this.model.url}/${this.model.total}`);
    this.lastItem.setAttribute('title', `${this.model.skipLastTxt}`);
    this.lastItem.onclick = () => {
      this.setCurrent(this.model.total - 1);
    };
    this.lastEllipses = document.createElement('div');
    this.lastEllipses.className = 'item before-last hidden';
    this.lastEllipses.innerHTML = '...';
    this.lastEllipses.setAttribute('role', 'listitem');
    this.firstItemContainer = document.createElement('div');
    this.firstItemContainer.classList.add('flex-inline');
    this.firstItemContainer.setAttribute('role', 'listitem');
    this.firstItemContainer.append(this.firstItem);
    this.selectors.ul.before(this.firstItemContainer);
    this.selectors.ul.before(this.firstEllipses);
    this.lastItemContainer = document.createElement('div');
    this.lastItemContainer.classList.add('flex-inline');
    this.lastItemContainer.setAttribute('role', 'listitem');
    this.lastItemContainer.append(this.lastItem);
    this.selectors.container.appendChild(this.lastEllipses);
    this.selectors.container.appendChild(this.lastItemContainer);
  }

  // Toggle left and right ellipses
  toggleEllipses() {
    this.leftEllipses = this.firstDisplayableItem > 0 ? 2 : 0;
    this.rightEllipses = this.lastDisplayableItem < this.model.total ? 2 : 0;
    if (this.leftEllipses > 0) {
      this.firstItem.classList.remove('hidden');
      this.firstEllipses.classList.remove('hidden');
    } else {
      this.firstItem.classList.add('hidden');
      this.firstEllipses.classList.add('hidden');
    }
    if (this.rightEllipses > 0) {
      this.lastItem.classList.remove('hidden');
      this.lastEllipses.classList.remove('hidden');
    } else {
      this.lastItem.classList.add('hidden');
      this.lastEllipses.classList.add('hidden');
    }
  }

  // Set each item's visibility
  toggleDisplayable() {
    for (let i = 0; i < this.model.total; i += 1) {
      const item = this.selectors.target.querySelectorAll(`[data-index='${i}']:not(.first)`)[0];
      const addRemoveinvisible = i >= this.firstDisplayableItem + this.leftEllipses && i < this.lastDisplayableItem - this.rightEllipses ? 'remove' : 'add';
      item.classList[addRemoveinvisible]('hidden');
    }
  }

  // If there is no next or prev, disable button
  disableNavBtns() {
    this.selectors.prev.disabled = false;
    this.selectors.next.disabled = false;
    const current = this.getCurrent();
    if (current === 0) {
      this.selectors.prev.disabled = true;
    } else if (current === this.model.total - 1) {
      this.selectors.next.disabled = true;
    }
  }
  wrapListContainer() {
    this.listContainer = document.createElement('div');
    this.listContainer.setAttribute('role', 'list');
    this.listContainer.classList.add('flex-inline');
    this.selectors.prev.before(this.listContainer);
    this.prevContainer = document.createElement('div');
    this.prevContainer.append(this.selectors.prev);
    this.prevContainer.classList.add('flex-inline');
    this.prevContainer.setAttribute('role', 'listitem');
    this.nextContainer = document.createElement('div');
    this.nextContainer.append(this.selectors.next);
    this.nextContainer.classList.add('flex-inline');
    this.nextContainer.setAttribute('role', 'listitem');
    this.listContainer.append(this.prevContainer);
    this.listContainer.append(this.selectors.container);
    this.listContainer.append(this.nextContainer);
    this.selectors.highlight.setAttribute('role', 'none');
    this.selectors.container.setAttribute('role', 'none');
  }
}
/* harmony default export */ var pagination = (Pagination);
// EXTERNAL MODULE: ./source/shared/assets.js
var assets = __webpack_require__(460);
;// CONCATENATED MODULE: ./source/scripts/components/phonefield.js

class Phonefield {
  constructor(params) {
    if (!params.target) {
      throw new Error('Phonefield: No target element passed');
    }
    this.selectors = {
      target: params.target,
      select: params.target.getElementsByTagName('select')[0],
      options: params.target.querySelectorAll('option'),
      input: params.target.getElementsByTagName('input')[0],
      alert: '',
      message: '',
      flag: '',
      error: ''
    };
    this.model = {
      locale: params.target.dataset.locale || 'en-US',
      country: params.target.dataset.country || 'United States',
      callingCode: params.target.dataset.callingCode || '1',
      callingCodeLabel: params.target.dataset.callingCodeLabel || 'phone prefix',
      phoneFormat: params.target.dataset.phoneFormat || '### ### ####',
      showFlag: params.target.dataset.showFlag !== undefined,
      showCallingCode: params.target.dataset.showCallingCode !== undefined,
      value: this.selectors.input.value,
      validationId: params.target.dataset.validationId
    };

    // make sure input type is 'tel'
    this.selectors.input.type = 'tel';
    this.getAlerts();
    this.addFlag();
    this.addPrefix();
    this.setMaxLength();
    if (this.selectors.select) {
      this.selectors.select.value = this.model.locale;
      this.selectors.select.onchange = () => {
        this.handleSelect();
      };
    }
    this.selectors.input.onfocus = () => {
      this.selectors.target.classList.add('focus');
      this.selectors.target.classList.remove('has-warning');
      this.selectors.input.value = this.model.value.replace(/\D/g, '');
    };
    this.selectors.input.addEventListener('input', event => {
      this.selectors.input.value = event.target.value.replace(/\D/g, '').slice(0, this.model.maxLength);
    });
    this.selectors.input.onblur = () => {
      this.selectors.target.classList.remove('focus');
      this.validateRequired();
      this.model.value = this.selectors.input.value;
      if (this.selectors.input.value) {
        this.selectors.input.value = this.formatPhoneNumber(this.selectors.input.value);
      }
    };
  }
  formatPhoneNumber(val) {
    const entry = val.split('');
    const format = this.model.phoneFormat.split('');
    let str = '';
    for (let i = 0; i < format.length; i += 1) {
      if (format[i] === '#') {
        if (entry.length === 0) break;
        str += entry.shift();
      } else {
        str += format[i];
      }
    }
    return str;
  }
  getAlerts() {
    const message = this.selectors.input.getAttribute('aria-describedby') ? this.selectors.input.getAttribute('aria-describedby').split(' ')[0] : '';
    if (message) {
      this.selectors.alert = document.getElementById(message);
      if (this.selectors.alert) {
        this.selectors.error = this.selectors.alert.querySelector('.msg');
      }
    }
  }
  addFlag() {
    if (!this.selectors.select && this.model.showFlag && !this.selectors.flag) {
      const flagWrapper = document.createElement('div');
      flagWrapper.classList.add('flag');
      this.selectors.target.insertBefore(flagWrapper, this.selectors.target.childNodes[0]);
      this.selectors.flag = document.createElement('span');
      this.selectors.flag.classList.add('dls-flag');
      flagWrapper.appendChild(this.selectors.flag);
      this.updateFlag();
    }
  }
  addPrefix() {
    if (!this.selectors.prefix && (this.model.showCallingCode || this.selectors.select)) {
      let prefix = document.createElement('span');
      prefix.classList.add('prefix');
      this.selectors.input.parentNode.appendChild(prefix);
      if (this.selectors.select) {
        prefix = document.createElement('span');
        prefix.classList.add('prefix');
        prefix.setAttribute('aria-label', this.model.callingCodeLabel);
        this.selectors.target.getElementsByClassName('countries')[0].appendChild(prefix);
      }
      this.selectors.prefix = prefix;
      this.updatePrefix();
    }
  }
  updatePrefix() {
    this.selectors.prefix.innerHTML = `+ ${this.model.callingCode}`;
    if (!this.selectors.select) {
      this.selectors.input.style.paddingLeft = `${(this.model.callingCode.toString().length * 8 + 28) / 16}rem`;
    }
  }
  updateFlag() {
    const flag = this.model.locale.replace(/(.*-)(.*)/, '$2').toLowerCase();
    const imgSrc = `${assets.assetCDN}/img/flags/dls-flag-${flag}.svg`;
    const imgAlt = this.model.country.replace(/\s{2,}/g, '');
    this.selectors.flag.innerHTML = `<img src=${imgSrc} alt='${imgAlt}'>`;
  }
  handleSelect() {
    // remove warnings
    this.selectors.target.classList.remove('has-warning');

    // set selected values
    const selectedOption = this.selectors.options[this.selectors.select.selectedIndex];
    this.model.locale = selectedOption.value;
    this.model.callingCode = selectedOption.dataset.callingCode;
    this.model.phoneFormat = selectedOption.dataset.phoneFormat;
    this.model.country = selectedOption.text.replace(` +${this.model.callingCode}`, '');
    this.selectors.input.value = '';
    this.model.value = this.selectors.input.value;
    this.setMaxLength();
    this.updatePrefix();
    this.clearWarning();
  }
  setMaxLength() {
    this.model.maxLength = this.model.phoneFormat.match(/#/g).length;
  }
  clearWarning() {
    this.selectors.target.classList.remove('has-warning');
    if (this.selectors.alert) {
      this.selectors.alert.classList.add('hidden');
    }
  }
  validateRequired() {
    if (this.selectors.input.required && this.selectors.input.value.length < this.model.maxLength) {
      this.selectors.target.classList.add('has-warning');
      if (this.selectors.alert) {
        this.selectors.alert.classList.remove('hidden');
        if (this.selectors.error) {
          this.setErrorMessage();
        }
      }
    } else {
      this.clearWarning();
    }
  }
  setErrorMessage() {
    const inputLength = `${this.model.maxLength}`;
    const msg = '-Digit Phone number is required';
    this.selectors.error.innerText = inputLength.concat(msg);
  }
}
/* harmony default export */ var phonefield = (Phonefield);
;// CONCATENATED MODULE: ./source/scripts/components/search.js
class Search {
  constructor(params) {
    if (!params.target) {
      throw new Error('Search: No target element specified');
    }
    if (!params.config) {
      console.warn('No search config specified');
      return;
    }
    this.selectors = {
      target: params.target,
      input: params.target.querySelector('input'),
      button: params.target.querySelector('button'),
      results: params.target.getElementsByClassName('search-results')[0]
    };
    this.config = {
      source: params.config.source,
      find: params.config.find || this.fuzzySearch,
      searchTerm: params.config.searchTerm || 'title',
      min: params.config.min,
      limit: params.config.limit,
      typeAhead: params.config.typeAhead,
      filterResults: params.config.filterResults,
      resultTemplate: params.config.resultTemplate || '<a href="%url%">%title%</a>',
      resultHeader: params.config.resultHeader || '',
      resultFooter: params.config.resultFooter || '',
      alert: params.config.alert || ''
    };
    this.getData();
    this.setup();
    document.addEventListener('click', e => {
      // ignoring coverage for the `else` block that does not exist
      /* istanbul ignore else */
      if (!this.selectors.target.contains(e.target)) {
        this.reset();
      }
    });
    if (this.config.typeAhead && this.config.typeAhead !== 'false') {
      this.selectors.input.onkeyup = e => {
        if (e.key === 'Escape' || e.key === 'Esc' || this.selectors.input.value.length < 1) {
          this.reset();
        } else {
          this.search();
        }
      };
    }
    this.selectors.button.onclick = e => {
      if (this.selectors.button.classList.contains('dls-icon-search')) {
        this.search();
      } else {
        this.reset();
      }
      e.preventDefault();
    };
  }
  setup() {
    if (!this.selectors.results) {
      const results = document.createElement('ul');
      results.classList.add('search-results');
      results.setAttribute('aria-live', 'polite');
      this.selectors.target.appendChild(results);
      this.selectors.results = results;
    }
  }
  reset() {
    this.selectors.input.value = '';
    this.selectors.button.classList.add('dls-icon-search');
    this.selectors.button.classList.remove('dls-icon-close', 'btn-tertiary', 'btn');
    this.selectors.button.setAttribute('aria-expanded', 'false');
    this.selectors.results.innerHTML = '';
  }
  search() {
    this.selectors.results.innerHTML = '';
    if (!this.selectors.input.value.length || !this.source || this.selectors.input.value.length < this.config.min) {
      return;
    }

    // update button icon to loading
    this.selectors.button.classList.remove('dls-icon-search');
    this.selectors.button.classList.add('btn');
    this.selectors.button.classList.add('btn-tertiary');
    this.selectors.button.classList.add('btn-loading');
    let matches = this.findMatches(this.source, this.selectors.input.value);
    if (this.config.filterResults) {
      matches = this.config.filterResults(matches);
    }
    if (this.config.limit) {
      matches = matches.slice(0, parseInt(this.config.limit, 10));
    }
    this.populateMatches(matches);

    // update button icon to close
    this.selectors.button.classList.remove('btn');
    this.selectors.button.classList.remove('btn-tertiary');
    this.selectors.button.classList.remove('btn-loading');
    this.selectors.button.classList.add('icon');
    this.selectors.button.classList.add('icon-hover');
    this.selectors.button.classList.add('icon-sm');
    this.selectors.button.classList.add('dls-icon-close');
    this.selectors.button.setAttribute('aria-expanded', 'true');
  }
  findMatches(data, val) {
    let result;
    const regex = new RegExp(this.config.find(val));
    if (Array.isArray(this.config.searchTerm)) {
      this.config.searchTerm.forEach(term => {
        result = data.filter(item => regex.test(item[term]));
      });
    } else {
      result = data.filter(item => regex.test(item[this.config.searchTerm]));
    }
    return result;
  }
  renderTemplate(match, template) {
    let rendered = template;
    Object.keys(match).forEach(key => {
      rendered = rendered.replace(`%${key}%`, match[key]);
    });
    return rendered;
  }
  formatValue(template) {
    const regex = /%value%/g;
    return template.replace(regex, this.selectors.input.value);
  }
  populateMatches(matches) {
    if (matches.length < 1 && this.config.alert) {
      this.selectors.results.innerHTML += `<li class="search-results-item">
          ${this.config.alert}
        </li>`;
    } else {
      if (this.config.resultHeader) {
        this.selectors.results.innerHTML += `<li class="search-results-item">
            ${this.formatValue(this.config.resultHeader)}
          </li>`;
      }
      matches.forEach(match => {
        this.selectors.results.innerHTML += `<li class="search-results-item">
            ${this.renderTemplate(match, this.config.resultTemplate)}
          </li>`;
      });
      if (this.config.resultFooter) {
        this.selectors.results.innerHTML += `<li class="search-results-item">
          ${this.formatValue(this.config.resultFooter)}
        </li>`;
      }
    }
  }
  fuzzySearch(val) {
    return new RegExp(`${val.toString().trim().replace(/[\W_]+/g, '.*?')}.*?`, 'gi');
  }
  getData() {
    return new Promise((resolve, reject) => {
      const request = new XMLHttpRequest();
      request.open('GET', this.config.source, true);
      request.setRequestHeader('Accept', '*/*');
      request.send();
      request.onreadystatechange = () => {
        if (request.readyState === 4) {
          try {
            resolve(this.source = JSON.parse(request.response));
          } catch (e) {
            console.warn('JSON Parsing Error:', this.source, e);
            reject(request.response);
          }
        }
      };
    });
  }
}
/* harmony default export */ var search = (Search);
;// CONCATENATED MODULE: ./source/scripts/components/searchfield.js
class SearchField {
  constructor(params) {
    if (!params.target) {
      throw new Error('SearchField: No target element specified');
    }
    this.selectors = {
      target: params.target,
      input: params.target.querySelector('[type="search"]'),
      clearButton: params.target.querySelectorAll('button.dls-icon-close, button.btn-form-close')[0],
      searchResults: params.target.querySelector('.search-results'),
      suggestionInput: params.target.querySelector('[name="suggestion-value"]')
    };
    if (!this.selectors.input) {
      throw new Error('SearchField: No search input specified');
    }
    if (!this.selectors.clearButton) {
      throw new Error('SearchField: No clear button specified');
    }
    this.model = {
      activeSuggestionIndex: -1,
      activeClass: 'searchfield-suggestion-active',
      suggestionClass: 'searchfield-suggestion'
    };
    this.initializeEventListeners();
    this.addComboboxMarkup();
  }
  initializeEventListeners() {
    this.selectors.target.addEventListener('submit', this.handleFormSubmit.bind(this));
    this.selectors.input.addEventListener('keyup', this.handleKeyUp.bind(this));
    this.selectors.input.addEventListener('keydown', this.handleKeyDown.bind(this));
    this.selectors.target.addEventListener('mouseenter', this.handleMouseEnter.bind(this), true);
    this.selectors.target.addEventListener('mouseleave', this.handleMouseLeave.bind(this), true);
    this.selectors.target.addEventListener('click', this.handleComponentClick.bind(this), true);
    this.selectors.clearButton.addEventListener('click', this.handleClearButtonClick.bind(this));
    document.addEventListener('click', this.handleClickOutside.bind(this));
  }

  /**
   * Hide search results
   */
  hideSearchResults() {
    const {
      searchResults
    } = this.selectors;
    if (searchResults && !searchResults.classList.contains('hidden') && !searchResults.dataset.alwaysVisible) {
      searchResults.classList.add('hidden');
      return true;
    }
    return false;
  }

  /**
   * Shows/hides the clear button based on the value of the input
   *
   * @param {Object} event - The keyboard event
   */
  handleKeyUp(event) {
    const {
      target: {
        value
      }
    } = event;
    const isHidden = this.selectors.clearButton.classList.contains('hidden');
    if (value && isHidden || !value && !isHidden) {
      this.toggleClearButton();
    }
  }

  /**
   * Calls keyboard navigation function for the results
   *
   * @param {Object} event - The keyboard event
   */
  handleKeyDown(event) {
    const {
      key
    } = event;
    if (key === 'Enter' || key === ' ' || event.code === 'Space') {
      const suggestionClass = this.model.suggestionClass;
      const suggestions = Array.from(this.selectors.target.getElementsByClassName(suggestionClass));
      if (this.model.activeSuggestionIndex !== -1) {
        suggestions[this.model.activeSuggestionIndex].querySelector('a').click();
      } else {
        this.handleFormSubmit();
      }
    }
    if (key === 'ArrowDown' || key === 'ArrowUp') {
      this.updateActiveSuggestion(event, key);
    }
  }

  /**
   * Adds active class to the target searchfield-suggestion and removes it from any others
   * Updates the index of the currently hovered item
   *
   * @param {Object} event - The mouse event
   */
  handleMouseEnter(event) {
    const {
      target
    } = event;
    const {
      activeClass,
      suggestionClass
    } = this.model;
    if (target.classList.contains(suggestionClass)) {
      const suggestions = Array.from(this.selectors.target.getElementsByClassName(suggestionClass));
      suggestions.forEach(suggestion => {
        if (suggestion.classList.contains(activeClass)) {
          suggestion.classList.remove(activeClass);
        }
      });
      this.model.activeSuggestionIndex = suggestions.indexOf(target);
      target.classList.toggle(activeClass);
    }
  }

  /**
   * Removes the active class from the suggestion if present
   *
   * @param {Object} event - The mouse event
   */
  handleMouseLeave(event) {
    const {
      target
    } = event;
    const {
      activeClass
    } = this.model;
    const {
      input
    } = this.selectors;
    if (target.classList.contains(activeClass)) {
      target.classList.remove(activeClass);
      this.model.activeSuggestionIndex = -1;
    }
    input.setAttribute('aria-activedescendant', '');
  }
  handleComponentClick(event) {
    const {
      target
    } = event;
    const {
      suggestionClass
    } = this.model;
    if (target.classList.contains(suggestionClass)) {
      this.selectors.input = target.dataset.suggestionvalue;
      this.hideSearchResults();
      this.model.activeSuggestionIndex = -1;
    }
  }

  /**
   * Clears the value of the input and shows the clear button
   */
  handleClearButtonClick(event) {
    event.preventDefault();
    this.selectors.input.value = '';
    this.toggleClearButton();
  }

  /**
   * Hides the results if the click is outside of the search
   *
   * @param {Object} event - The mouse event
   */
  handleClickOutside(event) {
    const {
      target
    } = this.selectors;
    if (!target.contains(event.target) && this.hideSearchResults()) {
      this.model.activeSuggestionIndex = -1;
    }
  }

  /**
   * Shows/hides the clear button
   */
  toggleClearButton() {
    this.selectors.clearButton.classList.toggle('hidden');
    this.selectors.input.focus();
  }

  /**
   * Hides the results and sets the active index to -1s
   */
  handleFormSubmit() {
    if (this.hideSearchResults()) {
      this.model.activeSuggestionIndex = -1;
    }
  }

  /**
   * Updates the active suggestion based on up and down navigation and available options
   *
   * @param {Object} event - The DOM event that triggered the update
   * @param {String} direction - The key direction of the arrows
   */
  updateActiveSuggestion(event, direction) {
    const {
      searchResults,
      input
    } = this.selectors;
    const {
      activeSuggestionIndex,
      activeClass,
      suggestionClass
    } = this.model;
    if (searchResults && !searchResults.classList.contains('hidden')) {
      const suggestions = searchResults.getElementsByClassName(suggestionClass);
      if (direction === 'ArrowDown' && activeSuggestionIndex < suggestions.length - 1) {
        event.preventDefault();
        // Remove from previous one if available
        if (activeSuggestionIndex >= 0) {
          suggestions[activeSuggestionIndex].classList.remove(activeClass);
        }
        this.model.activeSuggestionIndex += 1;
        const suggestion = suggestions[this.model.activeSuggestionIndex];
        suggestion.classList.toggle(activeClass);
        input.value = suggestion.dataset.suggestionvalue;
        input.setAttribute('aria-activedescendant', suggestion.getAttribute('id'));
      } else if (direction === 'ArrowUp' && activeSuggestionIndex >= 0) {
        // Make sure the cursor doesn't go to beginning of the input
        event.preventDefault();
        suggestions[activeSuggestionIndex].classList.remove(activeClass);
        this.model.activeSuggestionIndex -= 1;
        if (this.model.activeSuggestionIndex >= 0) {
          const suggestion = suggestions[this.model.activeSuggestionIndex];
          suggestion.classList.toggle(activeClass);
          input.value = suggestion.dataset.suggestionvalue;
          input.setAttribute('aria-activedescendant', suggestion.getAttribute('id'));
        }
      }
    }
  }

  /** Add combobox markup - ARIA roles, states, properties to the search field and search results */
  addComboboxMarkup() {
    const {
      searchResults,
      input,
      target
    } = this.selectors;
    if (searchResults) {
      input.setAttribute('aria-activedescendant', '');
      const options = searchResults.querySelectorAll('.search-results-item');
      for (let i = 0; i < options.length; i += 1) {
        options[i].setAttribute('id', target.getAttribute('id').concat('-', i));
        const optionLink = options[i].querySelector('a');
        if (optionLink) {
          optionLink.classList.add('search-results-item-link');
          optionLink.setAttribute('tabindex', '-1');
        }
      }
    }
  }
}
/* harmony default export */ var searchfield = (SearchField);
;// CONCATENATED MODULE: ./source/scripts/components/select.js
class Select {
  constructor(params) {
    if (!params.target) {
      throw new Error('Select Dropdown: No target element passed');
    }
    this.selectors = {
      target: params.target,
      select: params.target.getElementsByTagName('select')[0],
      options: params.target.getElementsByTagName('option'),
      label: params.target.getElementsByTagName('label')[0],
      alert: params.target.getElementsByTagName('select')[0].getAttribute('aria-describedby') || false
    };

    // initiate selected option label for two-lined dropdowns
    this.updateLabel();

    // update label with new selected
    this.selectors.select.onchange = () => {
      this.updateLabel();
      this.validateRequired();
    };
  }
  updateLabel() {
    // update label for two-lined dropdowns
    if (this.selectors.target.querySelector('.select-two-lined')) {
      const data = this.selectors.options[this.selectors.select.selectedIndex].dataset.label;
      this.selectors.label.innerHTML = data && this.selectors.label ? data : '';
    }
  }
  validateRequired() {
    this.selectors.message = this.selectors.alert ? document.getElementById(this.selectors.alert) : '';
    // warninng if required and nothing selected
    if (this.selectors.select.required && this.selectors.select.selectedIndex < 1 && !this.selectors.target.classList.contains('has-warning')) {
      this.selectors.target.classList.add('has-warning');
      if (this.selectors.alert && this.selectors.message) {
        this.selectors.message.classList.remove('hidden');
        this.selectors.select.setAttribute('aria-describedby', this.selectors.message.getAttribute('id'));
      }
    } else {
      this.selectors.target.classList.remove('has-warning');
      if (this.selectors.alert && this.selectors.message) {
        this.selectors.message.classList.add('hidden');
        this.selectors.select.removeAttribute('aria-describedby');
      }
    }
  }
}
/* harmony default export */ var components_select = (Select);
;// CONCATENATED MODULE: ./source/scripts/components/tooltip.js

class Tooltip {
  constructor(params) {
    if (!params.target) {
      throw new Error('Tooltip: No tooltip target element passed');
    }
    if (!params.target.querySelector('[data-attach-tooltip]')) {
      throw new Error('Tooltip: Tooltip must be attached to an element with data attr "data-attach-tooltip"');
    }
    this.selectors = {
      target: params.target,
      button: params.target.querySelector('[data-attach-tooltip]'),
      tooltip: params.target.getElementsByClassName('tooltip')[0],
      inner: params.target.getElementsByClassName('tooltip-inner')[0],
      arrow: params.target.getElementsByClassName('tooltip-arrow')[0],
      infoClose: params.target.getElementsByClassName('tooltip-close')[0],
      arrowtip: params.target.getElementsByClassName('tooltip-arrow-pointer')[0]
    };
    this.model = {
      type: this.selectors.tooltip.dataset.type,
      placement: this.selectors.tooltip.dataset.placement,
      clickedOpen: false,
      hoverActive: false,
      trigger: this.selectors.tooltip.dataset.trigger
    };
    this.align();

    // initiate tooltip properties for tooltip button only & not for slider button.
    if (this.selectors.button.getAttribute('role') !== 'slider') {
      this.initiateToolTipAttributesOnPageLoad();
    }
    window.addEventListener('resize', () => {
      this.align();
    });
    if (this.model.trigger !== 'none') {
      this.selectors.button.onclick = () => {
        this.model.clickedOpen = !this.model.clickedOpen;
        this.model.clickedOpen ? this.open() : this.close();
      };
      this.selectors.target.onkeydown = e => {
        if (e.key === 'Escape' || e.key === 'Esc') {
          this.close();
          this.model.clickedOpen = false;
          this.selectors.button.focus();
        }
      };
      document.addEventListener('click', e => {
        this.align();
        if (!this.selectors.target.contains(e.target)) {
          this.close();
          this.model.clickedOpen = false;
        }
      });
      document.addEventListener('keydown', e => {
        if (!this.selectors.tooltip.classList.contains('hidden') && e.key === 'Escape') {
          this.close();
          this.model.clickedOpen = false;
          this.selectors.button.focus();
        }
      });
      if (this.selectors.infoClose) {
        this.selectors.infoClose.onclick = () => {
          this.close();
          this.model.clickedOpen = false;
          this.selectors.button.focus();
        };
        this.selectors.infoClose.onblur = () => {
          this.close();
        };
      }
      if (this.model.trigger !== 'click') {
        this.selectors.button.onmouseover = () => {
          !this.model.clickedOpen && this.open();
        };
        this.selectors.button.onmouseout = e => {
          if (e && e.relatedTarget != null && !(e.relatedTarget.classList.contains('tooltip-arrow-pointer') || e.relatedTarget.classList.contains('tooltip-inner'))) {
            !this.model.clickedOpen && this.close();
          }
        };
        this.selectors.arrow.onmouseout = e => {
          if (e && e.relatedTarget != null && !e.relatedTarget.classList.contains('tooltip-inner')) {
            !this.model.clickedOpen && this.close();
          }
        };
        this.selectors.inner.onmouseout = e => {
          if (e && e.relatedTarget != null && !e.relatedTarget.classList.contains('tooltip-arrow-pointer')) {
            !this.model.clickedOpen && this.close();
          }
        };
      }
    }
  }
  initiateToolTipAttributesOnPageLoad() {
    this.selectors.tooltip.classList.add('hidden');
    this.selectors.tooltip.setAttribute('aria-hidden', 'true');
    this.selectors.button.setAttribute('aria-expanded', 'false');
    this.selectors.button.removeAttribute('aria-describedby');
  }
  open() {
    this.selectors.tooltip.classList.add('anim-in');
    this.selectors.tooltip.classList.remove('hidden');
    this.selectors.button.setAttribute('aria-expanded', 'true');
    this.selectors.button.setAttribute('aria-describedby', this.selectors.inner.getAttribute('id'));
    this.selectors.tooltip.setAttribute('aria-hidden', 'false');
    this.model.type === 'info' && this.selectors.button.classList.add('tooltip-enabled');
    if (this.selectors.button.classList.contains('badge')) {
      this.selectors.button.classList.add('filled');
    }
    if (this.selectors.button.classList.contains('icon')) {
      const iconClassName = this.selectors.button.className.match(/(?!\S*-filled)dls-icon-\S*/);
      if (iconClassName && iconClassName.length > 0) {
        this.selectors.button.className = this.selectors.button.className.replace(iconClassName[0], `${iconClassName[0]}-filled`);
      }
    }
  }
  close() {
    this.selectors.tooltip.classList.add('hidden');
    this.selectors.button.setAttribute('aria-expanded', 'false');
    this.selectors.button.removeAttribute('aria-describedby');
    this.selectors.tooltip.setAttribute('aria-hidden', 'true');
    this.selectors.tooltip.classList.remove('anim-in');
    this.model.type === 'info' && this.selectors.button.classList.remove('tooltip-enabled');
    if (this.selectors.button.classList.contains('badge')) {
      this.selectors.button.classList.remove('filled');
    }
    if (this.selectors.button.classList.contains('icon')) {
      const iconClassNameFilled = this.selectors.button.className.match(/dls-icon-\S*-filled/);
      if (iconClassNameFilled && iconClassNameFilled.length > 0) {
        this.selectors.button.className = this.selectors.button.className.replace(iconClassNameFilled[0], iconClassNameFilled[0].replace('-filled', ''));
      }
    }
  }
  align() {
    this.selectors.inner.removeAttribute('style');
    this.model.placement = this.selectors.tooltip.dataset.placement;
    const tooltipHeight = this.selectors.inner.getBoundingClientRect().height;
    const tooltipWidth = Math.round(this.selectors.inner.getBoundingClientRect().width);
    let btnWidth = Math.round(this.selectors.button.getBoundingClientRect().width);
    const btnHeight = this.selectors.button.getBoundingClientRect().height;

    // Temp fix for icon width late render issue

    if (this.selectors.button.classList.contains('icon') || this.selectors.button.classList.contains('glyph')) btnWidth = btnHeight;
    this.model.centerX = tooltipWidth / 2 - btnWidth / 2;
    this.model.centerY = Math.floor(tooltipHeight / 2 - btnHeight / 2);

    // If mobile view, force all tooltips to top positioning

    if (window.innerWidth <= this.pixStrToNum(breakpoints_namespaceObject.f.md)) {
      this.model.placement = 'top';
      this.selectors.tooltip.setAttribute('data-placement', this.model.placement);
    }
    const toLeft = this.selectors.inner.getBoundingClientRect().left;
    const toRight = this.selectors.inner.getBoundingClientRect().right;

    // Check if tooltip is overflowing off left or right side of page

    // If top or bottom, align left side of tooltip left side of page
    if (toLeft <= 0 && (this.model.placement === 'top' || this.model.placement === 'bottom')) {
      this.selectors.inner.style.left = `${-toLeft}px`;
    } else if (toLeft <= 0 && this.model.placement === 'left') {
      // If left, switch tooltip side to right
      this.model.placement = 'right';
    } else if (window.innerWidth - toRight <= 0 && (this.model.placement === 'top' || this.model.placement === 'bottom')) {
      // If top or bottom, align right side of tooltip to right side of page
      this.selectors.inner.style.right = `${-(window.innerWidth - toRight)}px`;
    } else if (window.innerWidth - toRight <= 0 && this.model.placement === 'right') {
      // If right, switch tooltip side to left
      this.model.placement = 'left';
    }
    this.selectors.tooltip.setAttribute('data-placement', this.model.placement);
  }
  pixStrToNum(pxStr) {
    return Number(pxStr.replace(/[a-z]/ig, ''));
  }
}
/* harmony default export */ var tooltip = (Tooltip);
;// CONCATENATED MODULE: ./source/scripts/components/slider.js


class Slider {
  constructor(params) {
    if (!params.target) {
      throw new Error('Slider: No target element passed');
    }
    this.selectors = {
      target: params.target,
      sliderHandle: params.target.querySelector('[role="slider"]'),
      sliderBar: params.target.getElementsByClassName('slider-bar')[0],
      sliderFill: params.target.getElementsByClassName('slider-selection')[0],
      ttContainer: params.target.getElementsByClassName('tooltip-container')[0],
      ttInner: params.target.getElementsByClassName('tooltip-inner')[0],
      add: params.target.getElementsByClassName('dls-glyph-plus')[0],
      subtract: params.target.getElementsByClassName('dls-glyph-minus')[0]
    };
    this.model = {
      min: this.initVal(this.selectors.sliderHandle.getAttribute('aria-valuemin'), 0),
      max: this.initVal(this.selectors.sliderHandle.getAttribute('aria-valuemax'), 10),
      step: this.initVal(this.selectors.sliderHandle.dataset.step, 1),
      value: this.initVal(this.selectors.target.dataset.value, 1),
      interval: this.initVal(this.selectors.target.dataset.interval, 500),
      activeDrag: false,
      range: 0,
      handlePosition: 0,
      barWidth: this.selectors.sliderBar.getBoundingClientRect().width,
      barLeftOffset: this.selectors.sliderBar.getBoundingClientRect().left,
      currency: this.selectors.target.dataset.currency,
      tooltipInstance: this.selectors.ttContainer ? new tooltip({
        target: this.selectors.ttContainer
      }) : null
    };

    // Forwards compatibility
    // First check to see if we need to target dls-icons instead of the iconfont glyph.
    // Then make sure we are targeting the parent button, not the child element.

    if (!this.selectors.add) {
      this.selectors.add = this.selectors.target.querySelector('[data-dls-glyph=plus]');
    }
    if (!this.selectors.subtract) {
      this.selectors.subtract = this.selectors.target.querySelector('[data-dls-glyph=minus]');
    }
    if (this.selectors.add.parentElement.tagName === 'BUTTON') {
      this.selectors.add = this.selectors.add.parentElement;
    }
    if (this.selectors.subtract.parentElement.tagName === 'BUTTON') {
      this.selectors.subtract = this.selectors.subtract.parentElement;
    }
    this.model.range = Math.sqrt((this.model.min - this.model.max) * (this.model.min - this.model.max));
    this.updateVal();
    if (this.selectors.ttContainer && this.selectors.ttInner) {
      this.updateTooltip();
    }
    window.addEventListener('resize', () => {
      this.model.barWidth = this.selectors.sliderBar.getBoundingClientRect().width;
      this.model.barLeftOffset = this.selectors.sliderBar.getBoundingClientRect().left;
      this.updateVal();
    });
    this.selectors.add.onmousedown = e => {
      e.preventDefault();
      e.stopPropagation();
      if (e.which === 3 || e.ctrlKey) {
        return false;
      }
      clearTimeout(this.interval);
      this.interval = setInterval(() => {
        this.selectors.add.focus();
        this.updateVal(this.model.step);
      }, this.model.interval);
    };
    this.selectors.add.onmouseup = () => {
      clearTimeout(this.interval);
    };
    this.selectors.add.onclick = e => {
      e.preventDefault();
      this.selectors.add.focus();
      this.updateVal(this.model.step);
    };
    this.selectors.subtract.onclick = e => {
      e.preventDefault();
      this.selectors.subtract.focus();
      this.updateVal(-this.model.step);
    };
    this.selectors.subtract.onmousedown = e => {
      e.preventDefault();
      e.stopPropagation();
      if (e.which === 3 || e.ctrlKey) {
        return false;
      }
      clearTimeout(this.interval);
      this.interval = setInterval(() => {
        this.selectors.subtract.focus();
        this.updateVal(-this.model.step);
      }, this.model.interval);
    };
    this.selectors.subtract.onmouseup = () => {
      clearTimeout(this.interval);
    };
    this.selectors.sliderHandle.addEventListener('keydown', e => {
      if (e.key.match(/ArrowLeft|Left|ArrowDown|Down/i)) {
        e.preventDefault();
        this.updateVal(-this.model.step);
      }
      if (e.key.match(/ArrowRight|Right|ArrowUp|Up/i)) {
        e.preventDefault();
        this.updateVal(this.model.step);
      }
    });
    this.selectors.sliderBar.addEventListener('mousedown', e => {
      this.model.activeDrag = true;
      this.model.handlePosition = e.clientX - this.model.barLeftOffset;
      this.draggedPosition();
      return false;
    });
    this.selectors.sliderBar.addEventListener('touchstart', e => {
      this.model.activeDrag = true;
      this.model.handlePosition = e.changedTouches[0].clientX - this.model.barLeftOffset;
      this.draggedPosition();
      return false;
    }, {
      passive: true
    });
    document.addEventListener('mousemove', e => {
      if (this.model.activeDrag) {
        this.model.handlePosition = e.clientX - this.model.barLeftOffset;
        this.draggedPosition();
      }
    });
    document.addEventListener('touchmove', e => {
      if (this.model.activeDrag) {
        this.model.handlePosition = e.changedTouches[0].clientX - this.model.barLeftOffset;
        this.draggedPosition();
      }
    }, {
      passive: true
    });
    document.addEventListener('mouseup', () => {
      this.model.activeDrag = false;
    });
    document.addEventListener('touchend', () => {
      this.model.activeDrag = false;
    });
  }
  initVal(val, def) {
    let num = def;
    if (val) {
      if (Number(val)) {
        num = Number(val);
      } else if (Number(val) === 0) {
        num = 0;
      }
    }
    return num;
  }
  setVal(val) {
    this.model.value = val;
    this.updateVal();
  }
  updateVal() {
    let step = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    this.model.value = Math.max(this.model.min, Math.min(this.model.value + step, this.model.max));
    if (this.model.value % this.model.step !== 0) {
      this.model.value = Math.ceil(this.model.value / this.model.step) * this.model.step;
    }
    this.selectors.sliderHandle.setAttribute('aria-valuenow', this.model.value);
    this.setHandlePosition(this.model.value);
    if (this.selectors.ttContainer && this.selectors.ttInner) {
      this.updateTooltip();
    }
    if (this.model.value > this.model.min) {
      this.selectors.subtract.removeAttribute('disabled');
    } else {
      this.selectors.subtract.setAttribute('disabled', 'true');
      clearTimeout(this.interval);
    }
    if (this.model.value < this.model.max) {
      this.selectors.add.removeAttribute('disabled');
    } else {
      this.selectors.add.setAttribute('disabled', 'true');
      clearTimeout(this.interval);
    }
  }
  draggedPosition() {
    const posPercent = this.model.handlePosition / this.model.barWidth;
    this.model.value = Math.round(posPercent * this.model.range + this.model.min);
    this.updateVal();
  }
  setHandlePosition() {
    const nearestStepPercent = (this.model.value - this.model.min) / this.model.range;
    this.model.handlePosition = nearestStepPercent * this.model.barWidth;
    if (this.selectors.ttContainer && this.selectors.ttInner) {
      this.selectors.ttContainer.style.left = `${this.model.handlePosition - this.selectors.sliderHandle.getBoundingClientRect().width / 2}px`;
    } else {
      this.selectors.sliderHandle.style.left = `${this.model.handlePosition - this.selectors.sliderHandle.getBoundingClientRect().width / 2}px`;
    }
    this.selectors.sliderFill.style.width = `${this.model.handlePosition}px`;
  }
  updateTooltip() {
    this.model.tooltipInstance.align();
    let ttVal = this.model.value;
    if (this.model.currency) {
      if (!currency[this.model.currency]) {
        throw new Error('Please pass a valid currency code (i.e. en-US');
      }
      ttVal = Number(this.model.value).toLocaleString(this.model.currency, {
        style: 'currency',
        currency: currency[this.model.currency],
        minimumFractionDigits: 2
      });
    }
    this.selectors.ttInner.innerHTML = ttVal;
    this.selectors.sliderHandle.setAttribute('aria-valuetext', `${ttVal}`);
  }
}
/* harmony default export */ var slider = (Slider);
;// CONCATENATED MODULE: ./source/scripts/components/smartfield.js
class Smartfield {
  constructor(params) {
    if (!params.target) {
      throw new Error('Smartfield: No target element passed');
    }
    this.selectors = {
      target: params.target,
      form: params.target.getElementsByClassName('smart-field')[0],
      placeholder: params.target.getElementsByClassName('smart-el-placeholder')[0],
      input: params.target.getElementsByClassName('smart-el-inputs')[0],
      inputs: params.target.getElementsByClassName('smart-el-inputs')[0].children,
      value: params.target.getElementsByClassName('smart-el-value')[0],
      message: ''
    };
    this.model = {
      validation: this.selectors.target.dataset.validation,
      id: this.selectors.target.dataset.validationId
    };
    this.handleFocus();
    this.valuate();
    this.selectors.placeholder.onclick = () => {
      this.activate();
    };
    this.selectors.form.onclick = () => {
      this.activate();
    };
    this.selectors.target.onkeypress = event => {
      if (event.code === 'Enter') {
        this.deactivate();
      }
    };
  }
  activate() {
    // if not active and not disabled, add active class
    if (!this.selectors.form.classList.contains('active') && !this.selectors.target.hasAttribute('disabled')) {
      this.selectors.form.classList.add('active');
    }
  }
  deactivate() {
    // when unfocused, remove active class and handle input values
    this.selectors.form.classList.remove('active');
    this.valuate();
    this.validateRequired();
    if (this.selectors.form.classList.contains('has-value') && this.model.validation) {
      this.validateData();
    }
  }

  // concating input values
  valuate() {
    this.selectors.value.value = '';
    for (let i = 0; i < this.selectors.inputs.length; i += 1) {
      const input = this.selectors.inputs[i].getElementsByTagName('input')[0].value;
      if (input) {
        this.selectors.value.value += ` ${input}`;
      }
    }
    this.selectors.value.value = this.selectors.value.value.trim();

    // if value add has-value class otherwise remove has-value class
    this.selectors.value.value.length ? this.selectors.form.classList.add('has-value') : this.selectors.form.classList.remove('has-value');
  }

  // tabbing into/out of the inputs
  handleFocus() {
    for (let i = 0; i < this.selectors.inputs.length; i += 1) {
      const input = this.selectors.inputs[i].getElementsByTagName('input')[0];
      input.onfocus = () => {
        this.activate();
      };
    }
    this.selectors.input.addEventListener('focusout', () => {
      if (!this.selectors.target.contains(document.activeElement)) {
        this.deactivate();
      }
    });
  }
  validateRequired() {
    let warnings = 0;
    for (let i = 0; i < this.selectors.inputs.length; i += 1) {
      const input = this.selectors.inputs[i].getElementsByTagName('input')[0];
      const alert = input.getAttribute('aria-describedby');
      const message = document.getElementById(alert);
      if (input.hasAttribute('required') && !input.value) {
        // if input is required and has no value entered,
        // trigger warning and show associated alert message
        warnings += 1;
        input.parentElement.classList.add('has-warning');
        if (!this.selectors.form.classList.contains('smart-field-warning')) {
          this.selectors.form.classList.add('smart-field-warning');
        }
        this.selectors.form.classList.remove('smart-field-success');
        if (alert && message) {
          message.classList.remove('hidden');
        }
      } else {
        // if input has no warnings, remove any warning classes and associated alert
        input.parentElement.classList.remove('has-warning');
        if (alert && message) {
          message.classList.add('hidden');
        }
      }
    }

    // if there are any invalid inputs, add warning class
    if (warnings) {
      this.selectors.form.classList.remove('smart-field-success');
      this.selectors.form.classList.add('smart-field-warning');
    } else {
      // otherwise add success class
      this.selectors.form.classList.remove('smart-field-warning');
      this.selectors.form.classList.add('smart-field-success');
    }
  }
  validateData() {
    const regex = RegExp(this.model.validation);
    const val = this.selectors.value.value;
    this.selectors.message = document.getElementById(this.model.id);

    // if data-validation test doesn't pass, trigger warning and show data-validation-message
    if (!regex.test(val)) {
      if (!this.selectors.form.classList.contains('smart-field-warning')) {
        this.selectors.form.classList.add('smart-field-warning');
        this.selectors.form.classList.remove('smart-field-success');
      }
      if (this.selectors.message) {
        this.selectors.message.classList.remove('hidden');
      }
    } else if (regex.test(val) && this.selectors.input.querySelector('.has-warning') && this.selectors.message) {
      this.selectors.message.classList.add('hidden');
    } else {
      // otherwise remove data-validation-message
      this.selectors.form.classList.remove('smart-field-warning');
      this.selectors.form.classList.add('smart-field-success');
      if (this.selectors.message && !this.selectors.message.classList.contains('hidden')) {
        this.selectors.message.classList.add('hidden');
      }
    }
  }
}
/* harmony default export */ var smartfield = (Smartfield);
;// CONCATENATED MODULE: ./source/scripts/models/phone.js
const countrySMS = {
  'es-AR': {
    name: 'Argentina',
    countryCode: 54,
    digitGroups: [2, 4, 4]
  },
  'en-AU': {
    name: 'Australia',
    countryCode: 61,
    digitGroups: [1, 4, 4]
  },
  'en-CA': {
    name: 'Canada',
    countryCode: 1,
    digitGroups: [3, 3, 4]
  },
  'fi-FI': {
    name: 'Finland',
    countryCode: 358,
    digitGroups: [3, 3, 3]
  },
  'en-DE': {
    name: 'Germany',
    countryCode: 49,
    digitGroups: [2, 8]
  },
  'en-HK': {
    name: 'Hong Kong',
    countryCode: 852,
    digitGroups: [4, 4]
  },
  'en-IN': {
    name: 'India',
    countryCode: 91,
    digitGroups: [2, 4, 4]
  },
  'ja-JP': {
    name: 'Japan',
    countryCode: 81,
    digitGroups: [2, 4, 4]
  },
  'nl-NL': {
    name: 'Netherlands',
    countryCode: 31,
    digitGroups: [2, 3, 2, 2]
  },
  'en-SG': {
    name: 'Singapore',
    countryCode: 65,
    digitGroups: [4, 4]
  },
  'es-ES': {
    name: 'Spain',
    countryCode: 34,
    digitGroups: [2, 3, 4]
  },
  'sv-SE': {
    name: 'Sweden',
    countryCode: 46,
    digitGroups: [1, 2, 2, 2, 2]
  },
  'en-GB': {
    name: 'United Kingdom',
    countryCode: 44,
    digitGroups: [2, 4, 4]
  },
  'en-US': {
    name: 'United States',
    countryCode: 1,
    digitGroups: [3, 3, 4]
  }
};
/* harmony default export */ var phone = (countrySMS);
;// CONCATENATED MODULE: ./source/scripts/components/smsfield.js


class Smsfield {
  constructor(params) {
    if (!params.target) {
      throw new Error('Smsfield: No target element passed');
    }
    this.selectors = {
      target: params.target,
      flag: params.target.getElementsByClassName('select-icon')[0],
      select: params.target.getElementsByTagName('select')[0],
      options: params.target.querySelectorAll('option'),
      field: params.target.getElementsByClassName('sms-field')[0],
      input: params.target.getElementsByTagName('input')[0],
      alert: '',
      message: ''
    };
    this.model = {
      defaultCountry: params.target.dataset.defaultCountry || '',
      idx: 0,
      digits: '',
      country: '',
      codeCode: '',
      success: params.target.dataset.success,
      validation: params.target.dataset.validation,
      validationId: params.target.dataset.validationId
    };
    this.locales = phone;

    // make sure input type is 'tel'
    this.selectors.input.type = 'tel';

    // generate list of options
    this.setOptions();

    // set default
    this.selectors.defaultValue = this.selectors.input.value;
    this.update();
    this.selectors.input.value = this.formatNumber(`${this.model.code} ${this.selectors.defaultValue}`);
    this.getAlerts();

    // update flag and inputs when change country
    this.selectors.select.onchange = () => {
      this.update();
    };
    this.selectors.input.onkeydown = e => {
      const onPreventDefault = val => {
        e.preventDefault();
        e.stopPropagation();
        if (val) {
          this.selectors.input.value = val;
        }
      };

      // Make sure country code is there
      if (!this.selectors.input.value.match(new RegExp(`^${this.model.code} `))) {
        return onPreventDefault(`${this.model.code} `);
      }

      // Prevent deleting or selecting input country code
      if (e.key.match(/delete|backspace|arrow/i) && this.selectors.input.value === `${this.model.code} `) {
        return onPreventDefault();
      }

      // Backspace and last char is a space
      if (e.key.match(/backspace|delete/i) && this.selectors.input.value.match(/\s$/)) {
        return onPreventDefault(this.selectors.input.value.replace(/\s$/, '').replace(/\d$/, ''));
      }

      // Replace commonly used special characters in numbers w/ space
      if (e.key.match(/-|\.|\(|\)/)) {
        return onPreventDefault(`${this.selectors.input.value} `);
      }

      // Check if e.key is a-z, 0-9 or a special character and
      // prevent if the single-character e.key isn't a digit or space
      if (e.key.match(/^.$/) && e.key.match(/[^\d|\s]/) && !e.metaKey && !e.ctrlKey) {
        return onPreventDefault();
      }
      this.selectors.input.value = this.formatNumber(this.selectors.input.value);
    };
    this.selectors.input.onblur = () => {
      this.validateRequired();
      if (!this.selectors.target.classList.contains('has-warning')) {
        this.validateData();
      }
    };
  }
  setOptions() {
    // set default country options
    if (!this.selectors.options.length) {
      Object.keys(this.locales).forEach(key => {
        const countryName = this.locales[key].name;
        this.selectors.select.innerHTML += `<option value="${key}">${countryName}</option>`;
      });
      this.selectors.options = this.selectors.select.querySelectorAll('option');
    }
    if (this.model.defaultCountry) {
      this.selectors.select.querySelector(`option[value=${this.model.defaultCountry}]`).selected = true;
    }
  }
  update() {
    // remove warnings
    this.selectors.target.classList.remove('has-warning');
    if (this.selectors.alert && !this.selectors.alert.classList.contains('hidden')) {
      this.selectors.alert.classList.add('hidden');
    }

    // set selected values
    this.model.idx = this.selectors.select.selectedIndex;
    this.model.countryCode = this.selectors.options[this.model.idx].value;
    this.model.code = this.locales[this.model.countryCode].countryCode;
    this.model.digits = this.locales[this.model.countryCode].digitGroups;

    // set input max length as total number of digits and spaces
    this.selectors.input.maxLength = this.getDigitMax() + this.model.digits.length;
    this.updateFlag();
    this.updateInput();
  }
  updateFlag() {
    const flag = this.model.countryCode.replace(/(.*-)(.*)/, '$2').toLowerCase();
    const imgSrc = `${assets.assetCDN}/img/flags/dls-flag-${flag}.svg`;
    this.selectors.flag.innerHTML = `<img class="dls-flag" src=${imgSrc} alt=${flag}>`;
  }
  updateInput() {
    this.selectors.input.placeholder = this.model.code;
    this.selectors.input.value = `${this.model.code} `;
  }
  getPattern() {
    const createCaptureGroup = int => `(\\d{${String(int)}})`;
    //  Reg Exp to match digit groups, all groups optional except country code.
    //  Example of expression generated for en-US:
    //  /(\d{1})(\d{3})?(\d{3})?(\d{4})?/
    let pattern = createCaptureGroup(String(this.model.code).split('').length);
    this.model.digits.forEach(group => {
      pattern += `${createCaptureGroup(group)}?`;
    });
    return new RegExp(pattern);
  }
  getDigitRef() {
    //  Example of backreference generated for en-US:
    //  $1 $2 $3 $4
    let ref = '$1';
    for (let i = 1; i <= this.model.digits.length; i += 1) {
      ref += ` $${i + 1}`;
    }
    return ref;
  }
  getDigitMax() {
    let count = String(this.model.code).split('').length;
    for (let i = 0; i < this.model.digits.length; i += 1) {
      count += this.model.digits[i];
    }
    return count;
  }
  formatNumber(val) {
    const value = String(val);
    return value.replace(/\D/g, '') // remove all non-digits
    .replace(this.getPattern(), this.getDigitRef()); // format with regex
  }

  getAlerts() {
    this.selectors.message = this.selectors.input.getAttribute('aria-describedby') ? this.selectors.input.getAttribute('aria-describedby').split(' ')[0] : '';
    if (this.selectors.message) {
      const messageElement = document.getElementById(this.selectors.message);
      const alerts = messageElement ? messageElement.querySelectorAll('[role="alert"]') : '';
      if (alerts.length > 1 && this.model.validationId) {
        alerts.forEach(alert => {
          if (alert.id !== this.model.validationId) {
            this.selectors.alert = alert;
          }
        });
      } else {
        this.selectors.alert = messageElement;
      }
    }
  }
  validateRequired() {
    if (this.selectors.input.required && this.selectors.input.value.length < this.selectors.input.maxLength) {
      this.selectors.target.classList.add('has-warning');
      if (this.selectors.alert) {
        this.selectors.alert.classList.remove('hidden');
      }
    } else {
      this.selectors.target.classList.remove('has-warning');
      if (this.selectors.alert) {
        this.selectors.alert.classList.add('hidden');
      }
    }
  }
  validateData() {
    const regex = RegExp(this.model.validation);
    const val = this.selectors.input.value;
    this.selectors.validationAlert = document.querySelector(`#${this.model.validationId}`);

    // if data-validation test doesn't pass, trigger warning and show data-validation-message
    if (!regex.test(val)) {
      this.selectors.target.classList.add('has-warning');
      this.selectors.input.classList.remove('form-control-success');
      if (this.selectors.validationAlert) {
        this.selectors.validationAlert.classList.remove('hidden');
      }
    } else {
      // otherwise remove data-validation-message
      this.selectors.target.classList.remove('has-warning');
      if (this.selectors.validationAlert) {
        this.selectors.validationAlert.classList.add('hidden');
      }
      if (this.model.success) {
        this.selectors.input.classList.add('form-control-success');
      }
    }
  }
}
/* harmony default export */ var smsfield = (Smsfield);
;// CONCATENATED MODULE: ./source/scripts/components/stepper.js
class Stepper {
  constructor(params) {
    if (!params.target) {
      throw new Error('Stepper: No target element passed');
    }
    this.selectors = {
      target: params.target,
      value: params.target.getElementsByClassName('stepper-value')[0],
      add: params.target.getElementsByClassName('stepper-btn')[1],
      subtract: params.target.getElementsByClassName('stepper-btn')[0]
    };
    this.model = {
      disabled: this.selectors.add.hasAttribute('disabled') && this.selectors.add.hasAttribute('disabled'),
      min: this.initVal(this.selectors.value.min, 0),
      max: this.initVal(this.selectors.value.max, 10),
      step: this.initVal(this.selectors.value.step, 1),
      value: this.initVal(this.selectors.value.value, 1)
    };
    this.setAccessibleLabels();
    this.setVal(this.model.value);
    this.selectors.add.onclick = () => {
      this.updateVal(this.model.step);
    };
    this.selectors.subtract.onclick = () => {
      this.updateVal(-this.model.step);
    };
    this.selectors.value.onblur = () => {
      this.setVal(this.initVal(this.selectors.value.value, 1));
    };
  }
  initVal(val, def) {
    let num = def;
    if (val) {
      if (Number(val)) {
        num = Number(val);
      } else if (Number(val) === 0) {
        num = 0;
      }
    }
    return num;
  }
  setAccessibleLabels() {
    const label = this.selectors.target.previousElementSibling;
    if (label) {
      this.selectors.add.setAttribute('aria-label', `Increase ${label.innerHTML}`);
      this.selectors.subtract.setAttribute('aria-label', `Decrease ${label.innerHTML}`);
    }
  }
  setVal(val) {
    this.selectors.value.value = Math.max(this.model.min, Math.min(val, this.model.max));
    this.updateVal();
  }
  updateVal() {
    let step = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    this.model.value = Number(this.selectors.value.value);
    this.model.value = Math.max(this.model.min, Math.min(this.model.value + step, this.model.max));
    this.selectors.value.value = this.model.value;
    if (!this.model.disabled) {
      if (this.model.value > this.model.min) {
        this.selectors.subtract.removeAttribute('disabled');
      } else {
        this.selectors.subtract.setAttribute('disabled', 'true');
      }
      if (this.model.value < this.model.max) {
        this.selectors.add.removeAttribute('disabled');
      } else {
        this.selectors.add.setAttribute('disabled', 'true');
      }
    }
  }
}
/* harmony default export */ var stepper = (Stepper);
;// CONCATENATED MODULE: ./source/scripts/components/switch.js
class Switch {
  constructor(params) {
    if (!params.target) {
      throw new Error('Switch: No target element passed');
    }
    this.selectors = {
      target: params.target,
      checked: params.target.getAttribute('aria-checked') || 'false'
    };
    this.selectors.target.onclick = () => {
      this.toggle();
    };
  }
  toggle() {
    if (this.selectors.checked === 'true') {
      this.selectors.target.setAttribute('aria-checked', 'false');
      this.selectors.checked = 'false';
    } else {
      this.selectors.target.setAttribute('aria-checked', 'true');
      this.selectors.checked = 'true';
    }
  }
}
/* harmony default export */ var components_switch = (Switch);
;// CONCATENATED MODULE: ./source/scripts/components/tabs.js
class Tabs {
  constructor(params) {
    if (!params.target) {
      throw new Error('Tabs: No target element passed');
    }
    this.selectors = {
      target: params.target,
      menu: params.target.getElementsByClassName('tab-menu')[0],
      links: [].slice.call(params.target.getElementsByClassName('tab-link')),
      panels: [].slice.call(params.target.querySelectorAll('[role="tabpanel"]'))
    };
    if (this.selectors.menu.querySelector('[aria-selected="true"]')) {
      this.fillIcon(this.selectors.menu.querySelector('[aria-selected="true"]'));
    }
    this.selectors.links.forEach((link, index) => {
      if (link.getAttribute('aria-selected') === 'true') {
        this.scroll(link);
      }
      link.onclick = () => {
        this.switchToTab(link);
      };
      link.onkeydown = event => {
        const targetIndex = this.getTargetIndex(index, event);
        if (targetIndex === undefined) {
          return;
        }

        // only preventDefault if we're capturing the key press
        event.preventDefault();
        const targetLink = this.selectors.links[targetIndex];
        targetLink.focus();

        // by default, follows the manual activation type
        if (this.selectors.target.dataset.activationType === 'automatic') {
          this.switchToTab(targetLink);
        }
      };
    });
  }

  // Gets the index of the tab that should be focused based on the key that was pressed
  getTargetIndex(currentIndex, event) {
    const numLinks = this.selectors.links.length;
    let targetIndex = currentIndex;
    switch (event.key) {
      case 'ArrowLeft':
      case 'Left':
        targetIndex -= 1;
        break;
      case 'ArrowRight':
      case 'Right':
        targetIndex += 1;
        break;
      case 'Home':
        // move to first tab
        targetIndex = 0;
        break;
      case 'End':
        // move to last tab
        targetIndex = numLinks - 1;
        break;
      default:
        return;
    }

    // If the targetIndex goes negative, it should go to the last tab
    // This happens if you press "Left" on the first item
    if (targetIndex < 0) {
      targetIndex += numLinks;
    }

    // wraps the targetIndex within the range of the links
    targetIndex %= numLinks;
    return targetIndex;
  }
  switchToTab(link) {
    // Required for Safari, clicking a button drops the focus
    // https://bugs.webkit.org/show_bug.cgi?id=229895
    link.focus();
    this.scroll(link);
    this.reset();
    link.setAttribute('aria-selected', 'true');
    link.removeAttribute('tabindex');
    this.fillIcon(link);
    this.selectors.target.querySelector(`[aria-labelledby="${link.id}"]`).classList.remove('hidden');
  }
  reset() {
    this.selectors.links.forEach(link => {
      link.setAttribute('aria-selected', 'false');
      link.setAttribute('tabindex', '-1');
      this.unfillIcon(link);
    });
    this.selectors.panels.forEach(panel => {
      panel.classList.add('hidden');
    });
  }
  scroll(el) {
    this.selectors.menu.scrollLeft = el.offsetLeft - (this.selectors.menu.clientWidth - el.scrollWidth) / 2;
  }
  fillIcon(link) {
    const icon = link.querySelector('.icon');
    if (icon) {
      const iconClass = icon.className.match(/(?=dls-icon)([a-z-]+)/)[0];
      if (!iconClass.endsWith('-filled')) {
        icon.classList.remove(iconClass);
        icon.classList.add(`${iconClass}-filled`);
      }
    }
  }
  unfillIcon(link) {
    const icon = link.querySelector('.icon');
    if (icon) {
      const iconClassRaw = icon.className.match(/(?=dls-icon)([a-z-]+)/)[0];
      if (iconClassRaw.endsWith('-filled')) {
        icon.classList.remove(iconClassRaw);
        icon.classList.add(iconClassRaw.slice(0, -7));
      }
    }
  }
}
/* harmony default export */ var tabs = (Tabs);
;// CONCATENATED MODULE: ./source/scripts/components/video.js
class Video {
  constructor(params) {
    if (!params.target) {
      throw new Error('Video: No target element passed');
    }
    this.selectors = {
      target: params.target,
      video: params.target.querySelector('video'),
      overlay: params.target.getElementsByClassName('video-overlay')[0],
      circle: params.target.getElementsByClassName('dls-icon-play-circle')[0],
      captionText: params.target.getElementsByClassName('video-caption')[0],
      controls: params.target.getElementsByClassName('video-controls')[0],
      playpause: params.target.getElementsByClassName('dls-icon-play')[0] || params.target.getElementsByClassName('dls-icon-pause')[0],
      progress: params.target.querySelector('progress'),
      volume: params.target.getElementsByClassName('video-volume')[0],
      slider: params.target.querySelector('input'),
      caption: params.target.getElementsByClassName('dls-icon-captions-off')[0] || params.target.getElementsByClassName('dls-icon-captions-on')[0],
      expand: params.target.getElementsByClassName('dls-icon-expand')[0]
    };
    this.model = {
      time: params.target.querySelector('[data-time]'),
      duration: params.target.querySelector('[data-duration]'),
      caption: this.selectors.video.textTracks.length,
      interval: params.target.dataset.interval || 5
    };
    if (this.model.duration) {
      this.model.duration.innerHTML = this.formatTime(this.selectors.video.duration);
    }

    // caption on by default
    this.initCaption();

    // if no vtt file exists for captions, remove caption elements
    if (!this.model.caption && this.selectors.caption) {
      this.selectors.caption.parentNode.removeChild(this.selectors.caption);
      if (this.selectors.captionText) {
        this.selectors.captionText.parentNode.removeChild(this.selectors.captionText);
      }
    }
    if (this.selectors.circle) {
      this.selectors.circle.onclick = () => {
        this.selectors.video.play();
        this.selectors.overlay.classList.add('hidden');
        if (this.selectors.controls) {
          this.selectors.playpause.classList.add('dls-icon-pause');
          this.selectors.playpause.classList.remove('dls-icon-play');
        }
        if (this.model.caption && this.selectors.caption) {
          this.setupCaption();
        }
      };
    }
    if (this.selectors.controls) {
      this.showControls();
      // hovering over video area shows controls and fades out after 4 seconds
      this.selectors.target.onmouseover = () => {
        this.showControls();
      };
      this.selectors.controls.onfocus = () => {
        this.selectors.controls.style.opacity = '0.8';
      };
      this.selectors.controls.onblur = () => {
        this.selectors.controls.style = null;
      };
      // toggle buttons
      this.selectors.playpause.onclick = () => {
        this.togglePlay();
      };
      if (this.selectors.volume) {
        this.selectors.volume.querySelector('button').onclick = () => {
          this.toggleVolume();
        };
      }
      if (this.selectors.slider) {
        this.selectors.slider.value = this.currentVolume() * 10;
        this.selectors.slider.onchange = () => {
          this.selectors.video.volume = parseFloat(this.selectors.slider.value / 10);
        };
      }
      this.selectors.expand.onclick = () => {
        this.toggleExpand();
      };
      this.selectors.video.ontimeupdate = e => {
        this.updateTime(e.target.currentTime);
        this.updateProgress(e.target);
      };
      this.selectors.progress.onclick = e => {
        const pos = this.getPosition(e);
        this.changeTime(pos);
      };
      this.selectors.video.onvolumechange = () => {
        if (this.currentVolume() === 0 || this.selectors.video.muted) {
          this.selectors.volume.querySelector('button').classList.add('dls-icon-sound-off');
          this.selectors.volume.querySelector('button').classList.remove('dls-icon-sound-on');
        } else {
          this.selectors.volume.querySelector('button').classList.add('dls-icon-sound-on');
          this.selectors.volume.querySelector('button').classList.remove('dls-icon-sound-off');
        }
      };
    }
    this.selectors.target.onkeydown = e => {
      this.showControls();
      if (e.key === 'ArrowRight') {
        this.forwardV();
      }
      if (e.key === 'ArrowLeft') {
        this.rewind();
      }
      if (this.selectors.volume) {
        if (e.key === 'ArrowUp') {
          e.preventDefault();
          e.stopPropagation();
          this.increaseVolume();
        }
        if (e.key === 'ArrowDown') {
          e.preventDefault();
          e.stopPropagation();
          this.decreaseVolume();
        }
      }
    };
    this.selectors.video.onended = () => {
      if (this.selectors.captionText) {
        this.selectors.captionText.innerHTML = '';
        this.selectors.captionText.classList.add('hidden');
      }
      if (this.selectors.controls) {
        this.selectors.playpause.classList.add('dls-icon-play');
        this.selectors.playpause.classList.remove('dls-icon-pause');
      }
    };
  }
  showControls() {
    this.selectors.controls.classList.add('visible');
    setTimeout(() => {
      this.selectors.controls.classList.remove('visible');
    }, 4000);
  }
  togglePlay() {
    if (this.selectors.video.paused) {
      this.selectors.video.play();
      this.selectors.playpause.classList.add('dls-icon-pause');
      this.selectors.playpause.classList.remove('dls-icon-play');
      this.selectors.overlay.classList.add('hidden');
      this.setupCaption();
    } else {
      this.selectors.video.pause();
      this.selectors.overlay.classList.remove('hidden');
      this.selectors.playpause.classList.add('dls-icon-play');
      this.selectors.playpause.classList.remove('dls-icon-pause');
    }
  }
  toggleVolume() {
    if (this.selectors.video.muted) {
      this.selectors.video.muted = false;
      if (this.currentVolume() === 0) {
        this.increaseVolume();
      }
    } else {
      this.selectors.video.muted = true;
    }
  }
  toggleCaption() {
    if (this.selectors.caption.classList.contains('dls-icon-captions-off')) {
      this.selectors.caption.classList.add('dls-icon-captions-on');
      this.selectors.caption.classList.remove('dls-icon-captions-off');
      this.selectors.captionText.classList.remove('hidden');
    } else {
      this.selectors.caption.classList.add('dls-icon-captions-off');
      this.selectors.caption.classList.remove('dls-icon-captions-on');
      this.selectors.captionText.classList.add('hidden');
    }
  }
  toggleExpand() {
    if (this.selectors.expand.classList.contains('dls-icon-expand')) {
      this.selectors.expand.classList.add('dls-icon-collapse');
      this.selectors.expand.classList.remove('dls-icon-expand');
      this.openFullScreen(this.selectors.target);
    } else {
      this.selectors.expand.classList.add('dls-icon-expand');
      this.selectors.expand.classList.remove('dls-icon-collapse');
      this.closeFullScreen();
    }
  }
  currentVolume() {
    return Math.floor(this.selectors.video.volume * 10) / 10;
  }
  increaseVolume() {
    if (this.currentVolume() < 1) {
      this.selectors.video.volume += 0.1;
      this.selectors.slider.value = this.selectors.video.volume * 10;
    }
  }
  decreaseVolume() {
    if (this.currentVolume() > 0) {
      this.selectors.video.volume -= 0.1;
      this.selectors.slider.value = this.selectors.video.volume * 10;
    }
  }
  openFullScreen(el) {
    const requestFullScreen = el.requestFullscreen || el.msRequestFullscreen || el.mozRequestFullScreen || el.webkitRequestFullscreen;
    requestFullScreen.call(el);
  }
  closeFullScreen() {
    const exitFullScreen = document.exitFullscreen || document.msExitFullscreen || document.mozCancelFullScreen || document.webkitExitFullscreen;
    exitFullScreen.call(document);
  }
  formatTime(time) {
    if (isNaN(time)) {
      return '';
    }
    const minutes = Math.floor(time / 60);
    const seconds = Math.floor(time % 60);
    let minuteValue;
    let secondValue;
    if (minutes < 10) {
      minuteValue = `0${minutes}`;
    } else {
      minuteValue = minutes;
    }
    if (seconds < 10) {
      secondValue = `0${seconds}`;
    } else {
      secondValue = seconds;
    }
    return `${minuteValue}:${secondValue}`;
  }
  updateTime(time) {
    this.model.time.innerHTML = this.formatTime(time);
  }
  updateProgress(video) {
    const time = video.currentTime ? video.currentTime : 0;
    const percentage = Math.round(100 / video.duration * time);
    this.selectors.progress.value = percentage;
    this.selectors.progress.innerHTML = `${percentage} %`;
  }
  changeTime(time) {
    this.selectors.video.currentTime = time * this.selectors.video.duration;
  }
  forwardV() {
    const time = this.selectors.video.currentTime + this.model.interval;
    this.selectors.video.currentTime = time > this.selectors.video.duration ? this.selectors.video.duration : time;
  }
  rewind() {
    const time = this.selectors.video.currentTime - this.model.interval;
    this.selectors.video.currentTime = time < 0 ? 0 : time;
  }
  getPosition(e) {
    return (e.pageX - (e.target.offsetLeft + e.target.offsetParent.offsetLeft + e.target.offsetParent.offsetParent.offsetLeft)) / e.target.offsetWidth;
  }
  initCaption() {
    if (this.model.caption && this.selectors.caption) {
      this.selectors.caption.classList.remove('dls-icon-captions-off');
      this.selectors.caption.classList.add('dls-icon-captions-on');
      this.selectors.captionText.classList.add('hidden');
      this.selectors.caption.onclick = () => {
        this.toggleCaption();
      };
    }
  }
  setupCaption() {
    this.selectors.captionText.classList.remove('hidden');
    const tracks = this.selectors.video.textTracks;
    const captionText = this.selectors.captionText;
    captionText.innerHTML = '';
    this.setupTracks(tracks, captionText);
  }
  setupTracks(tracks, captionText) {
    let track = {};
    for (let i = 0; i < tracks.length; i += 1) {
      track = this.selectors.video.textTracks[i];
      track.mode = 'hidden';
      // ignoring coverage for `updateCaption
      // which is already explicitly tested in 'Sets up caption tracks' test
      /* istanbul ignore next line */
      track.oncuechange = () => {
        // eslint-disable-line no-loop-func -- legacy
        this.updateCaption(track, captionText);
      };
    }
  }
  updateCaption(track, captionText) {
    if (track.activeCues[0] && track.activeCues[0].text !== '') {
      captionText.innerHTML = `<span>${track.activeCues[0].text}</span>`;
    }
  }
}
/* harmony default export */ var video = (Video);
;// CONCATENATED MODULE: ./source/scripts/app.js




























class DLSApp {
  create(type, params) {
    if (!this.components[type]) {
      throw new Error(`DLS Create: Component of type ${type} does not exist!`);
    }
    if (!params || !params.target) {
      throw new Error('DLS Create: Please provide a valid target! - {target: elemSelector, config: (optional)}');
    }
    return new this.components[type](params);
  }
  render() {
    let component;
    Object.keys(this.components).forEach(type => {
      component = this.components[type];
      [].slice.call(document.querySelectorAll(`[data-toggle='${type}']`)).forEach(el => {
        // eslint-disable-next-line no-new, new-cap -- legacy
        new component({
          target: el
        });
      });
    });
  }
}
DLSApp.prototype.components = {
  accordion: accordion,
  carousel: carousel,
  cardfield: cardfield,
  checkboxgroup: checkboxgroup,
  copyfield: copy,
  currencyfield: currencyfield,
  datatable: datatable,
  dismissible: dismissible,
  filter: filter,
  inputfield: input,
  inputgroup: inputgroup,
  multiselect: multiselect,
  nav: nav,
  overflowmenu: overflowmenu,
  pagination: pagination,
  phonefield: phonefield,
  search: search,
  searchfield: searchfield,
  select: components_select,
  slider: slider,
  smartfield: smartfield,
  smsfield: smsfield,
  stepper: stepper,
  switch: components_switch,
  tabs: tabs,
  tooltip: tooltip,
  video: video
};
;// CONCATENATED MODULE: ./source/scripts/main.js

window.DLS = new DLSApp();
window.DLS.render();

/***/ }),

/***/ 460:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

const { version: staticAssetsVersion } = __webpack_require__(383);
// eslint-disable-next-line import/no-extraneous-dependencies -- generated file doesn't need to be a dep.
const { fontsCDN } = __webpack_require__(412);

const assetCDN = `https://www.aexp-static.com/cdaas/one/statics/@americanexpress/static-assets/${staticAssetsVersion}/package/dist`;
const fontCDN = `${fontsCDN}`;

module.exports = { assetCDN, fontCDN };


/***/ }),

/***/ 157:
/***/ (function(module) {

"use strict";
module.exports = /*#__PURE__*/JSON.parse('{"name":"@americanexpress/dls-fonts","version":"1.0.0","description":"American Express font files for digital distribution","main":"index.js","scripts":{"lint":"eslint .","test":"jest"},"jest":{"preset":"amex-jest-preset","snapshotSerializers":[]},"devDependencies":{"amex-jest-preset":"^7.0.0","babel-preset-amex":"^4.0.1","eslint-config-amex":"^16.0.0","jest":"^29.6.2"}}');

/***/ }),

/***/ 383:
/***/ (function(module) {

"use strict";
module.exports = /*#__PURE__*/JSON.parse('{"name":"@americanexpress/static-assets","version":"2.31.4","description":"American Express Static Assets","scripts":{"build":"npm run clean && npm run svg-to-png && npm run copy && npm run iconfont && npm run zip && svgo -r -f dist/img && npm run icon-style && npm run svg-to-pdf && npm run bimi","bimi":"cp -a src/bimi dist/bimi","clean":"rimraf dist","iconfont":"mkdir -p dist/iconfont && webfont src/icons/**/*.svg --config ./webfont.config.js","icon-style":"sass src/iconfont.scss dist/iconfont/iconfont.css --no-source-map","svg-to-png":"node tasks/convert-to-png.js","svg-to-pdf":"node tasks/convert-to-pdf.js","zip":"npm run zip-icons && npm run zip-glyphs","zip-icons":"zip dist/img/icons.zip -r dist/img/icons/*.svg -x \\"dist/img/icons/status/*\\"","zip-glyphs":"zip dist/img/glyphs.zip -r dist/img/glyphs/*.svg","copy":"npm run copy-icons && npm run copy-state-icons && npm run copy-glyphs && npm run copy-fonts && npm run copy-img","copy-fonts":"mkdir -p dist/fonts && cp -n -f src/fonts/* dist/fonts","copy-icons":"mkdir -p dist/img/icons && cp -f src/icons/**/*-dls-icon-* dist/img/icons && rename dist/img/icons/* \'{{regex||(dls).*||g||}}\' -n -f","copy-state-icons":"mkdir -p dist/img/icons/status && cp -f src/state-icons/dls-icon-* dist/img/icons/status","copy-img":"mkdir -p dist/img && cp -r src/img dist","copy-glyphs":"mkdir -p dist/img/glyphs && cp -f src/icons/**/*-dls-glyph-* dist/img/glyphs && rename dist/img/glyphs/* \'{{regex||(dls).*||g||}}\' -n -f","test":"npm run build && npm run lint","lint":"eslint tasks/**/*.js --fix","githook:pre-commit":"npm run svg-to-png && npm run lint","githook:commit-msg":"commitlint --edit $GIT_PARAMS","postpack":"generate-changelog -p DLS -r axp-static-assets --without-unknowns"},"repository":{"type":"git","url":"https://github.aexp.com/amex-eng/axp-static-assets"},"keywords":["DLS","static","assets","images","logos"],"author":"AMEX","license":"SEE LICENSE IN LICENSE","devDependencies":{"@americanexpress/changelog-generator":"^3.0.0","@commitlint/cli":"^18.4.4","@commitlint/config-conventional":"^18.4.4","convert-svg-to-png":"^0.6.4","eslint":"^8.56.0","eslint-config-amex":"^16.0.0","githook-scripts":"^1.1.0","pdfkit":"^0.14.0","rename-cli":"^6.2.1","rimraf":"^5.0.5","sass":"^1.69.7","svg-to-pdfkit":"^0.1.8","svgo":"^3.2.0","webfont":"^11.2.26"}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			if (cachedModule.error !== undefined) throw cachedModule.error;
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		try {
/******/ 			var execOptions = { id: moduleId, module: module, factory: __webpack_modules__[moduleId], require: __webpack_require__ };
/******/ 			__webpack_require__.i.forEach(function(handler) { handler(execOptions); });
/******/ 			module = execOptions.module;
/******/ 			execOptions.factory.call(module.exports, module, module.exports, execOptions.require);
/******/ 		} catch(e) {
/******/ 			module.error = e;
/******/ 			throw e;
/******/ 		}
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = __webpack_module_cache__;
/******/ 	
/******/ 	// expose the module execution interceptor
/******/ 	__webpack_require__.i = [];
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/get javascript update chunk filename */
/******/ 	!function() {
/******/ 		// This function allow to reference all chunks
/******/ 		__webpack_require__.hu = function(chunkId) {
/******/ 			// return url for filenames based on template
/******/ 			return "" + chunkId + "." + __webpack_require__.h() + ".hot-update.js";
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/get update manifest filename */
/******/ 	!function() {
/******/ 		__webpack_require__.hmrF = function() { return "dls_js." + __webpack_require__.h() + ".hot-update.json"; };
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/getFullHash */
/******/ 	!function() {
/******/ 		__webpack_require__.h = function() { return "5e929991f512ceca3769"; }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	!function() {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/load script */
/******/ 	!function() {
/******/ 		var inProgress = {};
/******/ 		var dataWebpackPrefix = "@americanexpress/dls:";
/******/ 		// loadScript function to load a script via script tag
/******/ 		__webpack_require__.l = function(url, done, key, chunkId) {
/******/ 			if(inProgress[url]) { inProgress[url].push(done); return; }
/******/ 			var script, needAttach;
/******/ 			if(key !== undefined) {
/******/ 				var scripts = document.getElementsByTagName("script");
/******/ 				for(var i = 0; i < scripts.length; i++) {
/******/ 					var s = scripts[i];
/******/ 					if(s.getAttribute("src") == url || s.getAttribute("data-webpack") == dataWebpackPrefix + key) { script = s; break; }
/******/ 				}
/******/ 			}
/******/ 			if(!script) {
/******/ 				needAttach = true;
/******/ 				script = document.createElement('script');
/******/ 		
/******/ 				script.charset = 'utf-8';
/******/ 				script.timeout = 120;
/******/ 				if (__webpack_require__.nc) {
/******/ 					script.setAttribute("nonce", __webpack_require__.nc);
/******/ 				}
/******/ 				script.setAttribute("data-webpack", dataWebpackPrefix + key);
/******/ 		
/******/ 				script.src = url;
/******/ 			}
/******/ 			inProgress[url] = [done];
/******/ 			var onScriptComplete = function(prev, event) {
/******/ 				// avoid mem leaks in IE.
/******/ 				script.onerror = script.onload = null;
/******/ 				clearTimeout(timeout);
/******/ 				var doneFns = inProgress[url];
/******/ 				delete inProgress[url];
/******/ 				script.parentNode && script.parentNode.removeChild(script);
/******/ 				doneFns && doneFns.forEach(function(fn) { return fn(event); });
/******/ 				if(prev) return prev(event);
/******/ 			}
/******/ 			var timeout = setTimeout(onScriptComplete.bind(null, undefined, { type: 'timeout', target: script }), 120000);
/******/ 			script.onerror = onScriptComplete.bind(null, script.onerror);
/******/ 			script.onload = onScriptComplete.bind(null, script.onload);
/******/ 			needAttach && document.head.appendChild(script);
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hot module replacement */
/******/ 	!function() {
/******/ 		var currentModuleData = {};
/******/ 		var installedModules = __webpack_require__.c;
/******/ 		
/******/ 		// module and require creation
/******/ 		var currentChildModule;
/******/ 		var currentParents = [];
/******/ 		
/******/ 		// status
/******/ 		var registeredStatusHandlers = [];
/******/ 		var currentStatus = "idle";
/******/ 		
/******/ 		// while downloading
/******/ 		var blockingPromises = 0;
/******/ 		var blockingPromisesWaiting = [];
/******/ 		
/******/ 		// The update info
/******/ 		var currentUpdateApplyHandlers;
/******/ 		var queuedInvalidatedModules;
/******/ 		
/******/ 		__webpack_require__.hmrD = currentModuleData;
/******/ 		
/******/ 		__webpack_require__.i.push(function (options) {
/******/ 			var module = options.module;
/******/ 			var require = createRequire(options.require, options.id);
/******/ 			module.hot = createModuleHotObject(options.id, module);
/******/ 			module.parents = currentParents;
/******/ 			module.children = [];
/******/ 			currentParents = [];
/******/ 			options.require = require;
/******/ 		});
/******/ 		
/******/ 		__webpack_require__.hmrC = {};
/******/ 		__webpack_require__.hmrI = {};
/******/ 		
/******/ 		function createRequire(require, moduleId) {
/******/ 			var me = installedModules[moduleId];
/******/ 			if (!me) return require;
/******/ 			var fn = function (request) {
/******/ 				if (me.hot.active) {
/******/ 					if (installedModules[request]) {
/******/ 						var parents = installedModules[request].parents;
/******/ 						if (parents.indexOf(moduleId) === -1) {
/******/ 							parents.push(moduleId);
/******/ 						}
/******/ 					} else {
/******/ 						currentParents = [moduleId];
/******/ 						currentChildModule = request;
/******/ 					}
/******/ 					if (me.children.indexOf(request) === -1) {
/******/ 						me.children.push(request);
/******/ 					}
/******/ 				} else {
/******/ 					console.warn(
/******/ 						"[HMR] unexpected require(" +
/******/ 							request +
/******/ 							") from disposed module " +
/******/ 							moduleId
/******/ 					);
/******/ 					currentParents = [];
/******/ 				}
/******/ 				return require(request);
/******/ 			};
/******/ 			var createPropertyDescriptor = function (name) {
/******/ 				return {
/******/ 					configurable: true,
/******/ 					enumerable: true,
/******/ 					get: function () {
/******/ 						return require[name];
/******/ 					},
/******/ 					set: function (value) {
/******/ 						require[name] = value;
/******/ 					}
/******/ 				};
/******/ 			};
/******/ 			for (var name in require) {
/******/ 				if (Object.prototype.hasOwnProperty.call(require, name) && name !== "e") {
/******/ 					Object.defineProperty(fn, name, createPropertyDescriptor(name));
/******/ 				}
/******/ 			}
/******/ 			fn.e = function (chunkId, fetchPriority) {
/******/ 				return trackBlockingPromise(require.e(chunkId, fetchPriority));
/******/ 			};
/******/ 			return fn;
/******/ 		}
/******/ 		
/******/ 		function createModuleHotObject(moduleId, me) {
/******/ 			var _main = currentChildModule !== moduleId;
/******/ 			var hot = {
/******/ 				// private stuff
/******/ 				_acceptedDependencies: {},
/******/ 				_acceptedErrorHandlers: {},
/******/ 				_declinedDependencies: {},
/******/ 				_selfAccepted: false,
/******/ 				_selfDeclined: false,
/******/ 				_selfInvalidated: false,
/******/ 				_disposeHandlers: [],
/******/ 				_main: _main,
/******/ 				_requireSelf: function () {
/******/ 					currentParents = me.parents.slice();
/******/ 					currentChildModule = _main ? undefined : moduleId;
/******/ 					__webpack_require__(moduleId);
/******/ 				},
/******/ 		
/******/ 				// Module API
/******/ 				active: true,
/******/ 				accept: function (dep, callback, errorHandler) {
/******/ 					if (dep === undefined) hot._selfAccepted = true;
/******/ 					else if (typeof dep === "function") hot._selfAccepted = dep;
/******/ 					else if (typeof dep === "object" && dep !== null) {
/******/ 						for (var i = 0; i < dep.length; i++) {
/******/ 							hot._acceptedDependencies[dep[i]] = callback || function () {};
/******/ 							hot._acceptedErrorHandlers[dep[i]] = errorHandler;
/******/ 						}
/******/ 					} else {
/******/ 						hot._acceptedDependencies[dep] = callback || function () {};
/******/ 						hot._acceptedErrorHandlers[dep] = errorHandler;
/******/ 					}
/******/ 				},
/******/ 				decline: function (dep) {
/******/ 					if (dep === undefined) hot._selfDeclined = true;
/******/ 					else if (typeof dep === "object" && dep !== null)
/******/ 						for (var i = 0; i < dep.length; i++)
/******/ 							hot._declinedDependencies[dep[i]] = true;
/******/ 					else hot._declinedDependencies[dep] = true;
/******/ 				},
/******/ 				dispose: function (callback) {
/******/ 					hot._disposeHandlers.push(callback);
/******/ 				},
/******/ 				addDisposeHandler: function (callback) {
/******/ 					hot._disposeHandlers.push(callback);
/******/ 				},
/******/ 				removeDisposeHandler: function (callback) {
/******/ 					var idx = hot._disposeHandlers.indexOf(callback);
/******/ 					if (idx >= 0) hot._disposeHandlers.splice(idx, 1);
/******/ 				},
/******/ 				invalidate: function () {
/******/ 					this._selfInvalidated = true;
/******/ 					switch (currentStatus) {
/******/ 						case "idle":
/******/ 							currentUpdateApplyHandlers = [];
/******/ 							Object.keys(__webpack_require__.hmrI).forEach(function (key) {
/******/ 								__webpack_require__.hmrI[key](
/******/ 									moduleId,
/******/ 									currentUpdateApplyHandlers
/******/ 								);
/******/ 							});
/******/ 							setStatus("ready");
/******/ 							break;
/******/ 						case "ready":
/******/ 							Object.keys(__webpack_require__.hmrI).forEach(function (key) {
/******/ 								__webpack_require__.hmrI[key](
/******/ 									moduleId,
/******/ 									currentUpdateApplyHandlers
/******/ 								);
/******/ 							});
/******/ 							break;
/******/ 						case "prepare":
/******/ 						case "check":
/******/ 						case "dispose":
/******/ 						case "apply":
/******/ 							(queuedInvalidatedModules = queuedInvalidatedModules || []).push(
/******/ 								moduleId
/******/ 							);
/******/ 							break;
/******/ 						default:
/******/ 							// ignore requests in error states
/******/ 							break;
/******/ 					}
/******/ 				},
/******/ 		
/******/ 				// Management API
/******/ 				check: hotCheck,
/******/ 				apply: hotApply,
/******/ 				status: function (l) {
/******/ 					if (!l) return currentStatus;
/******/ 					registeredStatusHandlers.push(l);
/******/ 				},
/******/ 				addStatusHandler: function (l) {
/******/ 					registeredStatusHandlers.push(l);
/******/ 				},
/******/ 				removeStatusHandler: function (l) {
/******/ 					var idx = registeredStatusHandlers.indexOf(l);
/******/ 					if (idx >= 0) registeredStatusHandlers.splice(idx, 1);
/******/ 				},
/******/ 		
/******/ 				//inherit from previous dispose call
/******/ 				data: currentModuleData[moduleId]
/******/ 			};
/******/ 			currentChildModule = undefined;
/******/ 			return hot;
/******/ 		}
/******/ 		
/******/ 		function setStatus(newStatus) {
/******/ 			currentStatus = newStatus;
/******/ 			var results = [];
/******/ 		
/******/ 			for (var i = 0; i < registeredStatusHandlers.length; i++)
/******/ 				results[i] = registeredStatusHandlers[i].call(null, newStatus);
/******/ 		
/******/ 			return Promise.all(results).then(function () {});
/******/ 		}
/******/ 		
/******/ 		function unblock() {
/******/ 			if (--blockingPromises === 0) {
/******/ 				setStatus("ready").then(function () {
/******/ 					if (blockingPromises === 0) {
/******/ 						var list = blockingPromisesWaiting;
/******/ 						blockingPromisesWaiting = [];
/******/ 						for (var i = 0; i < list.length; i++) {
/******/ 							list[i]();
/******/ 						}
/******/ 					}
/******/ 				});
/******/ 			}
/******/ 		}
/******/ 		
/******/ 		function trackBlockingPromise(promise) {
/******/ 			switch (currentStatus) {
/******/ 				case "ready":
/******/ 					setStatus("prepare");
/******/ 				/* fallthrough */
/******/ 				case "prepare":
/******/ 					blockingPromises++;
/******/ 					promise.then(unblock, unblock);
/******/ 					return promise;
/******/ 				default:
/******/ 					return promise;
/******/ 			}
/******/ 		}
/******/ 		
/******/ 		function waitForBlockingPromises(fn) {
/******/ 			if (blockingPromises === 0) return fn();
/******/ 			return new Promise(function (resolve) {
/******/ 				blockingPromisesWaiting.push(function () {
/******/ 					resolve(fn());
/******/ 				});
/******/ 			});
/******/ 		}
/******/ 		
/******/ 		function hotCheck(applyOnUpdate) {
/******/ 			if (currentStatus !== "idle") {
/******/ 				throw new Error("check() is only allowed in idle status");
/******/ 			}
/******/ 			return setStatus("check")
/******/ 				.then(__webpack_require__.hmrM)
/******/ 				.then(function (update) {
/******/ 					if (!update) {
/******/ 						return setStatus(applyInvalidatedModules() ? "ready" : "idle").then(
/******/ 							function () {
/******/ 								return null;
/******/ 							}
/******/ 						);
/******/ 					}
/******/ 		
/******/ 					return setStatus("prepare").then(function () {
/******/ 						var updatedModules = [];
/******/ 						currentUpdateApplyHandlers = [];
/******/ 		
/******/ 						return Promise.all(
/******/ 							Object.keys(__webpack_require__.hmrC).reduce(function (
/******/ 								promises,
/******/ 								key
/******/ 							) {
/******/ 								__webpack_require__.hmrC[key](
/******/ 									update.c,
/******/ 									update.r,
/******/ 									update.m,
/******/ 									promises,
/******/ 									currentUpdateApplyHandlers,
/******/ 									updatedModules
/******/ 								);
/******/ 								return promises;
/******/ 							}, [])
/******/ 						).then(function () {
/******/ 							return waitForBlockingPromises(function () {
/******/ 								if (applyOnUpdate) {
/******/ 									return internalApply(applyOnUpdate);
/******/ 								} else {
/******/ 									return setStatus("ready").then(function () {
/******/ 										return updatedModules;
/******/ 									});
/******/ 								}
/******/ 							});
/******/ 						});
/******/ 					});
/******/ 				});
/******/ 		}
/******/ 		
/******/ 		function hotApply(options) {
/******/ 			if (currentStatus !== "ready") {
/******/ 				return Promise.resolve().then(function () {
/******/ 					throw new Error(
/******/ 						"apply() is only allowed in ready status (state: " +
/******/ 							currentStatus +
/******/ 							")"
/******/ 					);
/******/ 				});
/******/ 			}
/******/ 			return internalApply(options);
/******/ 		}
/******/ 		
/******/ 		function internalApply(options) {
/******/ 			options = options || {};
/******/ 		
/******/ 			applyInvalidatedModules();
/******/ 		
/******/ 			var results = currentUpdateApplyHandlers.map(function (handler) {
/******/ 				return handler(options);
/******/ 			});
/******/ 			currentUpdateApplyHandlers = undefined;
/******/ 		
/******/ 			var errors = results
/******/ 				.map(function (r) {
/******/ 					return r.error;
/******/ 				})
/******/ 				.filter(Boolean);
/******/ 		
/******/ 			if (errors.length > 0) {
/******/ 				return setStatus("abort").then(function () {
/******/ 					throw errors[0];
/******/ 				});
/******/ 			}
/******/ 		
/******/ 			// Now in "dispose" phase
/******/ 			var disposePromise = setStatus("dispose");
/******/ 		
/******/ 			results.forEach(function (result) {
/******/ 				if (result.dispose) result.dispose();
/******/ 			});
/******/ 		
/******/ 			// Now in "apply" phase
/******/ 			var applyPromise = setStatus("apply");
/******/ 		
/******/ 			var error;
/******/ 			var reportError = function (err) {
/******/ 				if (!error) error = err;
/******/ 			};
/******/ 		
/******/ 			var outdatedModules = [];
/******/ 			results.forEach(function (result) {
/******/ 				if (result.apply) {
/******/ 					var modules = result.apply(reportError);
/******/ 					if (modules) {
/******/ 						for (var i = 0; i < modules.length; i++) {
/******/ 							outdatedModules.push(modules[i]);
/******/ 						}
/******/ 					}
/******/ 				}
/******/ 			});
/******/ 		
/******/ 			return Promise.all([disposePromise, applyPromise]).then(function () {
/******/ 				// handle errors in accept handlers and self accepted module load
/******/ 				if (error) {
/******/ 					return setStatus("fail").then(function () {
/******/ 						throw error;
/******/ 					});
/******/ 				}
/******/ 		
/******/ 				if (queuedInvalidatedModules) {
/******/ 					return internalApply(options).then(function (list) {
/******/ 						outdatedModules.forEach(function (moduleId) {
/******/ 							if (list.indexOf(moduleId) < 0) list.push(moduleId);
/******/ 						});
/******/ 						return list;
/******/ 					});
/******/ 				}
/******/ 		
/******/ 				return setStatus("idle").then(function () {
/******/ 					return outdatedModules;
/******/ 				});
/******/ 			});
/******/ 		}
/******/ 		
/******/ 		function applyInvalidatedModules() {
/******/ 			if (queuedInvalidatedModules) {
/******/ 				if (!currentUpdateApplyHandlers) currentUpdateApplyHandlers = [];
/******/ 				Object.keys(__webpack_require__.hmrI).forEach(function (key) {
/******/ 					queuedInvalidatedModules.forEach(function (moduleId) {
/******/ 						__webpack_require__.hmrI[key](
/******/ 							moduleId,
/******/ 							currentUpdateApplyHandlers
/******/ 						);
/******/ 					});
/******/ 				});
/******/ 				queuedInvalidatedModules = undefined;
/******/ 				return true;
/******/ 			}
/******/ 		}
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/publicPath */
/******/ 	!function() {
/******/ 		var scriptUrl;
/******/ 		if (__webpack_require__.g.importScripts) scriptUrl = __webpack_require__.g.location + "";
/******/ 		var document = __webpack_require__.g.document;
/******/ 		if (!scriptUrl && document) {
/******/ 			if (document.currentScript)
/******/ 				scriptUrl = document.currentScript.src;
/******/ 			if (!scriptUrl) {
/******/ 				var scripts = document.getElementsByTagName("script");
/******/ 				if(scripts.length) {
/******/ 					var i = scripts.length - 1;
/******/ 					while (i > -1 && (!scriptUrl || !/^http(s?):/.test(scriptUrl))) scriptUrl = scripts[i--].src;
/******/ 				}
/******/ 			}
/******/ 		}
/******/ 		// When supporting browsers where an automatic publicPath is not supported you must specify an output.publicPath manually via configuration
/******/ 		// or pass an empty string ("") and set the __webpack_public_path__ variable from your code to use your own logic.
/******/ 		if (!scriptUrl) throw new Error("Automatic publicPath is not supported in this browser");
/******/ 		scriptUrl = scriptUrl.replace(/#.*$/, "").replace(/\?.*$/, "").replace(/\/[^\/]+$/, "/");
/******/ 		__webpack_require__.p = scriptUrl;
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	!function() {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = __webpack_require__.hmrS_jsonp = __webpack_require__.hmrS_jsonp || {
/******/ 			721: 0,
/******/ 			347: 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		var currentUpdatedModulesList;
/******/ 		var waitingUpdateResolves = {};
/******/ 		function loadUpdateChunk(chunkId, updatedModulesList) {
/******/ 			currentUpdatedModulesList = updatedModulesList;
/******/ 			return new Promise(function(resolve, reject) {
/******/ 				waitingUpdateResolves[chunkId] = resolve;
/******/ 				// start update chunk loading
/******/ 				var url = __webpack_require__.p + __webpack_require__.hu(chunkId);
/******/ 				// create error before stack unwound to get useful stacktrace later
/******/ 				var error = new Error();
/******/ 				var loadingEnded = function(event) {
/******/ 					if(waitingUpdateResolves[chunkId]) {
/******/ 						waitingUpdateResolves[chunkId] = undefined
/******/ 						var errorType = event && (event.type === 'load' ? 'missing' : event.type);
/******/ 						var realSrc = event && event.target && event.target.src;
/******/ 						error.message = 'Loading hot update chunk ' + chunkId + ' failed.\n(' + errorType + ': ' + realSrc + ')';
/******/ 						error.name = 'ChunkLoadError';
/******/ 						error.type = errorType;
/******/ 						error.request = realSrc;
/******/ 						reject(error);
/******/ 					}
/******/ 				};
/******/ 				__webpack_require__.l(url, loadingEnded);
/******/ 			});
/******/ 		}
/******/ 		
/******/ 		self["webpackHotUpdate_americanexpress_dls"] = function(chunkId, moreModules, runtime) {
/******/ 			for(var moduleId in moreModules) {
/******/ 				if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 					currentUpdate[moduleId] = moreModules[moduleId];
/******/ 					if(currentUpdatedModulesList) currentUpdatedModulesList.push(moduleId);
/******/ 				}
/******/ 			}
/******/ 			if(runtime) currentUpdateRuntime.push(runtime);
/******/ 			if(waitingUpdateResolves[chunkId]) {
/******/ 				waitingUpdateResolves[chunkId]();
/******/ 				waitingUpdateResolves[chunkId] = undefined;
/******/ 			}
/******/ 		};
/******/ 		
/******/ 		var currentUpdateChunks;
/******/ 		var currentUpdate;
/******/ 		var currentUpdateRemovedChunks;
/******/ 		var currentUpdateRuntime;
/******/ 		function applyHandler(options) {
/******/ 			if (__webpack_require__.f) delete __webpack_require__.f.jsonpHmr;
/******/ 			currentUpdateChunks = undefined;
/******/ 			function getAffectedModuleEffects(updateModuleId) {
/******/ 				var outdatedModules = [updateModuleId];
/******/ 				var outdatedDependencies = {};
/******/ 		
/******/ 				var queue = outdatedModules.map(function (id) {
/******/ 					return {
/******/ 						chain: [id],
/******/ 						id: id
/******/ 					};
/******/ 				});
/******/ 				while (queue.length > 0) {
/******/ 					var queueItem = queue.pop();
/******/ 					var moduleId = queueItem.id;
/******/ 					var chain = queueItem.chain;
/******/ 					var module = __webpack_require__.c[moduleId];
/******/ 					if (
/******/ 						!module ||
/******/ 						(module.hot._selfAccepted && !module.hot._selfInvalidated)
/******/ 					)
/******/ 						continue;
/******/ 					if (module.hot._selfDeclined) {
/******/ 						return {
/******/ 							type: "self-declined",
/******/ 							chain: chain,
/******/ 							moduleId: moduleId
/******/ 						};
/******/ 					}
/******/ 					if (module.hot._main) {
/******/ 						return {
/******/ 							type: "unaccepted",
/******/ 							chain: chain,
/******/ 							moduleId: moduleId
/******/ 						};
/******/ 					}
/******/ 					for (var i = 0; i < module.parents.length; i++) {
/******/ 						var parentId = module.parents[i];
/******/ 						var parent = __webpack_require__.c[parentId];
/******/ 						if (!parent) continue;
/******/ 						if (parent.hot._declinedDependencies[moduleId]) {
/******/ 							return {
/******/ 								type: "declined",
/******/ 								chain: chain.concat([parentId]),
/******/ 								moduleId: moduleId,
/******/ 								parentId: parentId
/******/ 							};
/******/ 						}
/******/ 						if (outdatedModules.indexOf(parentId) !== -1) continue;
/******/ 						if (parent.hot._acceptedDependencies[moduleId]) {
/******/ 							if (!outdatedDependencies[parentId])
/******/ 								outdatedDependencies[parentId] = [];
/******/ 							addAllToSet(outdatedDependencies[parentId], [moduleId]);
/******/ 							continue;
/******/ 						}
/******/ 						delete outdatedDependencies[parentId];
/******/ 						outdatedModules.push(parentId);
/******/ 						queue.push({
/******/ 							chain: chain.concat([parentId]),
/******/ 							id: parentId
/******/ 						});
/******/ 					}
/******/ 				}
/******/ 		
/******/ 				return {
/******/ 					type: "accepted",
/******/ 					moduleId: updateModuleId,
/******/ 					outdatedModules: outdatedModules,
/******/ 					outdatedDependencies: outdatedDependencies
/******/ 				};
/******/ 			}
/******/ 		
/******/ 			function addAllToSet(a, b) {
/******/ 				for (var i = 0; i < b.length; i++) {
/******/ 					var item = b[i];
/******/ 					if (a.indexOf(item) === -1) a.push(item);
/******/ 				}
/******/ 			}
/******/ 		
/******/ 			// at begin all updates modules are outdated
/******/ 			// the "outdated" status can propagate to parents if they don't accept the children
/******/ 			var outdatedDependencies = {};
/******/ 			var outdatedModules = [];
/******/ 			var appliedUpdate = {};
/******/ 		
/******/ 			var warnUnexpectedRequire = function warnUnexpectedRequire(module) {
/******/ 				console.warn(
/******/ 					"[HMR] unexpected require(" + module.id + ") to disposed module"
/******/ 				);
/******/ 			};
/******/ 		
/******/ 			for (var moduleId in currentUpdate) {
/******/ 				if (__webpack_require__.o(currentUpdate, moduleId)) {
/******/ 					var newModuleFactory = currentUpdate[moduleId];
/******/ 					/** @type {TODO} */
/******/ 					var result;
/******/ 					if (newModuleFactory) {
/******/ 						result = getAffectedModuleEffects(moduleId);
/******/ 					} else {
/******/ 						result = {
/******/ 							type: "disposed",
/******/ 							moduleId: moduleId
/******/ 						};
/******/ 					}
/******/ 					/** @type {Error|false} */
/******/ 					var abortError = false;
/******/ 					var doApply = false;
/******/ 					var doDispose = false;
/******/ 					var chainInfo = "";
/******/ 					if (result.chain) {
/******/ 						chainInfo = "\nUpdate propagation: " + result.chain.join(" -> ");
/******/ 					}
/******/ 					switch (result.type) {
/******/ 						case "self-declined":
/******/ 							if (options.onDeclined) options.onDeclined(result);
/******/ 							if (!options.ignoreDeclined)
/******/ 								abortError = new Error(
/******/ 									"Aborted because of self decline: " +
/******/ 										result.moduleId +
/******/ 										chainInfo
/******/ 								);
/******/ 							break;
/******/ 						case "declined":
/******/ 							if (options.onDeclined) options.onDeclined(result);
/******/ 							if (!options.ignoreDeclined)
/******/ 								abortError = new Error(
/******/ 									"Aborted because of declined dependency: " +
/******/ 										result.moduleId +
/******/ 										" in " +
/******/ 										result.parentId +
/******/ 										chainInfo
/******/ 								);
/******/ 							break;
/******/ 						case "unaccepted":
/******/ 							if (options.onUnaccepted) options.onUnaccepted(result);
/******/ 							if (!options.ignoreUnaccepted)
/******/ 								abortError = new Error(
/******/ 									"Aborted because " + moduleId + " is not accepted" + chainInfo
/******/ 								);
/******/ 							break;
/******/ 						case "accepted":
/******/ 							if (options.onAccepted) options.onAccepted(result);
/******/ 							doApply = true;
/******/ 							break;
/******/ 						case "disposed":
/******/ 							if (options.onDisposed) options.onDisposed(result);
/******/ 							doDispose = true;
/******/ 							break;
/******/ 						default:
/******/ 							throw new Error("Unexception type " + result.type);
/******/ 					}
/******/ 					if (abortError) {
/******/ 						return {
/******/ 							error: abortError
/******/ 						};
/******/ 					}
/******/ 					if (doApply) {
/******/ 						appliedUpdate[moduleId] = newModuleFactory;
/******/ 						addAllToSet(outdatedModules, result.outdatedModules);
/******/ 						for (moduleId in result.outdatedDependencies) {
/******/ 							if (__webpack_require__.o(result.outdatedDependencies, moduleId)) {
/******/ 								if (!outdatedDependencies[moduleId])
/******/ 									outdatedDependencies[moduleId] = [];
/******/ 								addAllToSet(
/******/ 									outdatedDependencies[moduleId],
/******/ 									result.outdatedDependencies[moduleId]
/******/ 								);
/******/ 							}
/******/ 						}
/******/ 					}
/******/ 					if (doDispose) {
/******/ 						addAllToSet(outdatedModules, [result.moduleId]);
/******/ 						appliedUpdate[moduleId] = warnUnexpectedRequire;
/******/ 					}
/******/ 				}
/******/ 			}
/******/ 			currentUpdate = undefined;
/******/ 		
/******/ 			// Store self accepted outdated modules to require them later by the module system
/******/ 			var outdatedSelfAcceptedModules = [];
/******/ 			for (var j = 0; j < outdatedModules.length; j++) {
/******/ 				var outdatedModuleId = outdatedModules[j];
/******/ 				var module = __webpack_require__.c[outdatedModuleId];
/******/ 				if (
/******/ 					module &&
/******/ 					(module.hot._selfAccepted || module.hot._main) &&
/******/ 					// removed self-accepted modules should not be required
/******/ 					appliedUpdate[outdatedModuleId] !== warnUnexpectedRequire &&
/******/ 					// when called invalidate self-accepting is not possible
/******/ 					!module.hot._selfInvalidated
/******/ 				) {
/******/ 					outdatedSelfAcceptedModules.push({
/******/ 						module: outdatedModuleId,
/******/ 						require: module.hot._requireSelf,
/******/ 						errorHandler: module.hot._selfAccepted
/******/ 					});
/******/ 				}
/******/ 			}
/******/ 		
/******/ 			var moduleOutdatedDependencies;
/******/ 		
/******/ 			return {
/******/ 				dispose: function () {
/******/ 					currentUpdateRemovedChunks.forEach(function (chunkId) {
/******/ 						delete installedChunks[chunkId];
/******/ 					});
/******/ 					currentUpdateRemovedChunks = undefined;
/******/ 		
/******/ 					var idx;
/******/ 					var queue = outdatedModules.slice();
/******/ 					while (queue.length > 0) {
/******/ 						var moduleId = queue.pop();
/******/ 						var module = __webpack_require__.c[moduleId];
/******/ 						if (!module) continue;
/******/ 		
/******/ 						var data = {};
/******/ 		
/******/ 						// Call dispose handlers
/******/ 						var disposeHandlers = module.hot._disposeHandlers;
/******/ 						for (j = 0; j < disposeHandlers.length; j++) {
/******/ 							disposeHandlers[j].call(null, data);
/******/ 						}
/******/ 						__webpack_require__.hmrD[moduleId] = data;
/******/ 		
/******/ 						// disable module (this disables requires from this module)
/******/ 						module.hot.active = false;
/******/ 		
/******/ 						// remove module from cache
/******/ 						delete __webpack_require__.c[moduleId];
/******/ 		
/******/ 						// when disposing there is no need to call dispose handler
/******/ 						delete outdatedDependencies[moduleId];
/******/ 		
/******/ 						// remove "parents" references from all children
/******/ 						for (j = 0; j < module.children.length; j++) {
/******/ 							var child = __webpack_require__.c[module.children[j]];
/******/ 							if (!child) continue;
/******/ 							idx = child.parents.indexOf(moduleId);
/******/ 							if (idx >= 0) {
/******/ 								child.parents.splice(idx, 1);
/******/ 							}
/******/ 						}
/******/ 					}
/******/ 		
/******/ 					// remove outdated dependency from module children
/******/ 					var dependency;
/******/ 					for (var outdatedModuleId in outdatedDependencies) {
/******/ 						if (__webpack_require__.o(outdatedDependencies, outdatedModuleId)) {
/******/ 							module = __webpack_require__.c[outdatedModuleId];
/******/ 							if (module) {
/******/ 								moduleOutdatedDependencies =
/******/ 									outdatedDependencies[outdatedModuleId];
/******/ 								for (j = 0; j < moduleOutdatedDependencies.length; j++) {
/******/ 									dependency = moduleOutdatedDependencies[j];
/******/ 									idx = module.children.indexOf(dependency);
/******/ 									if (idx >= 0) module.children.splice(idx, 1);
/******/ 								}
/******/ 							}
/******/ 						}
/******/ 					}
/******/ 				},
/******/ 				apply: function (reportError) {
/******/ 					// insert new code
/******/ 					for (var updateModuleId in appliedUpdate) {
/******/ 						if (__webpack_require__.o(appliedUpdate, updateModuleId)) {
/******/ 							__webpack_require__.m[updateModuleId] = appliedUpdate[updateModuleId];
/******/ 						}
/******/ 					}
/******/ 		
/******/ 					// run new runtime modules
/******/ 					for (var i = 0; i < currentUpdateRuntime.length; i++) {
/******/ 						currentUpdateRuntime[i](__webpack_require__);
/******/ 					}
/******/ 		
/******/ 					// call accept handlers
/******/ 					for (var outdatedModuleId in outdatedDependencies) {
/******/ 						if (__webpack_require__.o(outdatedDependencies, outdatedModuleId)) {
/******/ 							var module = __webpack_require__.c[outdatedModuleId];
/******/ 							if (module) {
/******/ 								moduleOutdatedDependencies =
/******/ 									outdatedDependencies[outdatedModuleId];
/******/ 								var callbacks = [];
/******/ 								var errorHandlers = [];
/******/ 								var dependenciesForCallbacks = [];
/******/ 								for (var j = 0; j < moduleOutdatedDependencies.length; j++) {
/******/ 									var dependency = moduleOutdatedDependencies[j];
/******/ 									var acceptCallback =
/******/ 										module.hot._acceptedDependencies[dependency];
/******/ 									var errorHandler =
/******/ 										module.hot._acceptedErrorHandlers[dependency];
/******/ 									if (acceptCallback) {
/******/ 										if (callbacks.indexOf(acceptCallback) !== -1) continue;
/******/ 										callbacks.push(acceptCallback);
/******/ 										errorHandlers.push(errorHandler);
/******/ 										dependenciesForCallbacks.push(dependency);
/******/ 									}
/******/ 								}
/******/ 								for (var k = 0; k < callbacks.length; k++) {
/******/ 									try {
/******/ 										callbacks[k].call(null, moduleOutdatedDependencies);
/******/ 									} catch (err) {
/******/ 										if (typeof errorHandlers[k] === "function") {
/******/ 											try {
/******/ 												errorHandlers[k](err, {
/******/ 													moduleId: outdatedModuleId,
/******/ 													dependencyId: dependenciesForCallbacks[k]
/******/ 												});
/******/ 											} catch (err2) {
/******/ 												if (options.onErrored) {
/******/ 													options.onErrored({
/******/ 														type: "accept-error-handler-errored",
/******/ 														moduleId: outdatedModuleId,
/******/ 														dependencyId: dependenciesForCallbacks[k],
/******/ 														error: err2,
/******/ 														originalError: err
/******/ 													});
/******/ 												}
/******/ 												if (!options.ignoreErrored) {
/******/ 													reportError(err2);
/******/ 													reportError(err);
/******/ 												}
/******/ 											}
/******/ 										} else {
/******/ 											if (options.onErrored) {
/******/ 												options.onErrored({
/******/ 													type: "accept-errored",
/******/ 													moduleId: outdatedModuleId,
/******/ 													dependencyId: dependenciesForCallbacks[k],
/******/ 													error: err
/******/ 												});
/******/ 											}
/******/ 											if (!options.ignoreErrored) {
/******/ 												reportError(err);
/******/ 											}
/******/ 										}
/******/ 									}
/******/ 								}
/******/ 							}
/******/ 						}
/******/ 					}
/******/ 		
/******/ 					// Load self accepted modules
/******/ 					for (var o = 0; o < outdatedSelfAcceptedModules.length; o++) {
/******/ 						var item = outdatedSelfAcceptedModules[o];
/******/ 						var moduleId = item.module;
/******/ 						try {
/******/ 							item.require(moduleId);
/******/ 						} catch (err) {
/******/ 							if (typeof item.errorHandler === "function") {
/******/ 								try {
/******/ 									item.errorHandler(err, {
/******/ 										moduleId: moduleId,
/******/ 										module: __webpack_require__.c[moduleId]
/******/ 									});
/******/ 								} catch (err2) {
/******/ 									if (options.onErrored) {
/******/ 										options.onErrored({
/******/ 											type: "self-accept-error-handler-errored",
/******/ 											moduleId: moduleId,
/******/ 											error: err2,
/******/ 											originalError: err
/******/ 										});
/******/ 									}
/******/ 									if (!options.ignoreErrored) {
/******/ 										reportError(err2);
/******/ 										reportError(err);
/******/ 									}
/******/ 								}
/******/ 							} else {
/******/ 								if (options.onErrored) {
/******/ 									options.onErrored({
/******/ 										type: "self-accept-errored",
/******/ 										moduleId: moduleId,
/******/ 										error: err
/******/ 									});
/******/ 								}
/******/ 								if (!options.ignoreErrored) {
/******/ 									reportError(err);
/******/ 								}
/******/ 							}
/******/ 						}
/******/ 					}
/******/ 		
/******/ 					return outdatedModules;
/******/ 				}
/******/ 			};
/******/ 		}
/******/ 		__webpack_require__.hmrI.jsonp = function (moduleId, applyHandlers) {
/******/ 			if (!currentUpdate) {
/******/ 				currentUpdate = {};
/******/ 				currentUpdateRuntime = [];
/******/ 				currentUpdateRemovedChunks = [];
/******/ 				applyHandlers.push(applyHandler);
/******/ 			}
/******/ 			if (!__webpack_require__.o(currentUpdate, moduleId)) {
/******/ 				currentUpdate[moduleId] = __webpack_require__.m[moduleId];
/******/ 			}
/******/ 		};
/******/ 		__webpack_require__.hmrC.jsonp = function (
/******/ 			chunkIds,
/******/ 			removedChunks,
/******/ 			removedModules,
/******/ 			promises,
/******/ 			applyHandlers,
/******/ 			updatedModulesList
/******/ 		) {
/******/ 			applyHandlers.push(applyHandler);
/******/ 			currentUpdateChunks = {};
/******/ 			currentUpdateRemovedChunks = removedChunks;
/******/ 			currentUpdate = removedModules.reduce(function (obj, key) {
/******/ 				obj[key] = false;
/******/ 				return obj;
/******/ 			}, {});
/******/ 			currentUpdateRuntime = [];
/******/ 			chunkIds.forEach(function (chunkId) {
/******/ 				if (
/******/ 					__webpack_require__.o(installedChunks, chunkId) &&
/******/ 					installedChunks[chunkId] !== undefined
/******/ 				) {
/******/ 					promises.push(loadUpdateChunk(chunkId, updatedModulesList));
/******/ 					currentUpdateChunks[chunkId] = true;
/******/ 				} else {
/******/ 					currentUpdateChunks[chunkId] = false;
/******/ 				}
/******/ 			});
/******/ 			if (__webpack_require__.f) {
/******/ 				__webpack_require__.f.jsonpHmr = function (chunkId, promises) {
/******/ 					if (
/******/ 						currentUpdateChunks &&
/******/ 						__webpack_require__.o(currentUpdateChunks, chunkId) &&
/******/ 						!currentUpdateChunks[chunkId]
/******/ 					) {
/******/ 						promises.push(loadUpdateChunk(chunkId));
/******/ 						currentUpdateChunks[chunkId] = true;
/******/ 					}
/******/ 				};
/******/ 			}
/******/ 		};
/******/ 		
/******/ 		__webpack_require__.hmrM = function() {
/******/ 			if (typeof fetch === "undefined") throw new Error("No browser support: need fetch API");
/******/ 			return fetch(__webpack_require__.p + __webpack_require__.hmrF()).then(function(response) {
/******/ 				if(response.status === 404) return; // no update available
/******/ 				if(!response.ok) throw new Error("Failed to fetch update manifest " + response.statusText);
/******/ 				return response.json();
/******/ 			});
/******/ 		};
/******/ 		
/******/ 		// no on chunks loaded
/******/ 		
/******/ 		// no jsonp function
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// module cache are used so entry inlining is disabled
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	var __webpack_exports__ = __webpack_require__(580);
/******/ 	
/******/ })()
;