export default {
  "video": {
    "overflow": "hidden",
    "position": "relative"
  },
  "video_video": {
    "display": "block",
    "width": "100%"
  },
  "videoOverlay": {
    "transition": "opacity 500ms ease-in",
    "&::before": {
      "backgroundColor": "#000",
      "content": "\"\"",
      "bottom": "0",
      "left": "0",
      "position": "absolute",
      "right": "0",
      "top": "0",
      "opacity": "0.35"
    }
  },
  "videoOverlay_button": {
    "position": "absolute",
    "top": "0",
    "bottom": "0",
    "left": "0",
    "right": "0",
    "textAlign": "center",
    "width": "100%",
    "zIndex": "5"
  },
  "videoFooter": {
    "bottom": "0",
    "left": "0",
    "padding": "0.625rem",
    "position": "absolute",
    "right": "0"
  },
  "videoCaption": {
    "display": "flex",
    "marginBottom": "0.625rem"
  },
  "videoCaption_span": {
    "background": "#000",
    "borderRadius": "4px",
    "color": "#fff",
    "margin": "auto",
    "opacity": "0.8",
    "padding": "0.625rem"
  },
  "videoControls": {
    "background": "#000",
    "borderRadius": "0.25rem",
    "color": "#fff",
    "display": "flex",
    "margin": "0 auto",
    "maxWidth": "64rem",
    "opacity": "0",
    "padding": "0.375rem 0.625rem",
    "transition": "opacity 400ms ease-in",
    "&:hover": {
      "opacity": "0.8"
    },
    "&:focus": {
      "opacity": "0.8"
    },
    "&:active": {
      "opacity": "0.8"
    },
    "&:focus-within": {
      "opacity": "0.8"
    },
    "&:not(:last-child)": {
      "marginRight": "0.625rem"
    }
  },
  "videoControls_visible": {
    "opacity": "0.8"
  },
  "videoControls_button": {
    "&:focus": {
      "outline": "dashed 1px rgb(255, 255, 255)",
      "outlineOffset": "3px"
    }
  },
  "videoControls_progress": {
    "height": "0.375rem",
    "marginBottom": "0.125rem",
    "width": "100%"
  },
  "videoControls_progress_value": {
    "WebkitAppearance": "none",
    "border": "none",
    "&::-webkit-progress-bar": {
      "backgroundColor": "#fff"
    },
    "&::-webkit-progress-value": {
      "backgroundColor": "#006fcf"
    }
  },
  "videoControls__volumeSlider": {
    "alignItems": "center",
    "background": "#000",
    "bottom": "4.375rem",
    "display": "flex",
    "height": "2.5rem",
    "opacity": "0",
    "padding": "0.5rem",
    "position": "absolute",
    "right": "-3.125rem",
    "transform": "rotate(-90deg)",
    "width": "7.8125rem",
    "&:hover": {
      "opacity": "1",
      "outline": "dashed 1px rgb(255, 255, 255)",
      "outlineOffset": "3px"
    },
    "&:focus": {
      "opacity": "1",
      "outline": "dashed 1px rgb(255, 255, 255)",
      "outlineOffset": "3px"
    },
    "&:focus-within": {
      "opacity": "1",
      "outline": "dashed 1px rgb(255, 255, 255)",
      "outlineOffset": "3px"
    },
    "&:active": {
      "opacity": "1",
      "outline": "dashed 1px rgb(255, 255, 255)",
      "outlineOffset": "3px"
    }
  },
  "videoControls__volumeSlider_input_type_range": {
    "WebkitAppearance": "none",
    "width": "100%",
    "background": "transparent",
    "&:focus": {
      "outline": "none"
    },
    "&::-webkit-slider-thumb": {
      "backgroundColor": "#fff",
      "border": "0",
      "borderRadius": "50%",
      "height": "15px",
      "width": "15px",
      "WebkitAppearance": "none",
      "appearance": "none",
      "marginTop": "-6px"
    },
    "&::-webkit-slider-runnable-track": {
      "background": "#fff",
      "borderRadius": "4px",
      "color": "transparent",
      "cursor": "pointer",
      "height": "4px",
      "width": "100%"
    },
    "&::-moz-range-thumb": {
      "MozAppearance": "none !important",
      "backgroundColor": "#fff",
      "border": "0",
      "borderRadius": "50%",
      "height": "15px",
      "width": "15px",
      "WebkitAppearance": "none"
    },
    "&::-moz-range-progress": {
      "backgroundColor": "#006fcf"
    },
    "&::-moz-range-track": {
      "MozAppearance": "none",
      "backgroundColor": "#fff"
    },
    "&::-ms-track": {
      "height": "3px"
    },
    "&::-ms-thumb": {
      "display": "block",
      "MsAppearance": "none !important",
      "zIndex": "9999",
      "marginTop": "0",
      "height": "15px",
      "width": "15px",
      "backgroundColor": "#fff",
      "border": "0",
      "borderRadius": "50%",
      "WebkitAppearance": "none"
    }
  },
  "videoControls__videoVolume": {
    "position": "relative"
  },
  "videoControls__videoVolume_button": {
    "&:hover + .volumeSlider": {
      "opacity": "1"
    },
    "&:focus + .volumeSlider": {
      "opacity": "1"
    },
    "&:active + .volumeSlider": {
      "opacity": "1"
    }
  },
  "videoSm": {
    "backgroundColor": "#000"
  },
  "videoSmFooter": {
    "padding": "0",
    "position": "static"
  },
  "@media (max-width: 374px)": {
    "video": {
      "backgroundColor": "#000"
    },
    "videoFooter": {
      "padding": "0",
      "position": "static"
    }
  }
}