export default {
  "tooltip": {
    "backgroundColor": "#53565a",
    "boxShadow": "1px 1px 3px rgba(0, 0, 0, 0.25)",
    "border": "transparent",
    "color": "#fff",
    "visibility": "hidden",
    "lineHeight": "1.2",
    "letterSpacing": "normal",
    "lineBreak": "auto",
    "minWidth": "130px",
    "maxWidth": "200px",
    "opacity": "0",
    "transition": "opacity 0.15S",
    "willChange": "opacity",
    "position": "absolute",
    "width": "max-content",
    "whiteSpace": "normal",
    "zIndex": "98",
    "&:not(.tooltipInfo) .tooltipInner": {
      "padding": "0.9375rem 1.25rem"
    }
  },
  "tooltipContainer": {
    "position": "relative",
    "display": "inline-flex"
  },
  "tooltipContainer_button_icon": {
    "padding": "0.5rem"
  },
  "tooltipContainer_button_icon_iconSm": {
    "padding": "0.6875rem"
  },
  "tooltipContainer_button_glyph_dlsGlyphInfo": {
    "padding": "0.875rem",
    "height": "44px"
  },
  "tooltipContainer_button": {
    "&:focus": {
      "outline": "none"
    },
    "&:focus::before": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "3px"
    }
  },
  "tooltipContainer__dlsGlyphInfo": {
    "&:focus::before": {
      "borderRadius": "50%"
    }
  },
  "tooltipContainer__dlsIconInfo": {
    "&:focus::before": {
      "borderRadius": "50%"
    }
  },
  "tooltipBtnCircle": {
    "borderRadius": "100%",
    "marginRight": "0",
    "padding": "0.34375rem",
    "&:focus": {
      "outline": "none"
    },
    "&:focus span": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "3px"
    }
  },
  "tooltip_animIn": {
    "transition": "opacity 0.15S, visibility 0.15S, transform 0.25S ease-out",
    "opacity": "1"
  },
  "tooltip_animIn__tooltipInner": {
    "transition": "opacity 0.15S, visibility 0.15S",
    "visibility": "visible"
  },
  "tooltip_animIn__tooltipArrowPointer": {
    "transition": "opacity 0.15S, visibility 0.15S",
    "visibility": "visible"
  },
  "tooltipInfo": {
    "backgroundColor": "#fff",
    "borderColor": "#c8c9c7",
    "boxShadow": "0 1px 4px rgba(0, 0, 0, 0.2)",
    "color": "#53565a",
    "maxWidth": "280px"
  },
  "tooltipInfo__tooltipInner": {
    "padding": "1.25rem",
    "textAlign": "left"
  },
  "tooltipInfo__tooltipClose": {
    "marginTop": "0.625rem",
    "padding": "0.625rem 1.25rem"
  },
  "tooltipSm": {
    "minWidth": "0"
  },
  "tooltipNarrow": {
    "padding": "0 20px !important",
    "width": "100%",
    "display": "none !important"
  },
  "tooltipNarrow__tooltipInner": {
    "maxWidth": "none !important",
    "minWidth": "0 !important"
  },
  "tooltipNarrow__tooltipArrow": {
    "display": "none"
  },
  "@media (max-width: 1023px)": {
    "tooltipNarrow": {
      "display": "block !important"
    }
  },
  "tooltip_data_placement_top": {
    "left": "50%",
    "transform": "translateX(-50%)",
    "bottom": "100%",
    "paddingBottom": "0.57rem",
    "marginBottom": "-0.125rem"
  },
  "tooltip_data_placement_bottom": {
    "left": "50%",
    "transform": "translateX(-50%)",
    "top": "100%",
    "paddingTop": "0.53rem",
    "marginTop": "-0.3125rem"
  },
  "tooltip_data_placement_top___tooltipArrow": {
    "height": "0.875rem",
    "left": "0",
    "marginLeft": "0",
    "overflowX": "visible",
    "overflowY": "hidden",
    "width": "100%",
    "display": "flex",
    "justifyContent": "center",
    "bottom": "-0.25rem"
  },
  "tooltip_data_placement_bottom___tooltipArrow": {
    "height": "0.875rem",
    "left": "0",
    "marginLeft": "0",
    "overflowX": "visible",
    "overflowY": "hidden",
    "width": "100%",
    "display": "flex",
    "justifyContent": "center",
    "top": "-0.3125rem"
  },
  "tooltip_data_placement_top___tooltipArrowPointer": {
    "display": "block",
    "bottom": "0.4375rem"
  },
  "tooltip_data_placement_bottom___tooltipArrowPointer": {
    "display": "block",
    "top": "0.4375rem"
  },
  "tooltip_data_placement_right": {
    "top": "50%",
    "transform": "translateY(-50%)",
    "left": "100%",
    "paddingLeft": "0.52rem",
    "marginLeft": "-0.3125rem"
  },
  "tooltip_data_placement_left": {
    "top": "50%",
    "transform": "translateY(-50%)",
    "right": "100%",
    "paddingRight": "0.52rem",
    "marginRight": "-0.3125rem"
  },
  "tooltip_data_placement_right___tooltipArrow": {
    "height": "100%",
    "marginTop": "0",
    "overflowX": "hidden",
    "overflowY": "visible",
    "top": "0",
    "width": "0.875rem",
    "display": "flex",
    "alignItems": "center",
    "left": "-0.3125rem"
  },
  "tooltip_data_placement_left___tooltipArrow": {
    "height": "100%",
    "marginTop": "0",
    "overflowX": "hidden",
    "overflowY": "visible",
    "top": "0",
    "width": "0.875rem",
    "display": "flex",
    "alignItems": "center",
    "right": "-0.3125rem"
  },
  "tooltip_data_placement_right___tooltipArrowPointer": {
    "display": "block",
    "left": "0.4375rem"
  },
  "tooltip_data_placement_left___tooltipArrowPointer": {
    "display": "block",
    "left": "-0.4375rem"
  },
  "@media (max-width: 767px)": {
    "tooltip__tooltipArrow": {
      "display": "none"
    }
  },
  "tooltipInner": {
    "borderRadius": "0.25rem",
    "visibility": "hidden",
    "whiteSpace": "normal",
    "wordWrap": "break-word",
    "position": "relative",
    "textAlign": "center",
    "textDecoration": "none",
    "textShadow": "none",
    "textTransform": "none",
    "transition": "opacity 0.15S, visibility 0.15S, transform 0.25S ease-out",
    "backgroundColor": "inherit",
    "border": "0.0625rem solid transparent",
    "borderColor": "inherit",
    "boxShadow": "inherit"
  },
  "tooltipArrow": {
    "transition": "opacity 0.15S, visibility 0.15S, transform 0.25S ease-out",
    "backgroundColor": "inherit",
    "border": "0.0625rem solid transparent",
    "borderColor": "inherit",
    "boxShadow": "inherit",
    "&:not(.tooltipArrowShadow) .tooltipArrowPointer": {
      "boxShadow": "none"
    },
    "height": "0",
    "position": "absolute",
    "visibility": "hidden",
    "width": "0",
    "borderWidth": "0"
  },
  "tooltipArrowPointer": {
    "transition": "opacity 0.15S, visibility 0.15S, transform 0.25S ease-out",
    "backgroundColor": "inherit",
    "border": "0.0625rem solid transparent",
    "borderColor": "inherit",
    "boxShadow": "inherit",
    "content": "\"\"",
    "display": "none",
    "height": "0.875rem",
    "position": "relative",
    "transform": "rotate(45deg)",
    "visibility": "visible",
    "width": "0.875rem",
    "zIndex": "1",
    "&::before": {
      "content": "\"\"",
      "boxShadow": "rgba(0, 0, 0, 0.2) 0 0 6px 0",
      "zIndex": "0",
      "height": "0.75rem",
      "position": "absolute",
      "visibility": "visible",
      "width": "0.8125rem",
      "top": "0",
      "left": "0",
      "right": "0",
      "bottom": "0"
    }
  }
}