export default {
  "tabs__tabMenu": {
    "display": "inline-flex",
    "width": "100%",
    "position": "relative"
  },
  "tabs__tabMenu__tabLink": {
    "backgroundColor": "#f7f8f9",
    "color": "#006fcf",
    "display": "flex",
    "alignItems": "center",
    "justifyContent": "center",
    "flex": "1",
    "flexDirection": "column",
    "padding": "1.25rem",
    "position": "relative",
    "textAlign": "center",
    "borderRight": "1px solid #ecedee",
    "transition": "all 0.25S cubic-bezier(0.65, 0, 0.45, 1)",
    "&:last-child": {
      "borderRight": "none"
    },
    "&::after": {
      "transition": "background-color 0.25S cubic-bezier(0.65, 0, 0.45, 1)",
      "content": "\"\"",
      "height": "0.25rem",
      "position": "absolute",
      "top": "-0.0625rem",
      "left": "-0.0625rem",
      "right": "-0.0625rem"
    },
    "&:hover": {
      "backgroundColor": "#ecedee",
      "color": "#0065bd"
    },
    "&:focus": {
      "backgroundColor": "#ecedee",
      "color": "#0065bd",
      "zIndex": "1",
      "outline": "dashed 1px #53565a !important",
      "outlineOffset": "-3px"
    }
  },
  "@media (prefers-reduced-motion)": {
    "tabs__tabMenu__tabLink": {
      "transition": "all 0s"
    }
  },
  "tabs__tabMenu__tabLink_all_children": {
    "width": "100%"
  },
  "tabs__tabMenu__tabLink_aria_selected_true": {
    "background": "#fff",
    "color": "#00175a",
    "pointerEvents": "auto",
    "&::after": {
      "backgroundColor": "#00175a"
    },
    "&:hover": {
      "backgroundColor": "#fff"
    },
    "&:focus": {
      "backgroundColor": "#fff"
    }
  },
  "tabs__tabContent": {
    "backgroundColor": "#fff",
    "display": "block",
    "width": "100%"
  },
  "tabs__tabContent__role_tabpanel": {
    "&:focus": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "3px"
    }
  },
  "@media (max-width: 767px)": {
    "tabs__tabMenu": {
      "flexDirection": "column"
    },
    "tabs__tabMenu__tabLink": {
      "width": "100%",
      "flexDirection": "row",
      "justifyContent": "flex-start",
      "alignItems": "flex-start",
      "textAlign": "left",
      "borderRight": "none",
      "padding": "0.6875rem 1.25rem !important",
      "borderBottom": "1px solid #ecedee",
      "&:last-child": {
        "borderBottom": "none"
      },
      "&::after": {
        "width": "0.25rem",
        "height": "calc(100% + 0.125rem)",
        "top": "-0.0625rem",
        "left": "-0.0625rem",
        "bottom": "-0.0625rem"
      }
    },
    "tabs__tabMenu__tabLink_span_icon": {
      "marginBottom": "0 !important",
      "marginRight": "0.625rem",
      "&::before": {
        "fontSize": "1.375rem"
      }
    },
    "tabs__tabMenu__tabLink_all_children": {
      "width": "auto"
    }
  }
}