export default {
  "slider": {
    "display": "flex",
    "alignItems": "center"
  },
  "sliderBar": {
    "position": "relative",
    "height": "1.5rem",
    "flex": "1",
    "marginLeft": "1.125rem",
    "marginRight": "1.125rem"
  },
  "sliderBtn": {
    "backgroundColor": "#fff",
    "border": "0.0625rem solid #8e9092",
    "borderRadius": "50%",
    "color": "#8e9092",
    "height": "1.375rem",
    "position": "relative",
    "transition": "background-color 0.25S ease-out, border-color 0.25S ease-out, box-shadow 0.25S ease-out",
    "width": "1.375rem",
    "willChange": "background-color, border-color, box-shadow",
    "&:hover": {
      "backgroundColor": "#006fcf",
      "borderColor": "#006fcf",
      "color": "#fff"
    },
    "&:focus": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "3px"
    },
    "&::before": {
      "fontSize": "0.825rem"
    }
  },
  "sliderBtn_disabled": {
    "&:hover": {
      "backgroundColor": "transparent",
      "borderColor": "#8e9092"
    }
  },
  "sliderButton": {
    "padding": "0.6875rem",
    "&:focus": {
      "outline": "none"
    },
    "&:focus span": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "3px"
    }
  },
  "sliderButton_disabled__span": {
    "backgroundColor": "#fff",
    "border": "0.0625rem solid #8e9092",
    "color": "#8e9092"
  },
  "sliderButton_disabled__i": {
    "backgroundColor": "#fff",
    "border": "0.0625rem solid #8e9092",
    "color": "#8e9092"
  },
  "sliderButtonStyles": {
    "backgroundColor": "#fff",
    "border": "0.0625rem solid #006fcf",
    "borderRadius": "50%",
    "color": "#006fcf",
    "height": "1.375rem",
    "position": "relative",
    "transition": "background-color 0.25S ease-out, border-color 0.25S ease-out, box-shadow 0.25S ease-out",
    "width": "1.375rem",
    "willChange": "background-color, border-color, box-shadow",
    "&:hover": {
      "backgroundColor": "#006fcf",
      "color": "#fff",
      "border": "0.0625rem solid #006fcf"
    },
    "&:focus": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "3px"
    },
    "&::before": {
      "fontSize": "0.825rem",
      "top": "0.25rem"
    }
  },
  "sliderButtonStyles_disabled": {
    "backgroundColor": "#fff",
    "border": "0.0625rem solid #8e9092",
    "color": "#8e9092",
    "&:hover": {
      "backgroundColor": "transparent",
      "borderColor": "#8e9092"
    }
  },
  "sliderTrack": {
    "backgroundColor": "#f7f8f9",
    "borderRadius": "8px",
    "boxShadow": "inset 0 0 0 0.0625rem #8e9092",
    "cursor": "pointer",
    "overflow": "hidden",
    "position": "absolute",
    "height": "1rem",
    "top": "0.25rem",
    "left": "-0.375rem",
    "right": "-0.375rem"
  },
  "sliderTrackActive": {
    "boxShadow": "inset 0 0 0 0.0625rem #006fcf"
  },
  "sliderSelection": {
    "backgroundColor": "#006fcf",
    "borderRadius": "8px",
    "position": "absolute",
    "willChange": "width",
    "bottom": "0",
    "height": "100%",
    "top": "0"
  },
  "sliderHandle": {
    "width": "1.375rem",
    "height": "1.375rem",
    "cursor": "pointer",
    "position": "relative",
    "willChange": "left",
    "borderRadius": "50%",
    "border": "0.0625rem solid #006fcf",
    "boxShadow": "0 0 5px rgba(83, 86, 90, 0.4)",
    "backgroundColor": "#fff",
    "&:hover": {
      "backgroundColor": "#fff"
    },
    "&:active": {
      "backgroundColor": "#fff"
    }
  },
  "sliderHandler": {
    "padding": "0.6875rem 2.0625rem 2.0625rem 0.6875rem",
    "marginTop": "-0.75rem",
    "&:focus": {
      "outline": "none"
    },
    "&:focus span": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "3px"
    }
  },
  "sliderHandlerStyles": {
    "width": "1.375rem",
    "height": "1.375rem",
    "display": "flex",
    "cursor": "pointer",
    "position": "relative",
    "willChange": "left",
    "borderRadius": "50%",
    "border": "0.0625rem solid #006fcf",
    "boxShadow": "0 0 5px rgba(83, 86, 90, 0.4)",
    "backgroundColor": "#fff",
    "outline": "0.0625rem solid #fff",
    "&:hover": {
      "backgroundColor": "#fff"
    },
    "&:active": {
      "backgroundColor": "#fff"
    }
  },
  "slider__tooltipContainer": {
    "position": "absolute",
    "width": "1.375rem",
    "height": "1.375rem",
    "top": "0.0625rem"
  },
  "slider__tooltipContainer__tooltipSlider": {
    "left": "95%"
  }
}