export default {
  "pagination": {
    "display": "flex",
    "alignContent": "center",
    "justifyContent": "space-around",
    "padding": "1rem 0.75rem",
    "backgroundColor": "#f7f8f9",
    "position": "relative",
    "WebkitUserSelect": "none",
    "MozUserSelect": "none",
    "userSelect": "none",
    "width": "100%",
    "minWidth": "17.75rem",
    "textAlign": "center"
  },
  "pagination_ul": {
    "listStyle": "none",
    "display": "inline-flex",
    "padding": "0"
  },
  "pagination_ul_first": {
    "width": "0",
    "overflow": "hidden"
  },
  "pagination_ul_last": {
    "width": "0",
    "overflow": "hidden"
  },
  "pagination__prev": {
    "color": "#006fcf",
    "&:hover:enabled": {
      "color": "#0065bd",
      "backgroundColor": "rgba(0, 0, 0, 0.05)",
      "textDecoration": "none"
    },
    "&:active:enabled": {
      "color": "#005aa8",
      "backgroundColor": "rgba(0, 0, 0, 0.1)",
      "textDecoration": "none"
    },
    "&:disabled > span": {
      "color": "#8e9092",
      "pointerEvents": "none"
    },
    "&:disabled > span.dlsGlyphLeft": {
      "color": "#c8c9c7"
    },
    "&:disabled > span.dlsGlyphRight": {
      "color": "#c8c9c7"
    }
  },
  "pagination__next": {
    "color": "#006fcf",
    "&:hover:enabled": {
      "color": "#0065bd",
      "backgroundColor": "rgba(0, 0, 0, 0.05)",
      "textDecoration": "none"
    },
    "&:active:enabled": {
      "color": "#005aa8",
      "backgroundColor": "rgba(0, 0, 0, 0.1)",
      "textDecoration": "none"
    },
    "&:disabled > span": {
      "color": "#8e9092",
      "pointerEvents": "none"
    },
    "&:disabled > span.dlsGlyphLeft": {
      "color": "#c8c9c7"
    },
    "&:disabled > span.dlsGlyphRight": {
      "color": "#c8c9c7"
    }
  },
  "pagination__prev_span": {
    "textOverflow": "clip"
  },
  "pagination__next_span": {
    "textOverflow": "clip"
  },
  "pagination__btnUtilityWrapper": {
    "&:hover:enabled": {
      "background": "none !important"
    },
    "&:active:enabled": {
      "background": "none !important"
    },
    "&:hover:enabled .btnUtility": {
      "color": "#0065bd",
      "backgroundColor": "rgba(0, 0, 0, 0.05)",
      "textDecoration": "none"
    },
    "&:active:enabled .btnUtility": {
      "color": "#005aa8",
      "backgroundColor": "rgba(0, 0, 0, 0.1)",
      "textDecoration": "none"
    },
    "&:disabled > .btnUtility": {
      "color": "#8e9092",
      "pointerEvents": "none",
      "border": "none"
    },
    "&:disabled > .btnUtility.dlsGlyphLeft": {
      "color": "#c8c9c7"
    },
    "&:disabled > .btnUtility.dlsGlyphRight": {
      "color": "#c8c9c7"
    }
  },
  "@media (min-width: 768px)": {
    "pagination__prev__dlsGlyphLeft": {
      "paddingRight": "0.625rem"
    },
    "pagination__next__dlsGlyphRight": {
      "paddingLeft": "0.625rem"
    },
    "paginationV2__prev__dlsGlyphLeft": {
      "paddingRight": "0.625rem"
    },
    "paginationV2__next__dlsGlyphRight": {
      "paddingLeft": "0.625rem"
    }
  },
  "@media screen and (max-width: 1024px)": {
    "pagination__pageList": {
      "marginLeft": "0.25rem !important",
      "marginRight": "0.25rem !important"
    },
    "paginationV2__pageList": {
      "marginLeft": "0.125rem !important",
      "marginRight": "0.125rem !important"
    }
  },
  "pagination__pageList": {
    "marginLeft": "0.5rem",
    "marginRight": "0.5rem",
    "display": "inline-flex",
    "position": "relative",
    "height": "2rem"
  },
  "pagination__pageList__pages": {
    "padding": "0 0",
    "width": "auto",
    "height": "100%",
    "position": "absolute",
    "left": "0",
    "transition": "left 0.33S"
  },
  "pagination__pageList__itemContainer": {
    "margin": "0 0.25rem",
    "&:focus": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "3px"
    },
    "&:not(.current):hover .item": {
      "textDecoration": "underline"
    }
  },
  "pagination__pageList__itemContainer_current": {
    "zIndex": "2"
  },
  "pagination__pageList__itemContainer_current__item": {
    "color": "#fff",
    "textDecoration": "none"
  },
  "pagination__pageList__item": {
    "width": "2rem",
    "height": "2rem",
    "minWidth": "2rem",
    "lineHeight": "2rem",
    "textAlign": "center",
    "cursor": "pointer",
    "color": "#006fcf",
    "transition": "color 0.33S, opacity 0.33S, visibility 0.33S",
    "display": "inline-block",
    "padding": "6px 6px",
    "boxSizing": "content-box",
    "textDecoration": "none",
    "&:hover": {
      "color": "#0065bd"
    },
    "&:active": {
      "color": "#005aa8"
    }
  },
  "pagination__pageList__item_invisible": {
    "opacity": "0"
  },
  "pagination__pageList__item_first": {
    "margin": "0 0.25rem",
    "position": "absolute",
    "transition": "opacity 0s",
    "zIndex": "1",
    "&:hover": {
      "backgroundColor": "#ecedee",
      "textDecoration": "underline"
    },
    "left": "0"
  },
  "pagination__pageList__item_afterFirst": {
    "margin": "0 0.25rem",
    "position": "absolute",
    "transition": "opacity 0s",
    "zIndex": "1",
    "left": "2.5rem",
    "cursor": "auto",
    "color": "#53565a",
    "textDecoration": "none"
  },
  "pagination__pageList__item_beforeLast": {
    "margin": "0 0.25rem",
    "position": "absolute",
    "transition": "opacity 0s",
    "zIndex": "1",
    "right": "3.25rem",
    "cursor": "auto",
    "color": "#53565a",
    "textDecoration": "none"
  },
  "pagination__pageList__item_last": {
    "margin": "0 0.25rem",
    "position": "absolute",
    "transition": "opacity 0s",
    "zIndex": "1",
    "&:hover": {
      "backgroundColor": "#ecedee",
      "textDecoration": "underline"
    },
    "right": "0"
  },
  "pagination__selector": {
    "position": "absolute",
    "width": "1.375rem",
    "height": "1.375rem",
    "borderRadius": "0.2rem",
    "backgroundColor": "#006fcf",
    "zIndex": "1",
    "transition": "left 0.33S",
    "padding": "0.6875rem 0.6875rem",
    "boxSizing": "content-box"
  },
  "paginationV2": {
    "display": "flex",
    "alignContent": "center",
    "justifyContent": "center",
    "padding": "1rem 0.75rem",
    "backgroundColor": "#f7f8f9",
    "position": "relative",
    "WebkitUserSelect": "none",
    "MozUserSelect": "none",
    "userSelect": "none",
    "width": "100%",
    "minWidth": "17.75rem",
    "textAlign": "center"
  },
  "paginationV2_ul": {
    "listStyle": "none",
    "display": "inline-flex",
    "padding": "0"
  },
  "paginationV2_ul_first": {
    "width": "0",
    "overflow": "hidden"
  },
  "paginationV2_ul_last": {
    "width": "0",
    "overflow": "hidden"
  },
  "paginationV2__prev": {
    "color": "#006fcf",
    "&:hover:enabled": {
      "color": "#0065bd",
      "backgroundColor": "rgba(0, 0, 0, 0.05)",
      "textDecoration": "none"
    },
    "&:active:enabled": {
      "color": "#005aa8",
      "backgroundColor": "rgba(0, 0, 0, 0.1)",
      "textDecoration": "none"
    },
    "&:disabled > span": {
      "color": "#8e9092",
      "backgroundColor": "unset",
      "pointerEvents": "none"
    },
    "&:disabled > span.dlsGlyphLeft": {
      "color": "#c8c9c7"
    },
    "&:disabled > span.dlsGlyphRight": {
      "color": "#c8c9c7"
    }
  },
  "paginationV2__next": {
    "color": "#006fcf",
    "&:hover:enabled": {
      "color": "#0065bd",
      "backgroundColor": "rgba(0, 0, 0, 0.05)",
      "textDecoration": "none"
    },
    "&:active:enabled": {
      "color": "#005aa8",
      "backgroundColor": "rgba(0, 0, 0, 0.1)",
      "textDecoration": "none"
    },
    "&:disabled > span": {
      "color": "#8e9092",
      "backgroundColor": "unset",
      "pointerEvents": "none"
    },
    "&:disabled > span.dlsGlyphLeft": {
      "color": "#c8c9c7"
    },
    "&:disabled > span.dlsGlyphRight": {
      "color": "#c8c9c7"
    }
  },
  "paginationV2__prev_span": {
    "textOverflow": "clip"
  },
  "paginationV2__next_span": {
    "textOverflow": "clip"
  },
  "paginationV2__btnUtilityWrapper": {
    "&:hover:enabled": {
      "background": "none !important"
    },
    "&:active:enabled": {
      "background": "none !important"
    },
    "&:hover:enabled .btnUtility": {
      "color": "#0065bd",
      "backgroundColor": "rgba(0, 0, 0, 0.05)",
      "textDecoration": "none"
    },
    "&:active:enabled .btnUtility": {
      "color": "#005aa8",
      "backgroundColor": "rgba(0, 0, 0, 0.1)",
      "textDecoration": "none"
    },
    "&:disabled > .btnUtility": {
      "color": "#8e9092",
      "pointerEvents": "none",
      "border": "none"
    },
    "&:disabled > .btnUtility.dlsGlyphLeft": {
      "color": "#c8c9c7"
    },
    "&:disabled > .btnUtility.dlsGlyphRight": {
      "color": "#c8c9c7"
    }
  },
  "paginationV2__pageList": {
    "marginLeft": "0.25rem",
    "marginRight": "0.25rem",
    "display": "flex",
    "position": "relative",
    "height": "2rem",
    "justifyContent": "center"
  },
  "paginationV2__pageList__pages": {
    "padding": "0",
    "width": "auto",
    "height": "100%",
    "position": "relative"
  },
  "paginationV2__pageList__itemContainer": {
    "margin": "0 0.25rem",
    "&:focus": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "3px"
    }
  },
  "paginationV2__pageList__itemContainer___a": {
    "textDecoration": "underline",
    "&:hover > span": {
      "color": "#0065bd"
    },
    "&:active > span": {
      "color": "#005aa8"
    }
  },
  "paginationV2__pageList__itemContainer___button": {
    "&:hover > span": {
      "color": "#0065bd",
      "backgroundColor": "rgba(0, 0, 0, 0.05)"
    },
    "&:active > span": {
      "color": "#005aa8",
      "backgroundColor": "rgba(0, 0, 0, 0.1)"
    }
  },
  "paginationV2__pageList__itemContainer_current_a": {
    "color": "#fff"
  },
  "paginationV2__pageList__itemContainer_current_a___span": {
    "color": "#fff",
    "backgroundColor": "#006fcf"
  },
  "paginationV2__pageList__itemContainer_current_button___span": {
    "color": "#fff",
    "backgroundColor": "#006fcf"
  },
  "paginationV2__pageList__itemContainer_current_button": {
    "&:hover > span": {
      "color": "#fff",
      "backgroundColor": "#0065bd"
    },
    "&:active > span": {
      "color": "#fff",
      "backgroundColor": "#005aa8"
    }
  },
  "paginationV2__pageList__item": {
    "display": "flex",
    "alignItems": "center",
    "justifyContent": "center",
    "cursor": "pointer",
    "borderRadius": "0.375rem",
    "outlineOffset": "-3px",
    "padding": "0.375rem",
    "width": "2.75rem",
    "&:hover": {
      "color": "#0065bd"
    },
    "&:active": {
      "color": "#005aa8"
    }
  },
  "paginationV2__pageList__item___span": {
    "width": "2rem",
    "height": "2rem",
    "minWidth": "2rem",
    "lineHeight": "2rem",
    "color": "#006fcf",
    "borderRadius": "0.375rem",
    "textAlign": "center"
  },
  "paginationV2__pageList__item_invisible": {
    "opacity": "0"
  },
  "paginationV2__pageList__item_first": {
    "margin": "0 0.25rem",
    "position": "relative",
    "transition": "opacity 0s",
    "&:hover": {
      "textDecoration": "underline"
    }
  },
  "paginationV2__pageList__item_afterFirst": {
    "margin": "0",
    "position": "relative",
    "transition": "opacity 0s",
    "cursor": "auto",
    "color": "#53565a",
    "padding": "0",
    "textDecoration": "none",
    "alignItems": "flex-end",
    "justifyContent": "center",
    "minWidth": "unset",
    "width": "1rem"
  },
  "paginationV2__pageList__item_beforeLast": {
    "margin": "0",
    "position": "relative",
    "transition": "opacity 0s",
    "cursor": "auto",
    "color": "#53565a",
    "padding": "0",
    "textDecoration": "none",
    "alignItems": "flex-end",
    "justifyContent": "center",
    "minWidth": "unset",
    "width": "1rem"
  },
  "paginationV2__pageList__item_last": {
    "margin": "0 0.25rem",
    "position": "relative",
    "transition": "opacity 0s",
    "&:hover": {
      "textDecoration": "underline"
    }
  },
  "@media (min-width: 375px)": {
    "paginationV2__pageList__item_afterFirst": {
      "width": "2.75rem"
    },
    "paginationV2__pageList__item_beforeLast": {
      "width": "2.75rem"
    }
  },
  "paginationV2__selector": {
    "display": "none"
  },
  "@media (max-width: 374px)": {
    "pagination__pageList": {
      "margin": "0 0.1875rem"
    },
    "pagination__pageList__itemContainer": {
      "margin": "0 0.1875rem"
    },
    "pagination__pageList__item_afterFirst": {
      "width": "1.5rem",
      "minWidth": "1.5rem",
      "margin": "0",
      "left": "2.1875rem"
    },
    "pagination__pageList__item_beforeLast": {
      "width": "1.5rem",
      "minWidth": "1.5rem",
      "margin": "0",
      "right": "2.1875rem"
    },
    "paginationV2__pageList": {
      "margin": "0 0.1875rem"
    },
    "paginationV2__pageList__itemContainer": {
      "margin": "0 0.1875rem"
    },
    "paginationV2__pageList__item_afterFirst": {
      "width": "1.5rem",
      "minWidth": "1.5rem",
      "margin": "0",
      "left": "2.1875rem"
    },
    "paginationV2__pageList__item_beforeLast": {
      "width": "1.5rem",
      "minWidth": "1.5rem",
      "margin": "0",
      "right": "2.1875rem"
    }
  }
}