export default {
  "multiselect": {
    "maxWidth": "18.75rem",
    "overflow": "hidden",
    "position": "relative",
    "cursor": "arrow",
    "&::after": {
      "fontFamily": "\"dls-icons-2.31.4\"",
      "content": "\"\\eaf6\"",
      "lineHeight": "1",
      "WebkitFontSmoothing": "antialiased",
      "MozOsxFontSmoothing": "grayscale",
      "color": "#53565a",
      "fontSize": "1rem",
      "display": "flex",
      "alignItems": "center",
      "position": "absolute",
      "top": "0",
      "bottom": "0",
      "right": "0",
      "margin": "auto 0.5rem",
      "transition": "color 0.25S ease-out"
    },
    "&:focus-within": {
      "borderColor": "#006fcf"
    }
  },
  "multiselect_select": {
    "display": "inline",
    "appearance": "none",
    "MozAppearance": "none",
    "WebkitAppearance": "none",
    "background": "transparent",
    "backgroundImage": "none",
    "border": "0",
    "cursor": "pointer",
    "fontSize": "1rem",
    "zIndex": "-1",
    "paddingRight": "1.625rem",
    "&::-ms-expand": {
      "display": "none"
    },
    "&:focus": {
      "outline": "none"
    },
    "&:active": {
      "outline": "none"
    },
    "&::-moz-focus-inner": {
      "border": "0",
      "outline": "none"
    },
    "&:-moz-focusring": {
      "color": "transparent",
      "textShadow": "0 0 0 #000"
    }
  },
  "multiselect_disabled": {
    "color": "#c8c9c7",
    "&::after": {
      "color": "#c8c9c7"
    }
  },
  "multiselect_formControl": {
    "display": "flex",
    "flexWrap": "wrap",
    "padding": "0.625rem",
    "alignItems": "center"
  },
  "multiselect_formControlSuccess": {
    "paddingRight": "0.625rem",
    "backgroundColor": "#f7f8f9",
    "backgroundImage": "none"
  },
  "multiselect_formControlWarning": {
    "paddingRight": "0.625rem",
    "backgroundColor": "#f7f8f9",
    "backgroundImage": "none",
    "&::before": {
      "color": "#53565a"
    },
    "&::after": {
      "color": "#53565a"
    }
  },
  "multiselectIcon": {
    "height": "0.6875rem",
    "position": "absolute",
    "width": "1rem"
  },
  "multiselectIcon___select": {
    "paddingLeft": "1.875rem"
  },
  "multiselect_aria_expanded_true": {
    "borderColor": "#006fcf",
    "&::after": {
      "transform": "rotate(180deg)"
    }
  },
  "multiselectOptions": {
    "cursor": "pointer",
    "backgroundColor": "#fff",
    "borderRadius": "0.25rem",
    "marginTop": "0.3125rem",
    "maxWidth": "18.75rem",
    "maxHeight": "15.34rem",
    "position": "absolute",
    "overflowY": "scroll",
    "zIndex": "99",
    "width": "100%"
  },
  "multiselectOptions__checkbox": {
    "cursor": "pointer",
    "padding": "0",
    "&:hover": {
      "backgroundColor": "#ecedee"
    }
  },
  "multiselectOptions__checkbox_input_type_checkbox": {
    "&:focus + label": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "-3px",
      "width": "100%"
    },
    "&:focus + label::before": {
      "outline": "none"
    }
  }
}