export default {
  "hero": {
    "height": "auto",
    "minHeight": "22.25rem",
    "maxWidth": "80rem",
    "position": "relative",
    "textAlign": "left"
  },
  "heroBg": {
    "backgroundPosition": "right center",
    "backgroundSize": "cover",
    "bottom": "0",
    "left": "0",
    "position": "absolute",
    "right": "0",
    "top": "0",
    "zIndex": "-1"
  },
  "@media (max-width: 767px)": {
    "hero": {
      "textAlign": "center"
    },
    "heroBg": {
      "backgroundPosition": "center"
    },
    "overlayBlue": {
      "&::before": {
        "content": "\"\"",
        "bottom": "0",
        "left": "0",
        "position": "absolute",
        "right": "0",
        "top": "0",
        "opacity": "0.7",
        "background": "linear-gradient(to right, #00175a 100%, rgba(0, 23, 90, 0) 100%)"
      }
    },
    "overlayBlack": {
      "&::before": {
        "content": "\"\"",
        "bottom": "0",
        "left": "0",
        "position": "absolute",
        "right": "0",
        "top": "0",
        "opacity": "0.7",
        "background": "linear-gradient(to right, black 100%, rgba(0, 0, 0, 0) 100%)"
      }
    },
    "overlayWhite": {
      "&::before": {
        "content": "\"\"",
        "bottom": "0",
        "left": "0",
        "position": "absolute",
        "right": "0",
        "top": "0",
        "opacity": "0.8",
        "background": "linear-gradient(to right, white 100%, rgba(255, 255, 255, 0) 100%)"
      }
    },
    "overlayGray": {
      "&::before": {
        "content": "\"\"",
        "bottom": "0",
        "left": "0",
        "position": "absolute",
        "right": "0",
        "top": "0",
        "opacity": "0.8",
        "background": "linear-gradient(to right, #ecedee 100%, rgba(236, 237, 238, 0) 100%)"
      }
    }
  },
  "heroLogin": {
    "backgroundColor": "#fff",
    "maxWidth": "19.6875rem"
  },
  "@media (min-width: 768px)": {
    "heroLogin": {
      "width": "19.6875rem"
    }
  },
  "heroTagline": {
    "width": "18.75rem"
  },
  "heroTextOverlay": {
    "backgroundColor": "rgba(255, 255, 255, 0.9)"
  },
  "overlayBlue": {
    "&::before": {
      "content": "\"\"",
      "bottom": "0",
      "left": "0",
      "position": "absolute",
      "right": "0",
      "top": "0",
      "background": "linear-gradient(to right, #00175a 0%, rgba(0, 23, 90, 0) 100%)"
    }
  },
  "overlayBlack": {
    "&::before": {
      "content": "\"\"",
      "bottom": "0",
      "left": "0",
      "position": "absolute",
      "right": "0",
      "top": "0",
      "background": "linear-gradient(to right, black 0%, rgba(0, 0, 0, 0) 100%)"
    }
  },
  "overlayWhite": {
    "&::before": {
      "content": "\"\"",
      "bottom": "0",
      "left": "0",
      "position": "absolute",
      "right": "0",
      "top": "0",
      "background": "linear-gradient(to right, white 0%, rgba(255, 255, 255, 0) 100%)"
    }
  },
  "overlayGray": {
    "&::before": {
      "content": "\"\"",
      "bottom": "0",
      "left": "0",
      "position": "absolute",
      "right": "0",
      "top": "0",
      "background": "linear-gradient(to right, #ecedee 0%, rgba(236, 237, 238, 0) 100%)"
    }
  },
  "@media (max-width: 1023px)": {
    "overlayBlue": {
      "&::before": {
        "content": "\"\"",
        "bottom": "0",
        "left": "0",
        "position": "absolute",
        "right": "0",
        "top": "0",
        "background": "linear-gradient(to right, #00175a 0%, rgba(0, 23, 90, 0) 100%)"
      }
    },
    "overlayBlack": {
      "&::before": {
        "content": "\"\"",
        "bottom": "0",
        "left": "0",
        "position": "absolute",
        "right": "0",
        "top": "0",
        "background": "linear-gradient(to right, black 0%, rgba(0, 0, 0, 0) 100%)"
      }
    },
    "overlayWhite": {
      "&::before": {
        "content": "\"\"",
        "bottom": "0",
        "left": "0",
        "position": "absolute",
        "right": "0",
        "top": "0",
        "background": "linear-gradient(to right, white 0%, rgba(255, 255, 255, 0) 100%)"
      }
    },
    "overlayGray": {
      "&::before": {
        "content": "\"\"",
        "bottom": "0",
        "left": "0",
        "position": "absolute",
        "right": "0",
        "top": "0",
        "background": "linear-gradient(to right, #ecedee 0%, rgba(236, 237, 238, 0) 100%)"
      }
    }
  }
}