export default {
  "filter": {
    "background": "#fff",
    "minWidth": "19.625rem",
    "position": "absolute",
    "top": "0",
    "zIndex": "98"
  },
  "@media (max-width: 375px)": {
    "filter": {
      "minWidth": "unset"
    }
  },
  "filterContainer": {
    "display": "inline-block",
    "position": "relative"
  },
  "filterButton": {
    "display": "inline-block",
    "padding": "0.4375rem 0.375rem"
  },
  "filterButton_button": {
    "padding": "0.5rem 0.5rem",
    "&:focus": {
      "outlineOffset": "0 !important"
    }
  },
  "filter_positionStaticMdUp__filterHeader": {
    "paddingLeft": "0.625rem !important",
    "paddingRight": "0.375rem !important"
  },
  "filter__filterHeader": {
    "lineHeight": "1.75rem",
    "padding": "0.4375rem 0.375rem"
  },
  "filter__filterHeader_button_data_close": {
    "padding": "0.5rem",
    "&:focus": {
      "outlineOffset": "0 !important"
    }
  },
  "filter__filterHeader_button_data_reset": {
    "padding": "0.5rem",
    "&:focus": {
      "outlineOffset": "0 !important"
    }
  },
  "filter__filterHeader_button_data_back": {
    "padding": "0.5rem",
    "&:focus": {
      "outlineOffset": "0 !important"
    }
  },
  "filter__pad": {
    "paddingTop": "1.125rem !important",
    "paddingBottom": "1.125rem !important"
  },
  "filter_ul": {
    "listStyle": "none",
    "paddingLeft": "0"
  },
  "filter__filterMenu": {
    "height": "100%",
    "maxHeight": "26.25rem",
    "overflowY": "scroll",
    "overflowX": "hidden",
    "position": "relative"
  },
  "filter__filterMenu_li_button_filterItem": {
    "padding": "0.6875rem 1.25rem !important"
  },
  "filter__filterMenu__filterItem": {
    "position": "relative",
    "display": "flex",
    "padding": "0 !important",
    "textAlign": "left",
    "width": "100%",
    "cursor": "pointer",
    "&:hover": {
      "background": "#f7f8f9"
    },
    "&:active": {
      "backgroundColor": "#ecedee"
    },
    "&:focus": {
      "outlineOffset": "-0.125rem",
      "outline": "1px dashed #53565a !important"
    }
  },
  "filter__filterMenu__filterItem_span": {
    "paddingTop": "0.6875rem",
    "paddingBottom": "0.6875rem"
  },
  "filter__filterMenu__filterItem_button": {
    "padding": "0 1.25rem",
    "&:focus": {
      "outlineOffset": "-0.125rem"
    }
  },
  "filter__filterMenu__filterItem_aria_selected_true": {
    "backgroundColor": "#ecedee",
    "&::after": {
      "content": "\"\"",
      "backgroundImage": "url('data:image/svg+xml;utf8,<svg fill=\"%23008767\" viewBox=\"0 0 16 16\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M5.978 10.52l-3.25-3.442a1 1 0 10-1.455 1.373l4 4.236a1 1 0 001.475-.023l8-9a1 1 0 00-1.495-1.328L5.978 10.52z\"/></svg>')",
      "lineHeight": "1rem",
      "position": "absolute",
      "top": "14px",
      "right": "14px",
      "height": "14px",
      "width": "14px"
    }
  },
  "filter__filterMenu__filterItem__checkbox": {
    "width": "100%",
    "paddingLeft": "1.25rem"
  },
  "filter__filterMenu__filterItem__checkbox_label": {
    "width": "100%"
  },
  "filter__filterMenu__filterItem__checkbox_input_type_checkbox": {
    "&:focus + label": {
      "outlineOffset": "-0.125rem"
    }
  },
  "filter__filterMenu__filterChecklist": {
    "display": "block"
  },
  "filter__filterMenu__filterChecklist__checkbox": {
    "paddingLeft": "2.5rem"
  },
  "filter__filterMenu__subFilter": {
    "background": "#fff",
    "position": "absolute",
    "top": "0",
    "width": "100%",
    "transition": "right 0.75S ease-out"
  },
  "@media (prefers-reduced-motion)": {
    "filter__filterMenu__subFilter": {
      "transition": "right 0s"
    }
  },
  "filter__filterHide": {
    "right": "-100%"
  },
  "filter__filterShow": {
    "right": "0"
  },
  "@media (max-width: 767px)": {
    "filterContainer": {
      "display": "block"
    },
    "filter": {
      "left": "0",
      "right": "0",
      "width": "100%"
    }
  }
}