export default {
  "dlsCardTilt": {
    "boxSizing": "content-box",
    "margin": "0 auto",
    "paddingBottom": "1.875rem",
    "perspective": "600px",
    "visibility": "hidden"
  },
  "dlsCardTilt__dlsCardTiltLeft": {
    "bottom": "0",
    "display": "block",
    "position": "absolute",
    "top": "0",
    "visibility": "visible",
    "width": "50%",
    "zIndex": "1",
    "left": "0",
    "&:hover + .dlsCardTiltRight + .dlsCardTiltContainer": {
      "transform": "rotateY(-30deg)"
    },
    "&:hover + .dlsCardTiltRight + .dlsCardTiltContainer::before": {
      "transform": "translateX(25%)"
    }
  },
  "dlsCardTilt__dlsCardTiltRight": {
    "bottom": "0",
    "display": "block",
    "position": "absolute",
    "top": "0",
    "visibility": "visible",
    "width": "50%",
    "zIndex": "1",
    "right": "0",
    "&:hover + .dlsCardTiltContainer": {
      "transform": "rotateY(30deg)"
    },
    "&:hover + .dlsCardTiltContainer::before": {
      "transform": "translateX(-25%)"
    }
  },
  "dlsCardTilt__dlsCardTiltContainer": {
    "position": "relative",
    "width": "100%",
    "height": "100%",
    "boxSizing": "content-box",
    "backgroundSize": "contain",
    "backgroundImage": "inherit",
    "visibility": "visible",
    "transition": "transform 0.8S ease-out",
    "&::before": {
      "background": "linear-gradient(to right, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 0.25) 45%, rgba(255, 255, 255, 0.25) 55%, rgba(255, 255, 255, 0) 100%)",
      "bottom": "0",
      "content": "\"\"",
      "display": "block",
      "left": "0",
      "margin": "0 auto",
      "position": "absolute",
      "right": "0",
      "top": "0",
      "transition": "transform 0.8S ease-out",
      "width": "60%"
    },
    "&::after": {
      "background": "radial-gradient(ellipse at center, rgba(0, 0, 0, 0.13) 0%, rgba(0, 0, 0, 0) 75%)",
      "bottom": "-1.40625rem",
      "content": "\"\"",
      "display": "block",
      "height": "0.9375rem",
      "left": "0",
      "position": "absolute",
      "right": "0"
    }
  },
  "@media (prefers-reduced-motion)": {
    "dlsCardTilt__dlsCardTiltContainer": {
      "transition": "transform 0s",
      "&::before": {
        "transition": "transform 0s"
      }
    }
  }
}