export default {
  "collapsible": {
    "cursor": "pointer",
    "padding": "15px 20px",
    "textAlign": "left",
    "transition": "background-color 0.25S ease-in-out",
    "width": "100%",
    "wordWrap": "break-word",
    "wordBreak": "break-word",
    "overflowWrap": "anywhere",
    "&:hover:not(.expandableLink)": {
      "backgroundColor": "rgba(151, 153, 155, 0.08)"
    },
    "&:focus": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "-3px"
    }
  },
  "@media (prefers-reduced-motion)": {
    "collapsible": {
      "transition": "background-color 0s"
    },
    "collapsibleCaret": {
      "&::before": {
        "transition": "color 0.25S ease-out, transform 0s"
      }
    },
    "collapsible_i": {
      "transition": "color 0.25S ease-out, transform 0s"
    },
    "accordionContent": {
      "transition": "max-height 0s"
    }
  },
  "collapsible__icon": {
    "color": "#006fcf"
  },
  "collapsibleCaret": {
    "color": "#53565a",
    "paddingRight": "10px",
    "verticalAlign": "text-top",
    "display": "inline-flex",
    "flexShrink": "0",
    "&::before": {
      "backgroundImage": "url('data:image/svg+xml;utf8,<svg fill=\"%2353565A\" viewBox=\"0 0 16 16\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M11.709 7.294L5.705 1.29a1.002 1.002 0 00-1.413 0 1.001 1.001 0 000 1.413L9.59 8l-5.298 5.296a1.001 1.001 0 000 1.413 1.002 1.002 0 001.413 0l6.004-6.003a1.001 1.001 0 000-1.412z\"/></svg>')",
      "backgroundPosition": "center center",
      "backgroundRepeat": "no-repeat",
      "content": "\"\"",
      "width": "1rem",
      "height": "1rem",
      "display": "inline-block",
      "position": "relative",
      "transform": "rotate(0deg)",
      "transition": "color 0.25S ease-out, transform 0.25S ease-out",
      "lineHeight": "1.375rem"
    }
  },
  "collapsible_i": {
    "transform": "rotate(0deg)",
    "transition": "color 0.25S ease-out, transform 0.25S ease-out"
  },
  "collapsible_aria_expanded_true": {
    "color": "#00175a"
  },
  "collapsible_aria_expanded_true___icon": {
    "color": "#00175a"
  },
  "collapsible_aria_expanded_true___collapsibleCaret": {
    "&::before": {
      "transform": "rotate(90deg)"
    }
  },
  "collapsible_aria_expanded_true__svg_data_dls_icon_variant_outline": {
    "display": "none"
  },
  "collapsible_aria_expanded_true__svg_data_dls_icon_variant_filled": {
    "display": "inherit"
  },
  "collapsible_all_children": {
    "&:last-child": {
      "flexBasis": "100%"
    }
  },
  "collapsible_expandableLink": {
    "color": "#333",
    "&:hover": {
      "cursor": "auto"
    }
  },
  "accordionContent": {
    "margin": "0",
    "overflow": "hidden",
    "transition": "max-height 0.4S ease-out"
  },
  "@media (min-width: 768px)": {
    "accordionContent__stack": {
      "marginTop": "1.25rem"
    }
  },
  "accordionContent__stack__textLink": {
    "paddingTop": "0.6875rem",
    "paddingBottom": "0.6875rem",
    "marginBottom": "0",
    "&:first-child": {
      "marginTop": "-1.25rem"
    }
  },
  "toggleLink": {
    "color": "#006fcf",
    "&:hover": {
      "textDecoration": "underline"
    }
  },
  "button_collapsible": {
    "display": "inline-flex",
    "alignItems": "flex-start"
  },
  "button_collapsible_all_children": {
    "pointerEvents": "none"
  }
}