export default {
  "carousel": {
    "display": "flex",
    "flexFlow": "column nowrap",
    "overflow": "hidden",
    "position": "relative",
    "&:not([data-animate=false]) .carouselItemPrev": {
      "flexGrow": "1",
      "flexShrink": "0",
      "height": "auto",
      "minWidth": "100%",
      "width": "100%",
      "listStyleType": "none",
      "bottom": "0",
      "left": "0",
      "position": "absolute",
      "right": "0",
      "top": "0",
      "zIndex": "0",
      "visibility": "visible"
    },
    "&:not([data-animate=false]) .carouselItemPrev *": {
      "animation": "none",
      "transition": "none"
    }
  },
  "carouselInner": {
    "minHeight": "22.25rem",
    "backgroundColor": "#f7f8f9",
    "display": "flex",
    "flex": "1 0 auto",
    "flexFlow": "row nowrap",
    "overflow": "hidden",
    "position": "relative",
    "padding": "0"
  },
  "carouselInner_li": {
    "padding": "2.5rem 2.5rem 3.75rem 2.5rem"
  },
  "carouselInnerPadding_li": {
    "padding": "2.5rem 2.5rem 3.375rem 2.5rem"
  },
  "carouselControls": {
    "display": "flex",
    "zIndex": "2",
    "position": "absolute",
    "width": "100%",
    "justifyContent": "center",
    "bottom": "0",
    "height": "2.75rem",
    "&:not(.carouselMultiCard .carouselControls)": {
      "marginBottom": "0.625rem"
    }
  },
  "@media (min-width: 768px)": {
    "carouselManual__carouselControls": {
      "&:not(.carouselMultiCard .carouselControls)": {
        "marginBottom": "0"
      },
      "height": "100%",
      "position": "unset",
      "justifyContent": "unset",
      "pointerEvents": "none"
    },
    "carouselManual__carouselInner_li": {
      "paddingLeft": "6.75rem",
      "paddingRight": "6.75rem"
    },
    "carouselManual__carouselTextOverlay___div": {
      "marginLeft": "2.75rem"
    },
    "carouselManual__carouselIndicators": {
      "backgroundColor": "rgba(0, 0, 0, 0.6)",
      "padding": "0.8125rem",
      "position": "absolute",
      "bottom": "0.625rem",
      "borderRadius": "0.25rem",
      "left": "50%",
      "transform": "translateX(-50%)"
    },
    "carouselManual__carouselControl": {
      "backgroundColor": "rgba(0, 0, 0, 0.6)",
      "&:hover": {
        "backgroundColor": "rgba(0, 0, 0, 0.6)"
      },
      "fontSize": "1.75rem",
      "top": "50%",
      "transform": "translateY(-50%)",
      "&:first-of-type": {
        "borderRadius": "0 0.25rem 0.25rem 0"
      },
      "&:last-of-type": {
        "borderRadius": "0.25rem 0 0 0.25rem"
      },
      "padding": "0.5rem",
      "position": "absolute"
    },
    "carouselManual__carouselControls_darkControls__carouselControl": {
      "color": "#fff"
    },
    "carouselManual__carouselControls_darkControls__carouselIndicators_li": {
      "&::before": {
        "backgroundColor": "#c8c9c7"
      },
      "&:focus::before": {
        "backgroundColor": "#fff"
      },
      "&:hover::before": {
        "backgroundColor": "#fff"
      }
    },
    "carouselManual__carouselControls_darkControls__carouselIndicators_li_aria_current": {
      "&::before": {
        "backgroundColor": "#006fcf",
        "height": "0.75rem",
        "width": "0.75rem"
      },
      "padding": "0.1875rem 0.3125rem"
    },
    "carouselMultiCard__carouselInner_li": {
      "padding": "1.875rem 3rem 4rem 3rem"
    },
    "carouselMultiCard__carouselControls": {
      "height": "100%",
      "position": "unset",
      "justifyContent": "unset",
      "pointerEvents": "none"
    },
    "carouselManual__carouselControls_all_children": {
      "pointerEvents": "auto"
    },
    "carouselMultiCard__carouselControls_all_children": {
      "pointerEvents": "auto"
    },
    "carouselMultiCard__carouselControl": {
      "fontSize": "1.75rem",
      "top": "50%",
      "transform": "translateY(-50%)",
      "&:first-of-type": {
        "borderRadius": "0 0.25rem 0.25rem 0"
      },
      "&:last-of-type": {
        "borderRadius": "0.25rem 0 0 0.25rem"
      },
      "padding": "0.5rem",
      "position": "absolute"
    },
    "carouselMultiCard__carouselIndicators": {
      "padding": "0.8125rem",
      "position": "absolute",
      "bottom": "0.625rem",
      "borderRadius": "0.25rem",
      "left": "50%",
      "transform": "translateX(-50%)"
    }
  },
  "carouselControls_darkControls__carouselIndicators_li": {
    "&::before": {
      "backgroundColor": "#8e9092"
    }
  },
  "carouselControls_darkControls__carouselIndicators_li_aria_current": {
    "&::before": {
      "backgroundColor": "#006fcf !important"
    }
  },
  "carousel__carouselControls_darkControls__carouselControl": {
    "color": "#53565a",
    "backgroundColor": "transparent",
    "&:focus": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "-3px"
    }
  },
  "carousel__carouselControls_darkControls__carouselIndicators": {
    "backgroundColor": "transparent"
  },
  "carousel__carouselControls_darkControls__carouselIndicators_li___button": {
    "&::before": {
      "backgroundColor": "#8e9092"
    }
  },
  "carousel__carouselControls_darkControls__carouselIndicators_li___button_aria_current": {
    "&::before": {
      "backgroundColor": "#006fcf",
      "height": "0.75rem",
      "width": "0.75rem"
    },
    "padding": "0.1875rem 0.3125rem"
  },
  "carouselControl": {
    "color": "#fff",
    "zIndex": "1",
    "lineHeight": "1",
    "textDecoration": "none !important",
    "transition": "color 0.2S ease-in-out, opacity 0.2S ease-in-out",
    "paddingLeft": "0.90625rem",
    "paddingRight": "0.90625rem",
    "display": "flex",
    "alignItems": "center",
    "backgroundColor": "rgba(0, 0, 0, 0.6)",
    "&:not(.carouselSmall .carouselControl, .carouselMultiCard .carouselControl, .carouselManual .carouselControl)": {
      "background": "rgba(0, 0, 0, 0.6)",
      "color": "#fff"
    },
    "&:not(.carouselSmall .carouselControl, .carouselMultiCard .carouselControl, .carouselManual .carouselControl):first-of-type": {
      "borderRadius": "0.25rem 0 0 0.25rem"
    },
    "&:not(.carouselSmall .carouselControl, .carouselMultiCard .carouselControl, .carouselManual .carouselControl):last-of-type": {
      "borderRadius": "0 0.25rem 0.25rem 0"
    },
    "&:not(.carouselSmall .carouselControl, .carouselMultiCard .carouselControl, .carouselManual .carouselControl):nth-of-type(2)": {
      "borderRadius": "0 0.25rem 0.25rem 0"
    },
    "&:not(.carouselSmall .carouselControl, .carouselMultiCard .carouselControl, .carouselManual .carouselControl):nth-of-type(3)": {
      "borderRadius": "0.25rem",
      "paddingLeft": "0.6875rem",
      "paddingRight": "0.6875rem"
    },
    "&:not(.carouselSmall .carouselControl, .carouselMultiCard .carouselControl, .carouselManual .carouselControl):nth-of-type(4)": {
      "borderRadius": "0.25rem",
      "paddingLeft": "0.6875rem",
      "paddingRight": "0.6875rem"
    },
    "&:focus": {
      "outline": "dashed 1px rgb(255, 255, 255)",
      "outlineOffset": "-3px"
    },
    "&::before": {
      "display": "inherit"
    },
    "&:nth-of-type(1)": {
      "left": "0",
      "borderRadius": "0.25rem 0 0 0.25rem"
    },
    "&:nth-of-type(1):not(.noIcon)::before": {
      "fontFamily": "\"dls-icons-2.31.4\"",
      "content": "\"\\eac8\"",
      "lineHeight": "1",
      "WebkitFontSmoothing": "antialiased",
      "MozOsxFontSmoothing": "grayscale"
    },
    "&:nth-of-type(2)": {
      "right": "0",
      "borderRadius": "0 0.25rem 0.25rem 0"
    },
    "&:nth-of-type(2):not(.noIcon)::before": {
      "fontFamily": "\"dls-icons-2.31.4\"",
      "content": "\"\\ead4\"",
      "lineHeight": "1",
      "WebkitFontSmoothing": "antialiased",
      "MozOsxFontSmoothing": "grayscale"
    },
    "&:nth-of-type(3)": {
      "marginLeft": "0.625rem"
    },
    "&:nth-of-type(4)": {
      "marginLeft": "0.625rem"
    },
    "&:nth-of-type(3):not(.noIcon)::before": {
      "fontFamily": "\"dls-icons-2.31.4\"",
      "content": "\"\\ea34\"",
      "lineHeight": "1",
      "WebkitFontSmoothing": "antialiased",
      "MozOsxFontSmoothing": "grayscale",
      "fontSize": "1.375rem"
    },
    "&:nth-of-type(4):not(.noIcon)::before": {
      "fontFamily": "\"dls-icons-2.31.4\"",
      "content": "\"\\ea30\"",
      "lineHeight": "1",
      "WebkitFontSmoothing": "antialiased",
      "MozOsxFontSmoothing": "grayscale",
      "fontSize": "1.375rem"
    }
  },
  "carouselControl_balancePlay": {
    "marginLeft": "3.375rem"
  },
  "carouselMultiCard__carouselInner": {
    "minHeight": "unset"
  },
  "carouselMultiCard__carouselInner_li": {
    "padding": "1.25rem 1.25rem 3rem 1.25rem"
  },
  "carouselMultiCard__carouselInner_li__row": {
    "height": "100%"
  },
  "carouselMultiCard__carouselInner_li_li": {
    "padding": "0 1rem"
  },
  "carouselSmall": {
    "maxWidth": "350px"
  },
  "carouselSmall__heroBg": {
    "backgroundPosition": "center"
  },
  "carouselSmall__carouselControls_darkControls__carouselControl": {
    "color": "#006fcf",
    "backgroundColor": "transparent"
  },
  "carouselSmall__carouselIndicators": {
    "padding": "0.8125rem 0.25rem"
  },
  "carouselSmall__overlayWhite": {
    "&::before": {
      "opacity": "0.8",
      "background": "linear-gradient(to right, white 100%, rgba(255, 255, 255, 0) 100%)"
    }
  },
  "carouselSmall__overlayBlack": {
    "&::before": {
      "opacity": "0.7",
      "background": "linear-gradient(to right, black 100%, rgba(0, 0, 0, 0) 100%)"
    }
  },
  "carouselSmall__overlayBlue": {
    "&::before": {
      "opacity": "0.7",
      "background": "linear-gradient(to right, #00175a 100%, rgba(0, 23, 90, 0) 100%)"
    }
  },
  "carouselIndicators": {
    "display": "flex",
    "listStyle": "none",
    "padding": "0.8125rem 0.3125rem",
    "backgroundColor": "rgba(0, 0, 0, 0.6)"
  },
  "carouselIndicators_li": {
    "display": "block",
    "padding": "0.3125rem",
    "position": "relative",
    "&::before": {
      "backgroundColor": "#c8c9c7",
      "borderRadius": "50%",
      "content": "\"\"",
      "display": "block",
      "height": "0.5rem",
      "position": "relative",
      "transition": "padding 0.2S ease-in-out",
      "width": "0.5rem"
    }
  },
  "carouselIndicators_li_aria_current": {
    "&::before": {
      "backgroundColor": "#fff",
      "height": "0.75rem",
      "width": "0.75rem"
    },
    "padding": "0.1875rem 0.3125rem"
  },
  "carouselItem": {
    "flexGrow": "1",
    "flexShrink": "0",
    "height": "auto",
    "minWidth": "100%",
    "order": "1",
    "position": "relative",
    "transform": "translate3d(100%, 0, 0)",
    "width": "100%",
    "zIndex": "1",
    "listStyleType": "none"
  },
  "carouselItem_button": {
    "&:focus": {
      "transition": "none",
      "outline": "dashed 1px rgb(255, 255, 255)",
      "outlineOffset": "3px"
    }
  },
  "carouselItem_aria_hidden_false": {
    "order": "0",
    "transform": "translate3d(0, 0, 0)"
  },
  "carouselItem_aria_hidden_true": {
    "visibility": "hidden"
  },
  "carouselItem_aria_hidden_true__all_children": {
    "animation": "none",
    "transition": "none"
  },
  "carouselTextOverlay": {
    "backgroundColor": "rgba(255, 255, 255, 0.9)"
  },
  "carouselMultiCard__carouselControls_darkControls__carouselIndicators": {
    "backgroundColor": "transparent"
  },
  "carouselSmall__carouselControls_darkControls__carouselIndicators": {
    "backgroundColor": "transparent"
  },
  "carouselMultiCard__carouselControls_darkControls__carouselControl": {
    "backgroundColor": "transparent"
  }
}