export default {
  "btn": {
    "border": "1px solid transparent",
    "cursor": "pointer",
    "display": "inline-block",
    "fontWeight": "normal",
    "maxWidth": "17.5rem",
    "minWidth": "11.25rem",
    "overflow": "hidden",
    "position": "relative",
    "textAlign": "center",
    "textOverflow": "ellipsis",
    "transition": "all 0.2S ease-in-out",
    "transitionProperty": "color, background-color, border-color",
    "WebkitUserSelect": "none",
    "MozUserSelect": "none",
    "userSelect": "none",
    "verticalAlign": "middle",
    "whiteSpace": "nowrap",
    "padding": "0.8125rem 1.875rem",
    "fontSize": "1rem",
    "lineHeight": "1.375rem",
    "borderRadius": "0.25rem",
    "&:focus": {
      "textDecoration": "none"
    },
    "&:hover": {
      "textDecoration": "none",
      "background": "#0069c4"
    },
    "&:disabled": {
      "boxShadow": "none",
      "cursor": "not-allowed",
      "background": "#f7f8f9 !important",
      "borderColor": "#c8c9c7 !important",
      "color": "#8e9092 !important"
    },
    "&:disabled::after": {
      "borderColor": "#c8c9c7",
      "color": "#c8c9c7"
    },
    "color": "#fff",
    "background": "#006fcf",
    "&:active": {
      "background": "#0063b9"
    }
  },
  "btnSm": {
    "padding": "0.5rem 1.25rem",
    "fontSize": "0.9375rem",
    "lineHeight": "1.375rem",
    "borderRadius": "0.1875rem",
    "maxWidth": "16.25rem",
    "minWidth": "6.875rem"
  },
  "btnUtility": {
    "padding": "0.5rem 0.625rem",
    "fontSize": "0.9375rem",
    "lineHeight": "1.375rem",
    "borderRadius": "0.1875rem",
    "maxWidth": "16.25rem",
    "minWidth": "2.75rem",
    "height": "2.5rem"
  },
  "btnSmWrapper": {
    "paddingTop": "0.125rem",
    "paddingBottom": "0.125rem",
    "outline": "none !important",
    "&:focus .btnSm": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "3px"
    },
    "&:focus .btnUtility": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "3px"
    },
    "&:disabled span": {
      "background": "#f7f8f9 !important",
      "boxShadow": "none",
      "cursor": "not-allowed",
      "borderColor": "#c8c9c7 !important",
      "color": "#8e9092 !important"
    },
    "&:disabled::after": {
      "borderColor": "#c8c9c7",
      "color": "#c8c9c7"
    }
  },
  "btnUtilityWrapper": {
    "paddingTop": "0.125rem",
    "paddingBottom": "0.125rem",
    "outline": "none !important",
    "&:focus .btnSm": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "3px"
    },
    "&:focus .btnUtility": {
      "outline": "dashed 1px #53565a",
      "outlineOffset": "3px"
    },
    "&:disabled span": {
      "background": "#f7f8f9 !important",
      "boxShadow": "none",
      "cursor": "not-allowed",
      "borderColor": "#c8c9c7 !important",
      "color": "#8e9092 !important"
    },
    "&:disabled::after": {
      "borderColor": "#c8c9c7",
      "color": "#c8c9c7"
    }
  },
  "btnSmallLabel": {
    "fontSize": "0.875rem"
  },
  "btnInline": {
    "display": "inline-block",
    "maxWidth": "none",
    "minWidth": "0",
    "verticalAlign": "top",
    "width": "auto"
  },
  "btnBlock": {
    "display": "block",
    "width": "100%"
  },
  "btnMax": {
    "width": "280px !important"
  },
  "btnOverflow": {
    "whiteSpace": "normal",
    "fontSize": "0.875rem"
  },
  "a_btn_disabled": {
    "pointerEvents": "none"
  },
  "fieldset_disabled__a_btn": {
    "pointerEvents": "none"
  },
  "btnPrimary": {
    "color": "#fff",
    "background": "#006fcf",
    "&:hover": {
      "background": "#0069c4"
    },
    "&:active": {
      "background": "#0063b9"
    }
  },
  "btnSecondary": {
    "color": "#006fcf",
    "background": "#fff",
    "borderColor": "#006fcf",
    "&:hover": {
      "color": "#0065bd",
      "background": "#f2f2f2",
      "borderColor": "#0061b6"
    },
    "&:active": {
      "color": "#005aa8",
      "background": "#e5e5e5",
      "borderColor": "#00549c"
    }
  },
  "btnTertiary": {
    "color": "#006fcf",
    "background": "transparent",
    "borderColor": "transparent",
    "&:hover": {
      "color": "#0065bd",
      "background": "#f2f2f2"
    },
    "&:active": {
      "color": "#005aa8",
      "background": "#e5e5e5"
    }
  },
  "btnContextual": {
    "background": "#fff",
    "borderColor": "#fff",
    "&:hover": {
      "background": "#f2f2f2"
    },
    "&:active": {
      "background": "#e5e5e5"
    }
  },
  "btnWhite": {
    "&:not(.btnContextual)": {
      "background": "#fff",
      "borderColor": "#fff",
      "color": "#006fcf"
    },
    "&:not(.btnContextual):hover": {
      "background": "#f2f2f2",
      "color": "#0065bd"
    },
    "&:not(.btnContextual):active": {
      "background": "#e5e5e5",
      "color": "#005aa8"
    },
    "&:not(.btnContextual):focus": {
      "outline": "dashed 1px rgb(255, 255, 255)",
      "outlineOffset": "3px"
    }
  },
  "btnWhiteSecondary": {
    "color": "#fff",
    "background": "transparent",
    "borderColor": "#fff",
    "&:hover": {
      "background": "rgba(255, 255, 255, 0.05)"
    },
    "&:active": {
      "background": "rgba(255, 255, 255, 0.1)"
    },
    "&:focus": {
      "outline": "dashed 1px rgb(255, 255, 255)",
      "outlineOffset": "3px"
    }
  },
  "btnWhiteTertiary": {
    "color": "#fff",
    "background": "transparent",
    "borderColor": "transparent",
    "&:hover": {
      "background": "rgba(255, 255, 255, 0.05)"
    },
    "&:active": {
      "background": "rgba(255, 255, 255, 0.1)"
    },
    "&:focus": {
      "outline": "dashed 1px rgb(255, 255, 255)",
      "outlineOffset": "3px"
    }
  }
}